/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.hmm.training;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.algorithms.optimization.termination.AbstractTerminationCondition;
import de.jstacs.models.hmm.training.MaxHMMTrainingParameterSet;
import de.jstacs.parameters.CollectionParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;

public class NumericalHMMTrainingParameterSet
extends MaxHMMTrainingParameterSet {
    private static final String[] algorithmStrings = new String[]{"steepest descent", "conjugate gradients (F., R.)", "conjugate gradients (P., R. positive)", "quasi newton (D., F., P.)", "quasi newton (B., F., G., S.)", "limited memory quasi newton (B., F., G., S.; n=3)", "limited memory quasi newton (B., F., G., S.; n=4)", "limited memory quasi newton (B., F., G., S.; n=5)", "limited memory quasi newton (B., F., G., S.; n=6)", "limited memory quasi newton (B., F., G., S.; n=7)", "limited memory quasi newton (B., F., G., S.; n=8)", "limited memory quasi newton (B., F., G., S.; n=9)", "limited memory quasi newton (B., F., G., S.; n=10)"};
    private static final Byte[] algorithms = new Byte[]{(byte)16, (byte)17, (byte)18, (byte)19, (byte)20, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)10};

    public NumericalHMMTrainingParameterSet() {
    }

    public NumericalHMMTrainingParameterSet(int starts, AbstractTerminationCondition tc, byte algorithm, double lineEps, double startDist, int threads) throws Exception {
        super(starts, tc);
        ((Parameter)this.parameters.get(2)).setValue(algorithmStrings[NumericalHMMTrainingParameterSet.getIndex(algorithmStrings, algorithms, Byte.valueOf(algorithm), false)]);
        ((Parameter)this.parameters.get(3)).setValue(lineEps);
        ((Parameter)this.parameters.get(4)).setValue(startDist);
        ((Parameter)this.parameters.get(5)).setValue(threads);
    }

    public NumericalHMMTrainingParameterSet(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    protected void loadParameters() throws Exception {
        super.loadParameters();
        this.parameters.add(new CollectionParameter(DataType.BYTE, algorithmStrings, algorithms, "algorithm", "the algorithm that should be used for numerical optimization", true));
        this.parameters.add(new SimpleParameter(DataType.DOUBLE, "line epsilon", "the threshold for stopping the line search in the numerical training", true, new NumberValidator<Double>(0.0, (Double)Double.MAX_VALUE)));
        this.parameters.add(new SimpleParameter(DataType.DOUBLE, "start distance", "the start distance for the line search in the numerical training", true, new NumberValidator<Double>(0.0, (Double)Double.MAX_VALUE)));
        this.parameters.add(new SimpleParameter(DataType.INT, "Threads", "The number of threads that is used during an optimization.", true, new NumberValidator<Integer>(1, 128), 1));
    }

    public byte getAlgorithm() {
        return (Byte)this.getParameterAt(2).getValue();
    }

    public double getLineEps() {
        return (Double)this.getParameterAt(3).getValue();
    }

    public double getStartDistance() {
        return (Double)this.getParameterAt(4).getValue();
    }

    public int getNumberOfThreads() {
        return (Integer)this.getParameterAt(5).getValue();
    }
}

