/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sampling;

import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sampling.AbstractBurnInTest;
import de.jstacs.sampling.VarianceRatioBurnInTestParameterSet;
import de.jstacs.utils.DoubleList;

public class VarianceRatioBurnInTest
extends AbstractBurnInTest {
    private double threshold;

    public VarianceRatioBurnInTest(VarianceRatioBurnInTestParameterSet parameters) throws CloneNotSupportedException {
        super(parameters);
        this.threshold = parameters.getThreshold();
    }

    public VarianceRatioBurnInTest(StringBuffer rep) throws NonParsableException {
        super(rep);
    }

    @Override
    protected String getXMLTag() {
        return this.getClass().getSimpleName();
    }

    @Override
    protected StringBuffer getFurtherInformation() {
        StringBuffer furtherinf = new StringBuffer(2000);
        XMLParser.appendObjectWithTags(furtherinf, this.threshold, "threshold");
        return furtherinf;
    }

    @Override
    protected void setFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.threshold = XMLParser.extractObjectForTags(xml, "threshold", Double.TYPE);
    }

    @Override
    public String getInstanceName() {
        return "Variance-Ratio burn-in test of Gelman and Rubin for " + this.values.length + " different chains with threshold " + this.threshold;
    }

    @Override
    protected int computeLengthOfBurnIn() {
        if (this.values[0].length() < 250) {
            return this.values[0].length();
        }
        int m = this.values.length;
        DoubleList meanOfchains = new DoubleList(m);
        int minL = this.values[0].length();
        int maxL = this.values[0].length();
        for (int i = 1; i < this.values.length; ++i) {
            if (this.values[i].length() < minL) {
                minL = this.values[i].length();
            }
            if (this.values[i].length() <= maxL) continue;
            maxL = this.values[i].length();
        }
        for (int it = 250; it < minL; it += 2) {
            int n = it / 2;
            int start = it - n;
            meanOfchains.clear();
            for (int i = 0; i < m; ++i) {
                meanOfchains.add(this.values[i].mean(start, it));
            }
            double meanOfChainMeans = meanOfchains.mean(0, meanOfchains.length());
            double b = 0.0;
            for (int i = 0; i < m; ++i) {
                b += (meanOfchains.get(i) - meanOfChainMeans) * (meanOfchains.get(i) - meanOfChainMeans);
            }
            b /= (double)m - 1.0;
            double w = 0.0;
            for (int i = 0; i < m; ++i) {
                for (int j = start; j < it; ++j) {
                    w += (this.values[i].get(j) - meanOfchains.get(i)) * (this.values[i].get(j) - meanOfchains.get(i));
                }
            }
            double sigma = (1.0 - 1.0 / (double)n) * (w /= (double)m * ((double)n - 1.0));
            double r = Math.sqrt((sigma += (1.0 + 1.0 / (double)m) * b) / w);
            if (!(r < this.threshold)) continue;
            return it;
        }
        return maxL;
    }
}

