/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sampling;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.sampling.AbstractBurnInTestParameterSet;
import de.jstacs.sampling.VarianceRatioBurnInTest;

public class VarianceRatioBurnInTestParameterSet
extends AbstractBurnInTestParameterSet {
    public VarianceRatioBurnInTestParameterSet() {
        super(VarianceRatioBurnInTest.class);
    }

    public VarianceRatioBurnInTestParameterSet(int starts, double t) throws Exception {
        super(VarianceRatioBurnInTest.class, starts);
        ((Parameter)this.parameters.get(1)).setValue(t);
    }

    public VarianceRatioBurnInTestParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    protected void loadParameters() throws Exception {
        super.loadParameters();
        this.parameters.add(new SimpleParameter(DataType.DOUBLE, "threshold", "the threshold value for testing the end of the burn-in phasewith the Variance-Ratio burn-in test, the value has to be greater than 1 since the tested potential scale reductionfactor R converges to 1", true, new NumberValidator<Double>(1.0, (Double)Double.MAX_VALUE), 1.2));
    }

    public double getThreshold() {
        return (Double)this.getParameterAt(1).getValue();
    }

    @Override
    public String getInstanceComment() {
        return "The parameter set for a " + VarianceRatioBurnInTest.class.getName() + ".";
    }

    @Override
    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }
}

