/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sequence;
import de.jstacs.scoringFunctions.NormalizableScoringFunction;
import de.jstacs.scoringFunctions.ScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.util.Random;

public abstract class AbstractNormalizableScoringFunction
implements NormalizableScoringFunction {
    protected static final Random r = new Random();
    protected AlphabetContainer alphabets;
    protected int length;

    public static final int getNumberOfStarts(ScoringFunction[] score) {
        int starts = score[0].getNumberOfRecommendedStarts();
        for (int i = 1; i < score.length; ++i) {
            starts = Math.max(starts, score[i].getNumberOfRecommendedStarts());
        }
        return starts;
    }

    public AbstractNormalizableScoringFunction(AlphabetContainer alphabets, int length) throws IllegalArgumentException {
        this.alphabets = alphabets;
        int l = alphabets.getPossibleLength();
        if (length < 0 || length != 0 && l != 0 && length != l) {
            throw new IllegalArgumentException("The given length could not be used. The length has to be not negative and has to match with the possible length defined by the AlphabetContainer.");
        }
        this.length = length;
    }

    public AbstractNormalizableScoringFunction(StringBuffer xml) throws NonParsableException {
        this.alphabets = null;
        this.length = -1;
        this.fromXML(xml);
        if (this.alphabets == null) {
            throw new NonParsableException("AlphabetContainer could not be parsed.");
        }
        if (this.length < 0 || this.alphabets == null) {
            throw new NonParsableException("Length could not be parsed.");
        }
    }

    @Override
    public AbstractNormalizableScoringFunction clone() throws CloneNotSupportedException {
        return (AbstractNormalizableScoringFunction)super.clone();
    }

    protected abstract void fromXML(StringBuffer var1) throws NonParsableException;

    @Override
    public final AlphabetContainer getAlphabetContainer() {
        return this.alphabets;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public final double getLogScore(Sequence seq) {
        return this.getLogScore(seq, 0);
    }

    @Override
    public final double getLogScoreAndPartialDerivation(Sequence seq, IntList indices, DoubleList partialDer) {
        return this.getLogScoreAndPartialDerivation(seq, 0, indices, partialDer);
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        return 1;
    }

    @Override
    public boolean isNormalized() {
        return false;
    }

    public static boolean isNormalized(NormalizableScoringFunction ... function) {
        int i;
        for (i = 0; i < function.length && (function[i] == null || function[i].isNormalized()); ++i) {
        }
        return i == function.length;
    }

    @Override
    public double getInitialClassParam(double classProb) {
        return Math.log(classProb) - this.getLogNormalizationConstant();
    }
}

