/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.alignment.cost;

import de.jstacs.algorithms.alignment.cost.AffineCosts;
import de.jstacs.algorithms.alignment.cost.Costs;
import de.jstacs.data.Sequence;

public class SimpleCosts
extends AffineCosts {
    private double match;
    private double mismatch;

    public SimpleCosts(double match, double mismatch, double start, double elong) {
        super(start, elong);
        if (mismatch <= 0.0) {
            throw new IllegalArgumentException("Problem: mismatch <= 0");
        }
        this.mismatch = mismatch;
        if (match > 0.0) {
            throw new IllegalArgumentException("Problem: match > 0");
        }
        this.match = match;
    }

    @Override
    public double getCostFor(Sequence s1, Sequence s2, int i, int j, Costs.Direction from) {
        if (from == Costs.Direction.TOP || from == Costs.Direction.LEFT) {
            return this.getGapCostsFor(1);
        }
        if (s1.discreteVal(i - 1) != s2.discreteVal(j - 1)) {
            return this.mismatch;
        }
        return this.match;
    }
}

