/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.data.Sequence;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.DiscreteSequence;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import javax.naming.OperationNotSupportedException;

public class MultiDimensionalDiscreteSequence
extends DiscreteSequence {
    private SimpleDiscreteSequence[] content;

    public MultiDimensionalDiscreteSequence(SequenceAnnotation[] seqAnnotations, SimpleDiscreteSequence ... sequence) throws WrongLengthException {
        super(sequence[0].getAlphabetContainer(), seqAnnotations);
        int l = sequence[0].getLength();
        for (int s = 1; s < sequence.length; ++s) {
            if (sequence[s].getLength() == l) continue;
            throw new WrongLengthException("Creating an multi-dimensional sequence, all sequence have to have the same length");
        }
        this.content = (SimpleDiscreteSequence[])sequence.clone();
        this.annotation = seqAnnotations == null ? null : (SequenceAnnotation[])seqAnnotations.clone();
    }

    @Override
    public double continuousVal(int pos) {
        return this.content[0].continuousVal(pos);
    }

    @Override
    public int discreteVal(int pos) {
        return this.content[0].discreteVal(pos);
    }

    @Override
    public void fillContainer(int[] container, int pos) {
        for (int s = 0; s < this.content.length; ++s) {
            container[s] = this.content[s].discreteVal(pos);
        }
    }

    @Override
    public int[] getEmptyContainer() {
        return new int[this.content.length];
    }

    @Override
    public int getLength() {
        return this.content[0].getLength();
    }

    @Override
    public boolean isMultiDimensional() {
        return true;
    }

    @Override
    protected Sequence<int[]> flatCloneWithoutAnnotation() {
        try {
            return new MultiDimensionalDiscreteSequence(null, this.content);
        }
        catch (WrongLengthException doesNotHappen) {
            throw new RuntimeException(doesNotHappen.getMessage());
        }
    }

    @Override
    public MultiDimensionalDiscreteSequence complement(int start, int end) throws OperationNotSupportedException {
        if (this.alphabetCon.isReverseComplementable()) {
            SimpleDiscreteSequence[] compContent = new SimpleDiscreteSequence[this.content.length];
            for (int s = 0; s < this.content.length; ++s) {
                compContent[s] = (SimpleDiscreteSequence)this.content[s].complement(start, end);
            }
            try {
                return new MultiDimensionalDiscreteSequence(null, compContent);
            }
            catch (WrongLengthException doesNotHappen) {
                throw new RuntimeException(doesNotHappen.getMessage());
            }
        }
        throw new OperationNotSupportedException("The alphabet of sequence has to be complementable.");
    }

    @Override
    public MultiDimensionalDiscreteSequence reverseComplement(int start, int end) throws OperationNotSupportedException {
        if (this.rc != null && start == 0 && end == this.getLength()) {
            return (MultiDimensionalDiscreteSequence)this.rc;
        }
        if (this.alphabetCon.isReverseComplementable()) {
            try {
                SimpleDiscreteSequence[] revCompContent = new SimpleDiscreteSequence[this.content.length];
                for (int s = 0; s < this.content.length; ++s) {
                    revCompContent[s] = (SimpleDiscreteSequence)this.content[s].reverseComplement(start, end);
                }
                MultiDimensionalDiscreteSequence revComp = new MultiDimensionalDiscreteSequence(null, revCompContent);
                if (start == 0 && end == this.getLength()) {
                    this.rc = revComp;
                    ((MultiDimensionalDiscreteSequence)this.rc).rc = this;
                }
                return revComp;
            }
            catch (Exception e) {
                RuntimeException doesNotHappen = new RuntimeException(e.getMessage());
                doesNotHappen.setStackTrace(e.getStackTrace());
                throw doesNotHappen;
            }
        }
        throw new OperationNotSupportedException("The alphabet of sequence has to be reverse-complementable.");
    }

    @Override
    protected Object getEmptyRepresentation() {
        StringBuffer[] rep = new StringBuffer[this.content.length];
        for (int i = 0; i < this.content.length; ++i) {
            rep[i] = new StringBuffer();
        }
        return rep;
    }

    @Override
    protected void addToRepresentation(Object representation, int pos, String delim) {
        for (int i = 0; i < this.content.length; ++i) {
            ((StringBuffer[])representation)[i].append(this.alphabetCon.getSymbol(pos, this.content[i].discreteVal(pos)) + delim);
        }
    }

    @Override
    protected String getStringRepresentation(Object representation) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < this.content.length; ++i) {
            res.append(((StringBuffer[])representation)[i]);
            res.append("\n");
        }
        return res.toString();
    }

    @Override
    protected int hashCodeForPos(int pos) {
        int h = 0;
        for (int i = 0; i < this.content.length; ++i) {
            h = 31 * h + this.content[i].hashCodeForPos(pos);
        }
        return h;
    }

    public SequenceAnnotation[][] getAnnotations() {
        SequenceAnnotation[][] res = new SequenceAnnotation[this.content.length][];
        for (int i = 0; i < this.content.length; ++i) {
            res[i] = this.content[i].getAnnotation();
        }
        return res;
    }
}

