/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.hmm;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.io.ArrayHandler;
import de.jstacs.models.discrete.inhomogeneous.SequenceIterator;
import de.jstacs.models.hmm.AbstractHMM;
import de.jstacs.models.hmm.HMMTrainingParameterSet;
import de.jstacs.models.hmm.models.DifferentiableHigherOrderHMM;
import de.jstacs.models.hmm.models.HigherOrderHMM;
import de.jstacs.models.hmm.models.SamplingHigherOrderHMM;
import de.jstacs.models.hmm.models.SamplingPhyloHMM;
import de.jstacs.models.hmm.states.emissions.DifferentiableEmission;
import de.jstacs.models.hmm.states.emissions.Emission;
import de.jstacs.models.hmm.states.emissions.SamplingEmission;
import de.jstacs.models.hmm.states.emissions.SilentEmission;
import de.jstacs.models.hmm.states.emissions.discrete.DiscreteEmission;
import de.jstacs.models.hmm.states.emissions.discrete.PhyloDiscreteEmission;
import de.jstacs.models.hmm.states.emissions.discrete.ReferenceSequenceDiscreteEmission;
import de.jstacs.models.hmm.training.MaxHMMTrainingParameterSet;
import de.jstacs.models.hmm.training.NumericalHMMTrainingParameterSet;
import de.jstacs.models.hmm.training.SamplingHMMTrainingParameterSet;
import de.jstacs.models.hmm.transitions.elements.TransitionElement;
import de.jstacs.models.phylo.PhyloTree;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import java.lang.reflect.Constructor;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HMMFactory {
    private static AbstractHMM getHMM(HMMTrainingParameterSet pars, String[] name, int[] emissionIdx, boolean[] forward, Emission[] emission, TransitionElement[] te, double ess, boolean likelihood) throws Exception {
        if (pars instanceof NumericalHMMTrainingParameterSet) {
            return new DifferentiableHigherOrderHMM((NumericalHMMTrainingParameterSet)pars, name, emissionIdx, forward, ArrayHandler.cast(DifferentiableEmission.class, emission), likelihood, ess, te);
        }
        if (pars instanceof SamplingHMMTrainingParameterSet) {
            if (emission instanceof PhyloDiscreteEmission[]) {
                return new SamplingPhyloHMM((SamplingHMMTrainingParameterSet)pars, name, emissionIdx, forward, ArrayHandler.cast(PhyloDiscreteEmission.class, emission), te);
            }
            return new SamplingHigherOrderHMM((SamplingHMMTrainingParameterSet)pars, name, emissionIdx, forward, ArrayHandler.cast(SamplingEmission.class, emission), te);
        }
        return new HigherOrderHMM(pars, name, emission, te);
    }

    private static void addTransitions(int[] states, double ess, double selfTranistionPart, int o, AbstractList<TransitionElement> list) {
        int[] context = new int[o];
        SequenceIterator it = new SequenceIterator(o);
        Arrays.fill(context, states.length);
        it.setBounds(context);
        double[] hyperParams = new double[states.length];
        double e = ess * (1.0 - selfTranistionPart) / (double)(states.length - 1);
        Arrays.fill(hyperParams, e);
        do {
            for (int i = 0; i < context.length; ++i) {
                context[i] = it.discreteValAt(i);
            }
            hyperParams[context[o - 1]] = ess * selfTranistionPart;
            list.add(new TransitionElement(context, states, hyperParams));
            hyperParams[context[o - 1]] = e;
        } while (it.next());
    }

    public static AbstractHMM createErgodicHMM(HMMTrainingParameterSet pars, int order, double ess, double selfTranistionPart, double expectedSequenceLength, Emission ... emission) throws Exception {
        int n = emission.length;
        String[] name = new String[n];
        int[] states = new int[n];
        for (int i = 0; i < n; ++i) {
            name[i] = "" + i;
            states[i] = i;
            if (!(emission[i] instanceof SilentEmission)) continue;
            throw new IllegalArgumentException("An ergodic HMM can not contain silent states.");
        }
        double[] hyperParams = new double[n];
        LinkedList<TransitionElement> list = new LinkedList<TransitionElement>();
        double e = ess / (double)n;
        Arrays.fill(hyperParams, e);
        list.add(new TransitionElement(null, states, hyperParams));
        for (int o = 1; o < order; ++o) {
            HMMFactory.addTransitions(states, e, selfTranistionPart, o, list);
            e /= (double)n;
        }
        HMMFactory.addTransitions(states, ess * (expectedSequenceLength - (double)order), selfTranistionPart, order, list);
        return HMMFactory.getHMM(pars, name, null, null, emission, list.toArray(new TransitionElement[0]), ess, true);
    }

    public static AbstractHMM createSunflowerHMM(HMMTrainingParameterSet pars, AlphabetContainer con, double ess, int expectedSequenceLength, boolean startCentral, int ... motifLength) throws Exception {
        return HMMFactory.createSunflowerHMM(pars, con, ess, expectedSequenceLength, startCentral, null, null, motifLength);
    }

    public static AbstractHMM createSunflowerHMM(HMMTrainingParameterSet pars, AlphabetContainer con, double ess, int expectedSequenceLength, boolean startCentral, PhyloTree[] t, double[] motifProb, int[] motifLength) throws Exception {
        int[] children;
        double[] hyperParams;
        if (motifProb == null) {
            motifProb = new double[motifLength.length];
            Arrays.fill(motifProb, 0.1 / (double)motifLength.length);
        }
        int anz = 1;
        int[] states = new int[1 + motifLength.length];
        for (int i = 0; i < motifLength.length; ++i) {
            states[1 + i] = anz;
            anz += motifLength[i];
        }
        Emission[] e = t == null ? new Emission[anz] : new PhyloDiscreteEmission[anz];
        String[] name = new String[anz];
        LinkedList<TransitionElement> list = new LinkedList<TransitionElement>();
        double[][] hyperNext = new double[motifLength.length + 1][];
        double self = 0.0;
        for (int i = 0; i < motifLength.length; ++i) {
            hyperNext[i] = new double[motifLength[i]];
            self += motifProb[i];
        }
        self = 1.0 - self;
        hyperNext[motifLength.length] = new double[1];
        double[][] stateESS = (double[][])ArrayHandler.clone((Cloneable[])hyperNext);
        if (startCentral) {
            hyperNext[motifLength.length][0] = ess;
            hyperParams = new double[]{ess};
        } else {
            hyperNext[motifLength.length][0] = ess * self;
            hyperParams = new double[anz];
            hyperParams[0] = hyperNext[motifLength.length][0];
            for (int i = 0; i < motifLength.length; ++i) {
                Arrays.fill(hyperNext[i], motifProb[i] * ess / (double)hyperNext[i].length);
                Arrays.fill(hyperParams, states[1 + i], states[1 + i] + motifLength[i], hyperNext[i][0]);
            }
        }
        if (startCentral) {
            children = new int[]{0};
        } else {
            children = new int[anz];
            for (int i = 0; i < anz; ++i) {
                children[i] = i;
            }
        }
        list.add(new TransitionElement(null, children, hyperParams));
        hyperParams = new double[motifLength.length + 1];
        for (int l = 0; l < expectedSequenceLength; ++l) {
            int i;
            double d = 0.0;
            for (i = 0; i < motifLength.length; ++i) {
                int j;
                d += hyperNext[i][motifLength[i] - 1];
                for (j = motifLength[i] - 1; j > 0; --j) {
                    double[] dArray = stateESS[i];
                    int n = j;
                    dArray[n] = dArray[n] + hyperNext[i][j];
                    hyperNext[i][j] = hyperNext[i][j - 1];
                }
                double[] dArray = stateESS[i];
                int n = j;
                dArray[n] = dArray[n] + hyperNext[i][j];
                hyperNext[i][j] = motifProb[i] * hyperNext[motifLength.length][j];
                int n2 = 1 + i;
                hyperParams[n2] = hyperParams[n2] + hyperNext[i][j];
            }
            double[] dArray = stateESS[i];
            dArray[0] = dArray[0] + hyperNext[i][0];
            hyperParams[0] = hyperParams[0] + self * hyperNext[i][0];
            hyperNext[i][0] = d + self * hyperNext[i][0];
        }
        e[0] = HMMFactory.getEmission(con, stateESS[motifLength.length][0], t == null ? null : t[0]);
        name[0] = "bg";
        list.add(new TransitionElement(new int[]{0}, states, hyperParams));
        int idx = 1;
        hyperParams = new double[1];
        for (int m = 0; m < motifLength.length; ++m) {
            hyperParams[0] = ess;
            int p = 0;
            while (p < motifLength[m]) {
                e[idx] = HMMFactory.getEmission(con, stateESS[m][p], t == null ? null : t[1]);
                name[idx] = "motif " + m + " position " + p;
                if (p == motifLength[m] - 1) {
                    list.add(new TransitionElement(new int[]{idx}, new int[]{0}, hyperParams));
                } else {
                    list.add(new TransitionElement(new int[]{idx}, new int[]{idx + 1}, hyperParams));
                }
                ++p;
                ++idx;
            }
        }
        return HMMFactory.getHMM(pars, name, null, null, e, list.toArray(new TransitionElement[0]), ess, true);
    }

    private static Emission getEmission(AlphabetContainer con, double ess, PhyloTree t) {
        if (t != null) {
            return new PhyloDiscreteEmission(con, ess, t);
        }
        return new DiscreteEmission(con, ess);
    }

    public static AbstractHMM createProfileHMM(MaxHMMTrainingParameterSet trainingParameterSet, HMMType type, boolean likelihood, int order, int numLayers, AlphabetContainer con, double ess, boolean conditionalMain, boolean closeCircle, double[][] conditionInitProbs) throws Exception {
        double[][] initFromTo = HMMFactory.getInitFromTo(type, ess);
        return HMMFactory.createProfileHMM(trainingParameterSet, initFromTo, likelihood, order, numLayers, con, ess, conditionalMain, closeCircle, conditionInitProbs);
    }

    public static AbstractHMM createProfileHMM(MaxHMMTrainingParameterSet trainingParameterSet, double[][] initFromTo, boolean likelihood, int order, int numLayers, AlphabetContainer con, double ess, boolean conditionalMain, boolean closeCircle, double[][] conditionInitProbs) throws Exception {
        PseudoTransitionElement[] coreTransitionTemplate = null;
        LinkedList<Class<? extends DifferentiableEmission>> emList = new LinkedList<Class<? extends DifferentiableEmission>>();
        ArrayList<PseudoTransitionElement> list = new ArrayList<PseudoTransitionElement>();
        LinkedList<String> nameList = new LinkedList<String>();
        int[] endContext = new int[order];
        for (int i = 0; i < order; ++i) {
            ((AbstractList)nameList).add("E" + i);
            ((AbstractList)emList).add(SilentEmission.class);
            endContext[i] = i;
        }
        int[] startContext = new int[order];
        for (int i = 0; i < order; ++i) {
            ((AbstractList)nameList).add("S" + i);
            ((AbstractList)emList).add(SilentEmission.class);
            int[] context = new int[i];
            for (int k = 0; k < i; ++k) {
                context[k] = order + k;
            }
            list.add(new PseudoTransitionElement(context, new int[]{order + i}, new double[]{ess}, true));
            startContext[i] = order + i;
        }
        ArrayList<int[]> lastLayer = new ArrayList<int[]>();
        int lastStartNodeIndex = ((AbstractCollection)emList).size() - 1;
        int offset = ((AbstractCollection)emList).size();
        HMMFactory.createProfileHMMCore(numLayers, lastLayer, initFromTo, order, emList, nameList, list, offset, lastStartNodeIndex, conditionalMain, coreTransitionTemplate, "");
        int[] states = new int[6];
        Arrays.fill(states, -1);
        states[3] = ((AbstractCollection)emList).size() - 1;
        ArrayList<int[]> newLayer = new ArrayList<int[]>();
        int i = 0;
        while (i < order) {
            HMMFactory.shiftContext(states, 3);
            states[3] = i++;
            HMMFactory.addProfileTransitions(initFromTo, order, states, list, lastLayer, newLayer);
        }
        ((AbstractList)nameList).add("F");
        ((AbstractList)emList).add(SilentEmission.class);
        if (closeCircle) {
            int i2;
            ((AbstractList)nameList).add("J");
            ((AbstractList)emList).add(DiscreteEmission.class);
            list.add(new PseudoTransitionElement(endContext, new int[]{((AbstractCollection)emList).size() - 2, ((AbstractCollection)emList).size() - 1}, new double[]{ess / 2.0, ess / 2.0}, true));
            int[] myContext = (int[])endContext.clone();
            for (i2 = 0; i2 < order; ++i2) {
                System.arraycopy(myContext, 1, myContext, 0, order - 1);
                myContext[order - 1] = ((AbstractCollection)emList).size() - 1;
                list.add(new PseudoTransitionElement(myContext, new int[]{((AbstractCollection)emList).size() - 1, order}, new double[]{ess / 2.0, ess / 2.0}, true));
            }
            myContext = (int[])endContext.clone();
            System.arraycopy(myContext, 1, myContext, 0, order - 1);
            myContext[order - 1] = ((AbstractCollection)emList).size() - 1;
            for (i2 = 0; i2 < order - 1; ++i2) {
                System.arraycopy(myContext, 1, myContext, 0, order - 1);
                myContext[order - 1] = order + i2;
                list.add(new PseudoTransitionElement(myContext, new int[]{order + i2 + 1}, new double[]{ess}, true));
            }
        } else {
            list.add(new PseudoTransitionElement(endContext, new int[]{((AbstractCollection)emList).size() - 1}, new double[]{ess}, true));
        }
        Pair<TransitionElement[], double[]> p = HMMFactory.propagateESS(ess, list);
        Emission[] em = HMMFactory.getEmissions(emList, p.getSecondElement(), con, conditionInitProbs);
        return HMMFactory.getHMM(trainingParameterSet, ((AbstractCollection)nameList).toArray(new String[0]), null, null, em, p.getFirstElement(), ess, likelihood);
    }

    private static double[][] getInitFromTo(HMMType type, double ess) {
        double[][] initFromTo = new double[3][];
        if (type == HMMType.PLAN9) {
            initFromTo[0] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
            initFromTo[1] = (double[])initFromTo[0].clone();
            initFromTo[2] = (double[])initFromTo[1].clone();
        } else if (type == HMMType.PLAN7) {
            initFromTo[0] = new double[]{Double.NaN, Double.NaN, Double.NaN, ess / 2.0, Double.NaN, ess / 2.0};
            initFromTo[1] = new double[]{Double.NaN, ess / 2.0, Double.NaN, Double.NaN, Double.NaN, ess / 2.0};
            initFromTo[2] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
        } else if (type == HMMType.PLAN8I) {
            initFromTo[0] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
            initFromTo[1] = new double[]{Double.NaN, ess / 2.0, Double.NaN, Double.NaN, Double.NaN, ess / 2.0};
            initFromTo[2] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
        } else if (type == HMMType.PLAN8D) {
            initFromTo[0] = new double[]{Double.NaN, Double.NaN, Double.NaN, ess / 2.0, Double.NaN, ess / 2.0};
            initFromTo[1] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
            initFromTo[2] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
        }
        return initFromTo;
    }

    private static DifferentiableEmission[] getEmissions(AbstractList<Class<? extends DifferentiableEmission>> emList, double[] ess, AlphabetContainer con, double[][] conditionInitAPrioriProbs) throws Exception {
        DifferentiableEmission[] em = new DifferentiableEmission[emList.size()];
        Iterator<Class<? extends DifferentiableEmission>> it = emList.iterator();
        int i = 0;
        int refIdx = 0;
        while (it.hasNext()) {
            int j;
            Class<? extends DifferentiableEmission> cl = it.next();
            if (cl == SilentEmission.class) {
                em[i] = new SilentEmission();
            } else if (cl == DiscreteEmission.class) {
                em[i] = new DiscreteEmission(con, ess[i]);
                ((DiscreteEmission)em[i]).setShape("diamond");
            } else if (cl == ReferenceSequenceDiscreteEmission.class) {
                if (conditionInitAPrioriProbs != null) {
                    double[][] conditionInitHyperpars = (double[][])ArrayHandler.clone((Cloneable[])conditionInitAPrioriProbs);
                    for (j = 0; j < conditionInitHyperpars.length; ++j) {
                        int k = 0;
                        while (k < conditionInitHyperpars[j].length) {
                            double[] dArray = conditionInitHyperpars[j];
                            int n = k++;
                            dArray[n] = dArray[n] * ess[i];
                        }
                    }
                    em[i] = new ReferenceSequenceDiscreteEmission(con, con, refIdx, ess[i], conditionInitHyperpars);
                } else {
                    em[i] = new ReferenceSequenceDiscreteEmission(con, con, refIdx, ess[i]);
                }
                ((ReferenceSequenceDiscreteEmission)em[i]).setShape("rect");
                ++refIdx;
            } else {
                Constructor<?>[] cons = cl.getConstructors();
                for (j = 0; j < cons.length; ++j) {
                    Class<?>[] pars = cons[j].getParameterTypes();
                    if (pars[0] != AlphabetContainer.class || pars[1] != Double.TYPE) continue;
                    em[i] = (DifferentiableEmission)cons[j].newInstance(con, ess[i]);
                }
                if (em[i] == null) {
                    throw new Exception("Unsupported emission class.");
                }
            }
            ++i;
        }
        return em;
    }

    private static void shiftContext(int[] context) {
        HMMFactory.shiftContext(context, 1);
    }

    private static void shiftContext(int[] context, int s) {
        System.arraycopy(context, s, context, 0, context.length - s);
    }

    private static void createProfileHMMCore(int numLayers, ArrayList<int[]> lastLayer, double[][] initFromTo, int order, AbstractList<Class<? extends DifferentiableEmission>> emList, AbstractList<String> nameList, AbstractList<PseudoTransitionElement> list, int totalOffset, int lastStartNodeIndex, boolean conditionalMain, PseudoTransitionElement[] coreTransitionTemplate, String suffix) {
        ArrayList<int[]> newLayer = new ArrayList<int[]>();
        emList.add(SilentEmission.class);
        nameList.add("D0" + suffix);
        emList.add(DiscreteEmission.class);
        nameList.add("I0" + suffix);
        int[] context = new int[order];
        for (int i = 0; i < order; ++i) {
            context[i] = lastStartNodeIndex - order + i + 1;
        }
        if (Double.isNaN(initFromTo[0][1])) {
            list.add(new PseudoTransitionElement(context, new int[]{emList.size() - 2, emList.size() - 1}, new double[]{0.5, 0.5}, false));
        } else {
            list.add(new PseudoTransitionElement(context, new int[]{emList.size() - 2}, new double[]{1.0}, false));
        }
        lastLayer.clear();
        HMMFactory.shiftContext(context);
        context[order - 1] = emList.size() - 2;
        lastLayer.add((int[])context.clone());
        if (Double.isNaN(initFromTo[0][1])) {
            context[order - 1] = emList.size() - 1;
            lastLayer.add(context);
        }
        int[] states = new int[]{-1, -1, -1, totalOffset, totalOffset + 1, -1};
        boolean[] createStates = new boolean[3];
        Arrays.fill(createStates, true);
        for (int i = 0; i < numLayers; ++i) {
            if (i == numLayers - 1) {
                for (int j = 0; j < createStates.length; ++j) {
                    createStates[j] = !Double.isNaN(initFromTo[j][3]);
                }
            }
            int last = emList.size();
            HMMFactory.createEmissions(createStates, emList, nameList, i + 1, conditionalMain, suffix);
            HMMFactory.shiftContext(states, 3);
            for (int j = 3; j < states.length; ++j) {
                states[j] = createStates[j - 3] ? last++ : -1;
            }
            HMMFactory.addProfileTransitions(initFromTo, order, states, list, lastLayer, newLayer);
        }
        emList.add(SilentEmission.class);
        nameList.add("D" + (numLayers + 1) + suffix);
        HMMFactory.shiftContext(states, 3);
        states[3] = emList.size() - 1;
        states[4] = -1;
        states[5] = -1;
        HMMFactory.addProfileTransitions(initFromTo, order, states, list, lastLayer, newLayer);
    }

    private static void addProfileTransitions(double[][] initFromTo, int order, int[] states, List<PseudoTransitionElement> allTE, List<int[]> lastLayer, List<int[]> newLayer) {
        DoubleList hyper = new DoubleList();
        DoubleList weights = new DoubleList();
        IntList children = new IntList();
        int o = order - 1;
        for (int s = 0; s < lastLayer.size(); ++s) {
            int j;
            int[] current = lastLayer.get(s);
            int k = 0;
            while (current[o] != states[k]) {
                ++k;
            }
            hyper.clear();
            weights.clear();
            children.clear();
            int a = 0;
            for (j = 0; j < initFromTo[k].length; ++j) {
                if (Double.isNaN(initFromTo[k][j]) || states[j] < 0) continue;
                hyper.add(initFromTo[k][j]);
                children.add(states[j]);
                if (j < 3) {
                    weights.add(1000.0);
                    a = children.length();
                    continue;
                }
                weights.add(1.0);
            }
            if (children.length() > 0) {
                allTE.add(new PseudoTransitionElement(current, children.toArray(), hyper.toArray(), true, weights.toArray()));
            }
            int[] next = (int[])current.clone();
            HMMFactory.shiftContext(next);
            for (j = 0; j < children.length(); ++j) {
                next[o] = children.get(j);
                HMMFactory.addConditional(next, j < a ? lastLayer : newLayer);
            }
        }
        lastLayer.clear();
        lastLayer.addAll(newLayer);
        newLayer.clear();
    }

    private static boolean addConditional(int[] context, List<int[]> list) {
        for (int i = 0; i < list.size(); ++i) {
            int j;
            int[] current = list.get(i);
            for (j = 0; j < context.length && current[j] == context[j]; ++j) {
            }
            if (j != context.length) continue;
            return false;
        }
        list.add((int[])context.clone());
        return true;
    }

    private static int createEmissions(boolean[] createState, AbstractList<Class<? extends DifferentiableEmission>> emList, AbstractList<String> nameList, int offset, boolean conditionalMain, String suffix) {
        int i = 0;
        int a = 0;
        if (createState[i]) {
            emList.add(SilentEmission.class);
            nameList.add("D" + offset + suffix);
            ++a;
        }
        if (createState[++i]) {
            emList.add(DiscreteEmission.class);
            nameList.add("I" + offset + suffix);
            ++a;
        }
        if (createState[++i]) {
            Class de = !conditionalMain ? DiscreteEmission.class : ReferenceSequenceDiscreteEmission.class;
            emList.add(de);
            nameList.add("M" + offset + suffix);
            ++a;
        }
        return a;
    }

    private static Pair<TransitionElement[], double[]> propagateESS(double ess, ArrayList<PseudoTransitionElement> list) {
        int maxOrder = 0;
        int max = 0;
        int startIdx = -1;
        IntList end = new IntList();
        for (int i = 0; i < list.size(); ++i) {
            int[] current = list.get((int)i).states;
            for (int j = 0; j < current.length; ++j) {
                max = Math.max(max, current[j]);
            }
            if (list.get((int)i).context.length == 0) {
                if (startIdx >= 0) {
                    throw new IllegalArgumentException("Multiple start transitions!");
                }
                startIdx = i;
                continue;
            }
            maxOrder = Math.max(maxOrder, list.get((int)i).context.length);
        }
        for (int t = 0; t < list.size(); ++t) {
            PseudoTransitionElement te = list.get(t);
            if (te.states.length == 0) {
                end.add(t);
            }
            for (int child = 0; child < te.states.length; ++child) {
                int[] nextContext = new int[Math.min(maxOrder, te.context.length + 1)];
                nextContext[nextContext.length - 1] = te.states[child];
                int k = 1;
                int j = nextContext.length - 2;
                while (j >= 0) {
                    nextContext[j] = te.context[te.context.length - k];
                    --j;
                    ++k;
                }
                for (int s = 0; s < list.size(); ++s) {
                    int c;
                    PseudoTransitionElement te2 = list.get(s);
                    if (nextContext.length != te2.context.length) continue;
                    for (c = 0; c < nextContext.length && nextContext[c] == te2.context[c]; ++c) {
                    }
                    if (c != nextContext.length) continue;
                    te.child[child] = s;
                    s = list.size();
                }
                if (te.child[child] != -1) continue;
                if (maxOrder == 0) {
                    te.child[child] = 0;
                    continue;
                }
                te.child[child] = list.size();
                list.add(new PseudoTransitionElement(nextContext, null, null, true));
            }
        }
        if (end.length() == 0) {
            throw new IllegalArgumentException("No absorbing state!");
        }
        double eps = 1.0E-12;
        double sum = 0.0;
        double[] cumulatedHyper = new double[list.size()];
        double[] currentHyper = new double[list.size()];
        double[] nextHyper = new double[list.size()];
        currentHyper[startIdx] = ess;
        do {
            int i;
            for (int t = 0; t < list.size(); ++t) {
                PseudoTransitionElement te = list.get(t);
                for (int child = 0; child < te.states.length; ++child) {
                    int n = te.child[child];
                    nextHyper[n] = nextHyper[n] + te.prob[child] * currentHyper[t];
                }
            }
            for (i = 0; i < cumulatedHyper.length; ++i) {
                int n = i;
                cumulatedHyper[n] = cumulatedHyper[n] + currentHyper[i];
                currentHyper[i] = nextHyper[i];
                nextHyper[i] = 0.0;
            }
            sum = 0.0;
            for (i = 0; i < currentHyper.length; ++i) {
                sum += currentHyper[i];
            }
        } while (sum > eps);
        TransitionElement[] t = new TransitionElement[list.size()];
        double[] stateESS = new double[max + 1];
        for (int i = 0; i < list.size(); ++i) {
            PseudoTransitionElement current = list.get(i);
            t[i] = new TransitionElement(current.context, current.states, current.prob, current.weights);
            if (current.context.length <= 0) continue;
            int n = current.context[current.context.length - 1];
            stateESS[n] = stateESS[n] + cumulatedHyper[i];
        }
        return new Pair<TransitionElement[], double[]>(t, stateESS);
    }

    private static class PseudoTransitionElement {
        int[] context;
        int[] states;
        int[] child;
        double[] prob;
        double[] weights;

        PseudoTransitionElement(int[] context, int[] states, double[] prob, boolean normalize) {
            this(context, states, prob, normalize, null);
        }

        PseudoTransitionElement(int[] context, int[] states, double[] prob, boolean normalize, double[] weights) {
            this.context = context == null ? new int[]{} : (int[])context.clone();
            int[] nArray = this.states = states == null ? new int[]{} : (int[])states.clone();
            if (prob == null) {
                this.prob = new double[this.states.length];
                Arrays.fill(this.prob, 1.0 / (double)this.states.length);
            } else {
                this.prob = (double[])prob.clone();
                if (normalize) {
                    Normalisation.sumNormalisation(this.prob);
                }
            }
            if (weights == null) {
                this.weights = new double[this.states.length];
                Arrays.fill(this.weights, 1.0);
            } else {
                this.weights = weights;
            }
            this.child = new int[this.states.length];
            Arrays.fill(this.child, -1);
        }

        public String toString() {
            int i;
            String str = "";
            String cont = "";
            for (i = 0; i < this.context.length - 1; ++i) {
                cont = cont + this.context[i] + ", ";
            }
            if (this.context.length > 0) {
                cont = cont + this.context[this.context.length - 1];
            }
            for (i = 0; i < this.states.length; ++i) {
                str = str + "P(" + this.states[i] + "|" + cont + ")\t= " + this.prob[i] + (i == this.states.length - 1 ? "\n" : "\t");
            }
            return str;
        }
    }

    public static enum HMMType {
        PLAN7,
        PLAN9,
        PLAN8I,
        PLAN8D;

    }
}

