/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.hmm.models;

import de.jstacs.NonParsableException;
import de.jstacs.WrongAlphabetException;
import de.jstacs.models.hmm.models.SamplingHigherOrderHMM;
import de.jstacs.models.hmm.states.emissions.discrete.PhyloDiscreteEmission;
import de.jstacs.models.hmm.training.SamplingHMMTrainingParameterSet;
import de.jstacs.models.hmm.transitions.SamplingTransition;
import de.jstacs.models.hmm.transitions.elements.TransitionElement;
import java.util.Random;

public class SamplingPhyloHMM
extends SamplingHigherOrderHMM {
    static Random r = new Random();

    public SamplingPhyloHMM(SamplingHMMTrainingParameterSet trainingParameterSet, String[] name, int[] emissionIdx, boolean[] forward, PhyloDiscreteEmission[] emission, TransitionElement ... te) throws CloneNotSupportedException, IllegalArgumentException, WrongAlphabetException, Exception {
        super(trainingParameterSet, name, emissionIdx, forward, emission, te);
    }

    public SamplingPhyloHMM(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getInstanceName() {
        return "PhyloHMM(" + this.transition.getMaximalMarkovOrder() + ")";
    }

    @Override
    protected void getNewParameters() throws Exception {
        boolean accepted = false;
        while (!accepted) {
            double acceptProb = 0.0;
            acceptProb = this.getLogProposalPosteriorFromStatistic() - this.getLogPosteriorFromStatistic();
            this.drawFromStatistics();
            acceptProb += this.getLogPosteriorFromStatistic() - this.getLogProposalPosteriorFromStatistic();
            if (!((acceptProb = Math.exp(acceptProb)) >= 1.0) && SamplingPhyloHMM.drawIndexFrom(new double[]{1.0 - acceptProb, acceptProb}) <= 0) continue;
            this.acceptParameters();
            accepted = true;
        }
    }

    private double getLogProposalPosteriorFromStatistic() {
        double logPosterior = ((SamplingTransition)this.transition).getLogPosteriorFromStatistic();
        for (int e = 0; e < this.emission.length; ++e) {
            logPosterior += ((PhyloDiscreteEmission)this.emission[e]).getLogProposalPosteriorFromStatistic();
        }
        return logPosterior;
    }

    private static int drawIndexFrom(double[] distribution) {
        int index = 0;
        for (double p = r.nextDouble(); index < distribution.length && p > distribution[index]; p -= distribution[index++]) {
        }
        if (index == distribution.length) {
            --index;
        }
        return index;
    }
}

