/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.hmm.transitions.elements;

import de.jstacs.NonParsableException;
import de.jstacs.data.Sequence;
import de.jstacs.models.hmm.transitions.elements.BasicTransitionElement;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;

public class TransitionElement
extends BasicTransitionElement {
    protected double[] probs;
    protected int offset;

    public TransitionElement(int[] context, int[] states, double[] hyperParameters) {
        this(context, states, hyperParameters, null);
    }

    public TransitionElement(int[] context, int[] states, double[] hyperParameters, double[] weight) {
        super(context, states, hyperParameters, weight);
    }

    public TransitionElement(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public TransitionElement clone() throws CloneNotSupportedException {
        TransitionElement clone = (TransitionElement)super.clone();
        clone.probs = (double[])this.probs.clone();
        return clone;
    }

    @Override
    protected void init() {
        this.probs = new double[this.parameters.length];
        super.init();
    }

    @Override
    protected void precompute() {
        this.logNorm = Normalisation.logSumNormalisation(this.parameters, 0, this.parameters.length, this.probs, 0);
    }

    public double getLogScoreAndPartialDerivation(int childIdx, IntList indices, DoubleList partialDer, Sequence sequence, int sequencePosition) {
        for (int i = 0; i < this.parameters.length; ++i) {
            indices.add(this.offset + i);
            partialDer.add((double)(childIdx == i ? 1 : 0) - this.probs[i]);
        }
        return this.parameters[childIdx] - this.logNorm;
    }

    public int setParameterOffset(int o) {
        this.offset = o;
        return this.offset + this.parameters.length;
    }

    public int fillParameters(double[] params, int offset) {
        for (int i = 0; i < this.parameters.length; ++i) {
            params[offset + i] = this.parameters[i];
        }
        return offset + this.parameters.length;
    }

    public int setParameters(double[] params, int start) {
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = params[start + i];
        }
        this.precompute();
        return start + this.parameters.length;
    }

    public void addGradientForLogPriorTerm(double[] gradient, int start) {
        int i;
        double sum = 0.0;
        for (i = 0; i < this.hyperParameters.length; ++i) {
            sum += this.hyperParameters[i];
        }
        for (i = 0; i < this.hyperParameters.length; ++i) {
            int n = start + this.offset + i;
            gradient[n] = gradient[n] + (this.hyperParameters[i] - sum * this.probs[i]);
        }
    }

    public double getMinimalHyperparameter() {
        return ToolBox.min(this.hyperParameters);
    }

    public double getLogPosteriorFromStatistic() {
        double logPost = 0.0;
        for (int i = 0; i < this.parameters.length; ++i) {
            logPost += this.statistic[i] * (this.parameters[i] - this.logNorm);
        }
        return logPost;
    }
}

