/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.mixture.motif.positionprior;

import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.models.mixture.motif.positionprior.PositionPrior;

public class GaussianLikePositionPrior
extends PositionPrior {
    private int length;
    private double max;
    private double prec;
    private double z;

    public GaussianLikePositionPrior(int length, double max, double sigma) {
        if (length < 1) {
            throw new IllegalArgumentException("The length has to be positive.");
        }
        this.length = length;
        if (max < 0.0) {
            throw new IllegalArgumentException("The maximum has to be non-negative.");
        }
        this.max = max;
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("The sigma has to be non-negative.");
        }
        this.prec = 1.0 / (2.0 * sigma * sigma);
    }

    public GaussianLikePositionPrior(StringBuffer rep) throws NonParsableException {
        super(rep);
    }

    @Override
    public void setMotifLength(int motifLength) {
        super.setMotifLength(motifLength);
        this.z = 0.0;
        int m = this.length - motifLength;
        for (int i = 0; i <= m; ++i) {
            this.z += Math.exp(-this.prec * (this.max - (double)i) * (this.max - (double)i));
        }
        this.z = Math.log(this.z);
    }

    @Override
    public double getLogPriorForPositions(int seqLength, int ... starts) throws IllegalArgumentException {
        if (seqLength == this.length && starts[0] <= this.length - this.motifLength) {
            return -this.prec * (this.max - (double)starts[0]) * (this.max - (double)starts[0]) - this.z;
        }
        throw new IllegalArgumentException("This sequence length could not be modeled.");
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    @Override
    protected StringBuffer getAdditionalInformation() {
        StringBuffer xml = new StringBuffer(1000);
        XMLParser.appendObjectWithTags(xml, this.length, "length");
        XMLParser.appendObjectWithTags(xml, this.max, "max");
        XMLParser.appendObjectWithTags(xml, this.prec, "prec");
        return xml;
    }

    @Override
    protected void extractAdditionalInformation(StringBuffer xml) throws NonParsableException {
        this.length = XMLParser.extractObjectForTags(xml, "length", Integer.TYPE);
        this.max = XMLParser.extractObjectForTags(xml, "max", Double.TYPE);
        this.prec = XMLParser.extractObjectForTags(xml, "prec", Double.TYPE);
    }
}

