/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.btMeasures;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.algorithms.graphs.MST;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.Measure;

public class BTMutualInformation
extends Measure {
    private BTMutualInformationParameterSet parameters;
    private DataSource clazz;
    private double[] ess;

    public BTMutualInformation(StringBuffer buf) throws NonParsableException {
        buf = XMLParser.extractForTag(buf, "btMutualInformation");
        this.clazz = XMLParser.extractObjectForTags(buf, "clazz", DataSource.class);
        this.ess = XMLParser.extractObjectForTags(buf, "ess", double[].class);
    }

    public BTMutualInformation(DataSource clazz, double[] ess) {
        this.clazz = clazz;
        this.ess = (double[])ess.clone();
    }

    public BTMutualInformation(BTMutualInformationParameterSet parameters) {
        this(parameters.getClazz(), parameters.getEss());
        this.parameters = parameters;
    }

    @Override
    public BTMutualInformation clone() throws CloneNotSupportedException {
        BTMutualInformation clone = (BTMutualInformation)super.clone();
        clone.ess = (double[])this.ess.clone();
        return clone;
    }

    @Override
    public String getInstanceName() {
        String str = "Bayesian tree with mutual information of";
        if (this.clazz == DataSource.FG) {
            return str + " foreground";
        }
        if (this.clazz == DataSource.BG) {
            return str + " background";
        }
        return str + " foreground and background";
    }

    @Override
    public int[][] getParents(Sample fg, Sample bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        int i;
        Sample data = null;
        double[] weights = null;
        double ess2 = 0.0;
        if (this.clazz == DataSource.FG) {
            data = fg;
            weights = weightsFg;
            ess2 = this.ess[0];
        } else if (this.clazz == DataSource.BG) {
            data = bg;
            weights = weightsBg;
            ess2 = this.ess[1];
        } else {
            data = Sample.union(fg, bg);
            weights = BTMutualInformation.union(new double[][]{weightsFg, weightsBg});
            ess2 = this.ess[0] + this.ess[1];
        }
        double[][][][] stat = BTMutualInformation.getStatistics(data, weights, length, ess2);
        double[][] mi = BTMutualInformation.getMI(stat, BTMutualInformation.sum(weights) + ess2);
        int[][] p = null;
        p = MST.kruskal(mi);
        int[][] parents = new int[length][1];
        for (i = 0; i < parents.length; ++i) {
            parents[i][0] = i;
        }
        for (i = 0; i < p.length; ++i) {
            int idx = p[i][1];
            parents[idx] = new int[2];
            parents[idx][0] = p[i][0];
            parents[idx][1] = idx;
        }
        return parents;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendObjectWithTags(buf, (Object)this.clazz, "clazz");
        XMLParser.appendObjectWithTags(buf, this.ess, "ess");
        XMLParser.addTags(buf, "btMutualInformation");
        return buf;
    }

    @Override
    public InstanceParameterSet getCurrentParameterSet() throws Exception {
        if (this.parameters != null) {
            return this.parameters;
        }
        return new BTMutualInformationParameterSet(this.clazz, this.ess);
    }

    public static class BTMutualInformationParameterSet
    extends InstanceParameterSet {
        public BTMutualInformationParameterSet() {
            super(BTMutualInformation.class);
        }

        public BTMutualInformationParameterSet(DataSource clazz, double[] ess) throws Exception {
            super(BTMutualInformation.class);
            this.loadParameters();
            ((Parameter)this.parameters.get(0)).setValue(ess[0]);
            ((Parameter)this.parameters.get(1)).setValue(ess[1]);
            ((Parameter)this.parameters.get(2)).setValue((Object)clazz);
        }

        public BTMutualInformationParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        public double[] getEss() {
            return new double[]{(Double)((Parameter)this.parameters.get(0)).getValue(), (Double)((Parameter)this.parameters.get(1)).getValue()};
        }

        public DataSource getClazz() {
            return (DataSource)((EnumParameter)this.parameters.get(2)).getValue();
        }

        @Override
        public String getInstanceComment() {
            return "Bayesian tree - mutual information";
        }

        @Override
        public String getInstanceName() {
            return "Build a Bayesian tree using mutual information as structure measure.";
        }

        @Override
        protected void loadParameters() throws Exception {
            this.initParameterList();
            this.parameters.add(new SimpleParameter(DataType.DOUBLE, "Foreground ESS", "The equivalent sample size for the foreground.", true));
            this.parameters.add(new SimpleParameter(DataType.DOUBLE, "Background ESS", "The equivalent sample size for the background, i.e. the background class or (in case of more than two classes) all non-foreground classes.", true));
            this.parameters.add(new EnumParameter(DataSource.class, "The data used to compute mutual information.", true));
        }
    }

    public static enum DataSource {
        FG,
        BG,
        BOTH;

    }
}

