/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.io.XMLParser;

public class ConfusionMatrix
implements Storable {
    private int[][] matrix;
    private int all;
    private static final String XML_TAG = "confusion matrix";

    public ConfusionMatrix(int classes) {
        this.matrix = new int[classes][classes];
        this.all = 0;
    }

    public ConfusionMatrix(StringBuffer representation) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(representation, XML_TAG);
        this.all = XMLParser.extractObjectForTags(xml, "all", Integer.TYPE);
        this.matrix = XMLParser.extractObjectForTags(xml, "matrix", int[][].class);
    }

    public void add(int realClass, int predictedClass) {
        int[] nArray = this.matrix[predictedClass];
        int n = realClass;
        nArray[n] = nArray[n] + 1;
        ++this.all;
    }

    public int[][] getMatrix() {
        int[][] res = new int[this.matrix.length][];
        for (int i = 0; i < this.matrix.length; ++i) {
            res[i] = (int[])this.matrix[i].clone();
        }
        return res;
    }

    public double getClassificationRate() {
        double correct = 0.0;
        for (int i = 0; i < this.matrix.length; ++i) {
            correct += (double)this.matrix[i][i];
        }
        return correct / (double)this.all;
    }

    public double getMisclassificationRate() {
        return 1.0 - this.getClassificationRate();
    }

    public int getCountsFor(int predictedClass, int realClass) {
        return this.matrix[predictedClass][realClass];
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(1000);
        XMLParser.appendObjectWithTags(xml, this.all, "all");
        XMLParser.appendObjectWithTags(xml, this.matrix, "matrix");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }
}

