/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.hmm.training;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.io.ParameterSetParser;
import de.jstacs.models.hmm.HMMTrainingParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.sampling.AbstractBurnInTest;
import de.jstacs.sampling.AbstractBurnInTestParameterSet;
import de.jstacs.utils.SubclassFinder;

public class SamplingHMMTrainingParameterSet
extends HMMTrainingParameterSet {
    public SamplingHMMTrainingParameterSet() {
    }

    public SamplingHMMTrainingParameterSet(int starts, int stepsPerIteration, int stationarySteps, AbstractBurnInTestParameterSet burnInTestParameters) throws SimpleParameter.IllegalValueException {
        super(starts);
        this.getParameterAt(1).setValue(stepsPerIteration);
        this.getParameterAt(2).setValue(stationarySteps);
        ((Parameter)this.parameters.get(3)).setValue(burnInTestParameters);
    }

    public SamplingHMMTrainingParameterSet(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    protected void loadParameters() throws Exception {
        super.loadParameters();
        this.parameters.add(new SimpleParameter(DataType.INT, "stepsPerIteration", "the number of steps during one iteration", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE)));
        this.parameters.add(new SimpleParameter(DataType.INT, "steps", "the total number of steps after burn-in", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE)));
        this.parameters.add(SubclassFinder.getCollection(AbstractBurnInTest.class, AbstractBurnInTest.class.getPackage().getName(), "Burn in test parameters", "the parameters used to create a burn in test", true));
    }

    public int getNumberOfStepsPerIteration() {
        return (Integer)this.getParameterAt(1).getValue();
    }

    public int getNumberOfStepsInStationaryPhase() {
        return (Integer)this.getParameterAt(2).getValue();
    }

    public AbstractBurnInTest getBurnInTest() throws ParameterSetParser.NotInstantiableException {
        return (AbstractBurnInTest)((AbstractBurnInTestParameterSet)((Parameter)this.parameters.get(3)).getValue()).getInstance();
    }
}

