/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.phylo;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.io.XMLParser;
import java.util.ArrayList;
import java.util.Arrays;

public class PhyloNode
implements Cloneable,
Storable {
    private String name;
    private double weight;
    private ArrayList<PhyloNode> children;
    private int id;
    private static final String XML_TAG = "PHYLO_NODE";

    public PhyloNode() {
        this.children = new ArrayList();
        this.id = Integer.MIN_VALUE;
        this.weight = Double.MIN_VALUE;
    }

    public PhyloNode(StringBuffer xml) throws NonParsableException {
        PhyloNode[] c;
        xml = XMLParser.extractForTag(xml, XML_TAG);
        this.name = (String)XMLParser.extractObjectForTags(xml, "name");
        this.weight = (Double)XMLParser.extractObjectForTags(xml, "weight");
        this.children = new ArrayList();
        if (XMLParser.extractObjectForTags(xml, "numberOfChildren", Integer.class) > 0 && (c = XMLParser.extractObjectForTags(xml, "children", PhyloNode[].class)).length > 0) {
            this.children.addAll(Arrays.asList(c));
        }
        this.id = (Integer)XMLParser.extractObjectForTags(xml, "id");
    }

    public PhyloNode clone() throws CloneNotSupportedException {
        PhyloNode clone = (PhyloNode)super.clone();
        ArrayList<PhyloNode> c = new ArrayList<PhyloNode>(this.children.size());
        for (PhyloNode item : this.children) {
            c.add(item.clone());
        }
        clone.children = c;
        return clone;
    }

    public void addChild(PhyloNode node) {
        this.children.add(node);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setWeight(double w) {
        this.weight = w;
    }

    public double getWeight() {
        return this.weight;
    }

    public int getNumberOfAllNodesBelow() {
        int n = 0;
        for (PhyloNode node : this.children) {
            n += node.getNumberOfAllNodesBelow() + 1;
        }
        return n;
    }

    public ArrayList<PhyloNode> getChildrenNodes() {
        return this.children;
    }

    public ArrayList<PhyloNode> getAllLeafs() {
        ArrayList<PhyloNode> l = new ArrayList<PhyloNode>();
        if (this.children.isEmpty()) {
            l.add(this);
        }
        for (PhyloNode n : this.children) {
            l.addAll(n.getAllLeafs());
        }
        return l;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.name, "name");
        XMLParser.appendObjectWithTags(xml, this.weight, "weight");
        XMLParser.appendObjectWithTags(xml, this.children.size(), "numberOfChildren");
        if (this.children.size() > 0) {
            PhyloNode[] c = this.children.toArray(new PhyloNode[0]);
            XMLParser.appendObjectWithTags(xml, c, "children");
        }
        XMLParser.appendObjectWithTags(xml, this.id, "id");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }
}

