/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.SimpleResult;

public class MeanResultSet
extends NumericalResultSet {
    private int count;
    private double[] squares;
    private SimpleResult[] infos;

    private MeanResultSet(NumericalResult[] res, SimpleResult[] infos, double[] squares, int count) {
        super(new NumericalResult[][]{res});
        this.count = count;
        this.infos = new SimpleResult[infos.length];
        this.squares = squares;
        System.arraycopy(infos, 0, this.infos, 0, infos.length);
    }

    public MeanResultSet(SimpleResult ... infos) {
        super(new NumericalResult[0][]);
        this.count = 0;
        this.infos = new SimpleResult[infos.length + 1];
        System.arraycopy(infos, 0, this.infos, 0, infos.length);
    }

    public MeanResultSet() {
        this(new SimpleResult[0]);
    }

    public MeanResultSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superSet");
        this.setCount();
        XMLParser.appendObjectWithTags(buf, this.infos, "infos");
        if (this.count > 0) {
            XMLParser.appendObjectWithTags(buf, this.squares, "squares");
        }
        XMLParser.addTags(buf, "meanResultSet");
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "meanResultSet");
        super.fromXML(XMLParser.extractForTag(representation, "superSet"));
        Storable[] infosTemp = XMLParser.extractObjectForTags(representation, "infos", Storable[].class);
        this.infos = new SimpleResult[infosTemp.length];
        for (int i = 0; i < this.infos.length; ++i) {
            this.infos[i] = (SimpleResult)infosTemp[i];
        }
        this.count = (Integer)this.infos[this.infos.length - 1].getResult();
        if (this.count > 0) {
            this.squares = XMLParser.extractObjectForTags(representation, "squares", double[].class);
        }
    }

    public static MeanResultSet addResults(MeanResultSet r1, MeanResultSet r2) throws AdditionImpossibleException {
        int i;
        if (r1.getNumberOfResults() != r2.getNumberOfResults()) {
            throw new AdditionImpossibleException();
        }
        for (i = 0; i < r1.infos.length - 1 && r1.infos[i].equals(r2.infos[i]); ++i) {
        }
        if (i != r1.infos.length - 1) {
            throw new AdditionImpossibleException();
        }
        NumericalResult[] results = new NumericalResult[r1.getNumberOfResults()];
        double[] squares = new double[r1.getNumberOfResults()];
        for (i = 0; i < results.length; ++i) {
            NumericalResult curr2;
            NumericalResult curr1 = r1.getResultAt(i);
            if (!curr1.isComparableResult(curr2 = r2.getResultAt(i))) {
                throw new AdditionImpossibleException();
            }
            squares[i] = r1.squares[i] + r2.squares[i];
            results[i] = new NumericalResult(curr1.getName(), curr1.getComment(), (Double)curr1.getResult() + (Double)curr2.getResult());
        }
        return new MeanResultSet(results, r1.infos, squares, r1.count + r2.count);
    }

    public synchronized void addResults(NumericalResultSet ... rs) throws InconsistentResultNumberException, SimpleParameter.IllegalValueException, AdditionImpossibleException {
        int i;
        int anz = 0;
        int idx = 0;
        for (i = 0; i < rs.length; ++i) {
            if (rs[i] == null) continue;
            anz += rs[i].getNumberOfResults();
        }
        if (this.count == 0) {
            this.results = new NumericalResult[anz];
            this.squares = new double[this.results.length];
        } else if (anz != this.getNumberOfResults()) {
            throw new InconsistentResultNumberException();
        }
        for (i = 0; i < rs.length; ++i) {
            idx = this.add(idx, rs[i]);
        }
        ++this.count;
    }

    private int add(int index, NumericalResultSet res) throws SimpleParameter.IllegalValueException, AdditionImpossibleException {
        if (res != null) {
            int i = 0;
            int end = res.getNumberOfResults();
            while (i < end) {
                NumericalResult curr = res.getResultAt(i);
                double currVal = 0.0;
                currVal = curr.getDatatype() == DataType.DOUBLE ? (Double)curr.getResult() : (double)((Integer)curr.getResult()).intValue();
                int n = index;
                this.squares[n] = this.squares[n] + currVal * currVal;
                if (this.results[index] == null) {
                    this.results[index] = new NumericalResult(curr.getName(), curr.getComment(), currVal);
                } else {
                    if (!this.results[index].isCastableResult(curr)) {
                        throw new AdditionImpossibleException();
                    }
                    ((NumericalResult)this.results[index]).setResult(Double.valueOf(currVal + ((Number)this.results[index].getResult()).doubleValue()));
                }
                ++i;
                ++index;
            }
        }
        return index;
    }

    public NumericalResultSet getStatistics() {
        int factor = this.count > 1 ? 2 : 1;
        NumericalResult[] resultsTemp = new NumericalResult[this.results.length * factor];
        double n = this.count;
        for (int i = 0; i < this.results.length; ++i) {
            resultsTemp[i * factor] = new NumericalResult(this.results[i].getName(), this.results[i].getComment(), (Double)this.results[i].getResult() / n);
            if (this.count <= 1) continue;
            resultsTemp[i * factor + 1] = new NumericalResult("Standard error of " + this.results[i].getName(), "Standard error of the values of " + this.results[i].getName(), Math.sqrt((this.squares[i] / n - (Double)resultsTemp[i * factor].getResult() * (Double)resultsTemp[i * factor].getResult()) / (n - 1.0)));
        }
        return new NumericalResultSet(new NumericalResult[][]{resultsTemp});
    }

    private void setCount() {
        this.infos[this.infos.length - 1] = new NumericalResult("evaluations", "the number of different results, each coming from one iteration of a crossvalidation", this.count);
    }

    public ResultSet getInfos() {
        this.setCount();
        return new ResultSet(new Result[][]{this.infos});
    }

    public static class AdditionImpossibleException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AdditionImpossibleException() {
            super("The addition is impossible, since the objects do not match.");
        }
    }

    public static class InconsistentResultNumberException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InconsistentResultNumberException() {
            super("Number of results differs.");
        }
    }
}

