/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions;

import de.jstacs.NonParsableException;
import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.EmptySampleException;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.alphabets.DiscreteAlphabetMapping;
import de.jstacs.data.sequences.MappedDiscreteSequence;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.scoringFunctions.AbstractNormalizableScoringFunction;
import de.jstacs.scoringFunctions.NormalizableScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;

public final class MappingScoringFunction
extends AbstractNormalizableScoringFunction
implements MutableMotifDiscoverer,
Mutable {
    private NormalizableScoringFunction nsf;
    private MutableMappedDiscreteSequence mappedSeq;
    private static final String XML_TAG = "MappingScoringFunction";

    public MappingScoringFunction(AlphabetContainer originalAlphabetContainer, NormalizableScoringFunction nsf, DiscreteAlphabetMapping ... mapping) throws WrongAlphabetException, CloneNotSupportedException {
        super(originalAlphabetContainer, nsf.getLength());
        this.nsf = (NormalizableScoringFunction)nsf.clone();
        this.mappedSeq = new MutableMappedDiscreteSequence(originalAlphabetContainer, mapping);
    }

    public MappingScoringFunction(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public MappingScoringFunction clone() throws CloneNotSupportedException {
        MappingScoringFunction clone = (MappingScoringFunction)super.clone();
        clone.nsf = (NormalizableScoringFunction)this.nsf.clone();
        try {
            clone.mappedSeq = new MutableMappedDiscreteSequence(this.alphabets, this.mappedSeq.getTransformations());
            clone.mappedSeq.setSequence(this.mappedSeq.getOriginalSequence());
        }
        catch (WrongAlphabetException wae) {
            throw new CloneNotSupportedException(wae.getMessage());
        }
        return clone;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.alphabets, "alphabets");
        XMLParser.appendObjectWithTags(xml, this.nsf, "nsf");
        XMLParser.appendObjectWithTags(xml, this.mappedSeq.getTransformations(), "transformations");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, XML_TAG);
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabets");
        this.nsf = (NormalizableScoringFunction)XMLParser.extractObjectForTags(xml, "nsf");
        this.length = this.nsf.getLength();
        try {
            this.mappedSeq = new MutableMappedDiscreteSequence(this.alphabets, XMLParser.extractObjectForTags(xml, "transformations", DiscreteAlphabetMapping[].class));
        }
        catch (WrongAlphabetException e) {
            throw new NonParsableException();
        }
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        this.nsf.addGradientOfLogPriorTerm(grad, start);
    }

    @Override
    public double getEss() {
        return this.nsf.getEss();
    }

    @Override
    public double getLogNormalizationConstant() {
        return this.nsf.getLogNormalizationConstant();
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return this.nsf.getLogPartialNormalizationConstant(parameterIndex);
    }

    @Override
    public double getLogPriorTerm() {
        return this.nsf.getLogPriorTerm();
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        throw new RuntimeException();
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        return this.nsf.getCurrentParameterValues();
    }

    @Override
    public String getInstanceName() {
        return "MappingScoringFunction for " + this.nsf.getInstanceName();
    }

    @Override
    public double getLogScore(Sequence seq, int start) {
        this.mappedSeq.setSequence(seq);
        return this.nsf.getLogScore(this.mappedSeq, start) - this.mappedSeq.getLogNumberOfPossibleOriginalSequences(start, this.length == 0 ? seq.getLength() : start + this.length);
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        this.mappedSeq.setSequence(seq);
        return this.nsf.getLogScoreAndPartialDerivation(this.mappedSeq, start, indices, partialDer) - this.mappedSeq.getLogNumberOfPossibleOriginalSequences(start, this.length == 0 ? seq.getLength() : start + this.length);
    }

    @Override
    public int getNumberOfParameters() {
        return this.nsf.getNumberOfParameters();
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, Sample[] data, double[][] weights) throws Exception {
        Sample[] mappedData = this.getMappedData(data);
        this.nsf.initializeFunction(index, freeParams, mappedData, weights);
        for (int i = 0; i < data.length; ++i) {
            mappedData[i] = null;
        }
        mappedData = null;
        System.gc();
    }

    private Sample[] getMappedData(Sample ... data) throws WrongAlphabetException, EmptySampleException {
        Sample[] mappedData = new Sample[data.length];
        DiscreteAlphabetMapping[] transformation = this.mappedSeq.getTransformations();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) continue;
            Sequence[] seqs = new Sequence[data[i].getNumberOfElements()];
            for (int n = 0; n < seqs.length; ++n) {
                seqs[n] = new MappedDiscreteSequence((SimpleDiscreteSequence)data[i].getElementAt(n), transformation);
            }
            mappedData[i] = new Sample("mapped: " + data[i].getAnnotation(), seqs);
        }
        return mappedData;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        this.nsf.initializeFunctionRandomly(freeParams);
    }

    @Override
    public boolean isInitialized() {
        return this.nsf.isInitialized();
    }

    @Override
    public void setParameters(double[] params, int start) {
        this.nsf.setParameters(params, start);
    }

    public String toString() {
        return this.getInstanceName() + "\n" + this.nsf.toString();
    }

    public NormalizableScoringFunction getFunction() throws CloneNotSupportedException {
        return (NormalizableScoringFunction)this.nsf.clone();
    }

    @Override
    public int getNumberOfMotifs() {
        if (this.nsf instanceof MotifDiscoverer) {
            return ((MotifDiscoverer)((Object)this.nsf)).getNumberOfMotifs();
        }
        return 0;
    }

    @Override
    public void adjustHiddenParameters(int index, Sample[] data, double[][] weights) throws Exception {
        if (this.nsf instanceof MutableMotifDiscoverer) {
            Sample[] mappedData = this.getMappedData(data);
            ((MutableMotifDiscoverer)((Object)this.nsf)).adjustHiddenParameters(index, mappedData, weights);
            for (int i = 0; i < data.length; ++i) {
                mappedData[i] = null;
            }
            mappedData = null;
            System.gc();
        }
    }

    @Override
    public void initializeMotif(int motifIndex, Sample data, double[] weights) throws Exception {
        if (this.nsf instanceof MutableMotifDiscoverer) {
            Sample[] mappedData = this.getMappedData(data);
            ((MutableMotifDiscoverer)((Object)this.nsf)).initializeMotif(motifIndex, mappedData[0], weights);
            mappedData[0] = null;
            mappedData = null;
            System.gc();
        }
    }

    @Override
    public void initializeMotifRandomly(int motif) throws Exception {
        if (this.nsf instanceof MutableMotifDiscoverer) {
            ((MutableMotifDiscoverer)((Object)this.nsf)).initializeMotifRandomly(motif);
        }
    }

    @Override
    public boolean modifyMotif(int motifIndex, int offsetLeft, int offsetRight) throws Exception {
        if (this.nsf instanceof MutableMotifDiscoverer) {
            return ((MutableMotifDiscoverer)((Object)this.nsf)).modifyMotif(motifIndex, offsetLeft, offsetRight);
        }
        return false;
    }

    @Override
    public int getGlobalIndexOfMotifInComponent(int component, int motif) {
        if (this.nsf instanceof MotifDiscoverer) {
            return ((MotifDiscoverer)((Object)this.nsf)).getGlobalIndexOfMotifInComponent(component, motif);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getIndexOfMaximalComponentFor(Sequence sequence) throws Exception {
        if (this.nsf instanceof MotifDiscoverer) {
            this.mappedSeq.setSequence(sequence);
            return ((MotifDiscoverer)((Object)this.nsf)).getIndexOfMaximalComponentFor(this.mappedSeq);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getMotifLength(int motif) {
        if (this.nsf instanceof MotifDiscoverer) {
            return ((MotifDiscoverer)((Object)this.nsf)).getMotifLength(motif);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getNumberOfComponents() {
        if (this.nsf instanceof MotifDiscoverer) {
            return ((MotifDiscoverer)((Object)this.nsf)).getNumberOfComponents();
        }
        return 1;
    }

    @Override
    public int getNumberOfMotifsInComponent(int component) {
        if (this.nsf instanceof MotifDiscoverer) {
            return ((MotifDiscoverer)((Object)this.nsf)).getNumberOfMotifsInComponent(component);
        }
        if (component > 0) {
            throw new IllegalArgumentException();
        }
        return 1;
    }

    @Override
    public double[] getProfileOfScoresFor(int component, int motif, Sequence sequence, int startpos, MotifDiscoverer.KindOfProfile kind) throws Exception {
        if (this.nsf instanceof MotifDiscoverer) {
            this.mappedSeq.setSequence(sequence);
            double[] res = ((MotifDiscoverer)((Object)this.nsf)).getProfileOfScoresFor(component, motif, this.mappedSeq, startpos, kind);
            double norm = this.mappedSeq.getLogNumberOfPossibleOriginalSequences(startpos, this.length == 0 ? sequence.getLength() : startpos + this.length);
            int i = 0;
            while (i < res.length) {
                int n = i++;
                res[n] = res[n] - norm;
            }
            return res;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double[] getStrandProbabilitiesFor(int component, int motif, Sequence sequence, int startpos) throws Exception {
        if (this.nsf instanceof MotifDiscoverer) {
            this.mappedSeq.setSequence(sequence);
            return ((MotifDiscoverer)((Object)this.nsf)).getStrandProbabilitiesFor(component, motif, this.mappedSeq, startpos);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean modify(int offsetLeft, int offsetRight) {
        if (this.nsf instanceof Mutable) {
            return ((Mutable)((Object)this.nsf)).modify(offsetLeft, offsetRight);
        }
        return false;
    }

    private static final class MutableMappedDiscreteSequence
    extends MappedDiscreteSequence {
        private MutableMappedDiscreteSequence(AlphabetContainer originalAlphabetContainer, DiscreteAlphabetMapping[] transformation) throws WrongAlphabetException {
            super(originalAlphabetContainer, null, transformation);
        }

        private void setSequence(Sequence original) throws IllegalArgumentException {
            if (original == null || !(original instanceof SimpleDiscreteSequence) || !this.originalAlphabetContainer.checkConsistency(original.getAlphabetContainer())) {
                throw new IllegalArgumentException();
            }
            this.original = (SimpleDiscreteSequence)original;
        }

        private DiscreteAlphabetMapping[] getTransformations() {
            return (DiscreteAlphabetMapping[])this.transformation.clone();
        }

        private SimpleDiscreteSequence getOriginalSequence() {
            return this.original;
        }
    }
}

