/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.mix;

import de.jstacs.NonParsableException;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.AbstractNormalizableScoringFunction;
import de.jstacs.scoringFunctions.NormalizableScoringFunction;
import de.jstacs.scoringFunctions.NormalizedScoringFunction;
import de.jstacs.scoringFunctions.mix.motifSearch.DurationScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.util.Arrays;

public abstract class AbstractMixtureScoringFunction
extends AbstractNormalizableScoringFunction {
    private int starts;
    protected int[] paramRef;
    protected boolean optimizeHidden;
    protected boolean freeParams;
    private boolean plugIn;
    protected NormalizableScoringFunction[] function;
    protected double[] hiddenParameter;
    protected double[] logHiddenPotential;
    protected double[] hiddenPotential;
    protected double[] componentScore;
    protected double[] partNorm;
    protected double norm;
    protected double logHiddenNorm;
    protected double logGammaSum;
    protected DoubleList[] dList;
    protected IntList[] iList;
    private boolean isNormalized;

    protected AbstractMixtureScoringFunction(int length, int starts, int dimension, boolean optimizeHidden, boolean plugIn, NormalizableScoringFunction ... function) throws CloneNotSupportedException {
        super(function[0].getAlphabetContainer(), length);
        this.function = (NormalizableScoringFunction[])ArrayHandler.clone((Cloneable[])function);
        if (starts < 1) {
            throw new IllegalArgumentException("The number of recommended starts has to be positive.");
        }
        this.starts = starts;
        if (dimension == 0) {
            throw new IllegalArgumentException("The number of components has to be positive.");
        }
        this.isNormalized = this.determineIsNormalized();
        this.hiddenParameter = new double[dimension];
        this.logHiddenPotential = new double[dimension];
        this.hiddenPotential = new double[dimension];
        this.partNorm = new double[dimension];
        this.setHiddenParameters(this.hiddenParameter, 0);
        this.componentScore = new double[dimension];
        this.optimizeHidden = optimizeHidden && dimension > 1;
        this.plugIn = plugIn;
        this.paramRef = null;
        this.init(this.freeParams);
        this.norm = Double.NaN;
    }

    protected void computeLogGammaSum() {
        this.logGammaSum = 0.0;
        int n = this.getNumberOfComponents();
        if (n > 1 && this.getEss() > 0.0) {
            double sum = 0.0;
            for (int i = 0; i < n; ++i) {
                double h = this.getHyperparameterForHiddenParameter(i);
                sum += h;
                this.logGammaSum -= Gamma.logOfGamma((double)h);
            }
            this.logGammaSum += Gamma.logOfGamma((double)sum);
        }
    }

    protected AbstractMixtureScoringFunction(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public AbstractMixtureScoringFunction clone() throws CloneNotSupportedException {
        AbstractMixtureScoringFunction clone = (AbstractMixtureScoringFunction)super.clone();
        clone.cloneFunctions(this.function);
        clone.hiddenParameter = (double[])this.hiddenParameter.clone();
        clone.logHiddenPotential = (double[])this.logHiddenPotential.clone();
        clone.hiddenPotential = (double[])this.hiddenPotential.clone();
        clone.componentScore = (double[])this.componentScore.clone();
        clone.partNorm = (double[])this.partNorm.clone();
        clone.iList = null;
        clone.paramRef = null;
        clone.init(this.freeParams);
        return clone;
    }

    protected void cloneFunctions(NormalizableScoringFunction[] originalFunctions) throws CloneNotSupportedException {
        this.function = (NormalizableScoringFunction[])ArrayHandler.clone((Cloneable[])originalFunctions);
    }

    public abstract double getHyperparameterForHiddenParameter(int var1);

    @Override
    public double getLogPriorTerm() {
        int i;
        double val = 0.0;
        double sum = 0.0;
        for (i = 0; i < this.hiddenParameter.length; ++i) {
            double h = this.getHyperparameterForHiddenParameter(i);
            sum += h;
            val += this.hiddenParameter[i] * h;
        }
        if (this.isNormalized()) {
            val -= sum * this.logHiddenNorm;
        }
        for (i = 0; i < this.function.length; ++i) {
            if (this.function[i] == null) continue;
            val += this.function[i].getLogPriorTerm();
        }
        return val + this.logGammaSum;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        int i;
        for (i = 0; i < this.function.length; ++i) {
            if (this.function[i] == null) continue;
            this.function[i].addGradientOfLogPriorTerm(grad, start + this.paramRef[i]);
        }
        int j = start + this.paramRef[this.function.length + 1];
        start += this.paramRef[this.function.length];
        double e = this.getEss();
        i = 0;
        while (start < j) {
            int n = start;
            grad[n] = grad[n] + (this.getHyperparameterForHiddenParameter(i) - (this.isNormalized() ? e * this.hiddenPotential[i] : 0.0));
            ++i;
            ++start;
        }
    }

    public int getIndexOfMaximalComponentFor(Sequence seq, int start) {
        this.fillComponentScores(seq, start);
        return ToolBox.getMaxIndex(this.componentScore);
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        int numPars = this.getNumberOfParameters();
        if (numPars == -1) {
            throw new Exception("No parameters exists, yet.");
        }
        double[] current = new double[numPars];
        int j = this.function.length;
        for (int i = 0; i < j; ++i) {
            if (this.function[i] == null) continue;
            double[] part = this.function[i].getCurrentParameterValues();
            System.arraycopy(part, 0, current, this.paramRef[i], part.length);
        }
        System.arraycopy(this.hiddenParameter, 0, current, this.paramRef[j], this.paramRef[j + 1] - this.paramRef[j]);
        return current;
    }

    @Override
    public double getLogScore(Sequence seq, int start) {
        this.fillComponentScores(seq, start);
        return Normalisation.getLogSum(this.componentScore);
    }

    @Override
    public final double getLogNormalizationConstant() {
        if (this.isNormalized()) {
            return 0.0;
        }
        if (Double.isNaN(this.norm)) {
            this.precomputeNorm();
        }
        return this.norm;
    }

    public final int getNumberOfComponents() {
        return this.componentScore.length;
    }

    @Override
    public final int getNumberOfParameters() {
        if (this.paramRef == null) {
            return -1;
        }
        return this.paramRef[this.paramRef.length - 1];
    }

    @Override
    public final int getNumberOfRecommendedStarts() {
        return this.starts;
    }

    public double[] getProbsForComponent(Sequence seq) {
        this.fillComponentScores(seq, 0);
        double[] p = new double[this.componentScore.length];
        Normalisation.logSumNormalisation(this.componentScore, 0, p.length, p, 0);
        return p;
    }

    public NormalizableScoringFunction[] getScoringFunctions() throws CloneNotSupportedException {
        return (NormalizableScoringFunction[])ArrayHandler.clone((Cloneable[])this.function);
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        int[] ind = this.getIndices(index);
        if (ind[0] == this.function.length) {
            return this.hiddenParameter.length;
        }
        return this.function[ind[0]].getSizeOfEventSpaceForRandomVariablesOfParameter(ind[1]);
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, Sample[] data, double[][] weights) throws Exception {
        if (this.plugIn) {
            this.initializeUsingPlugIn(index, freeParams, data, weights);
            this.init(freeParams);
        } else {
            this.initializeFunctionRandomly(freeParams);
        }
    }

    protected abstract void initializeUsingPlugIn(int var1, boolean var2, Sample[] var3, double[][] var4) throws Exception;

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        for (int i = 0; i < this.function.length; ++i) {
            if (this.function[i] == null) continue;
            this.function[i].initializeFunctionRandomly(freeParams);
        }
        if (this.optimizeHidden) {
            this.initializeHiddenPotentialRandomly();
        }
        this.init(freeParams);
    }

    protected void initializeHiddenPotentialRandomly() {
        double[] h = new double[this.getNumberOfComponents()];
        if (this.getEss() == 0.0) {
            Arrays.fill(h, 1.0);
        } else {
            for (int j = 0; j < h.length; ++j) {
                h[j] = this.getHyperparameterForHiddenParameter(j);
            }
        }
        DirichletMRGParams param = new DirichletMRGParams(h);
        DirichletMRG.DEFAULT_INSTANCE.generate(this.hiddenPotential, 0, this.hiddenPotential.length, param);
        this.computeHiddenParameter(this.hiddenPotential, false);
    }

    @Override
    public boolean isInitialized() {
        int i;
        for (i = 0; i < this.function.length && (this.function[i] == null || this.function[i].isInitialized()); ++i) {
        }
        return this.paramRef != null && i == this.function.length;
    }

    @Override
    public void setParameters(double[] params, int start) {
        int i;
        for (i = 0; i < this.function.length; ++i) {
            if (this.function[i] == null) continue;
            this.setParametersForFunction(i, params, start + this.paramRef[i]);
        }
        this.isNormalized = this.determineIsNormalized();
        if (this.optimizeHidden) {
            this.setHiddenParameters(params, start + this.paramRef[i]);
        } else {
            this.norm = this.isNormalized ? 0.0 : Double.NaN;
        }
    }

    protected boolean determineIsNormalized() {
        return AbstractMixtureScoringFunction.isNormalized(this.function);
    }

    public void initializeHiddenUniformly() {
        int i;
        int c = this.getNumberOfComponents();
        for (i = 0; i < this.function.length; ++i) {
            if (this.function[i] == null) continue;
            if (this.function[i] instanceof AbstractMixtureScoringFunction) {
                ((AbstractMixtureScoringFunction)this.function[i]).initializeHiddenUniformly();
                continue;
            }
            if (this.function[i] instanceof NormalizedScoringFunction) {
                ((NormalizedScoringFunction)this.function[i]).initializeHiddenUniformly();
                continue;
            }
            if (!(this.function[i] instanceof DurationScoringFunction)) continue;
            ((DurationScoringFunction)this.function[i]).initializeUniformly();
        }
        if (this.optimizeHidden) {
            double[] pars = new double[c];
            double d = this.freeParams ? this.getLogNormalizationConstantForComponent(c) : 0.0;
            for (i = 0; i < c; ++i) {
                pars[i] = d - this.getLogNormalizationConstantForComponent(i);
            }
            this.setHiddenParameters(pars, 0);
        }
        this.init(this.freeParams);
    }

    protected void setHiddenParameters(double[] params, int start) {
        int len = this.hiddenParameter.length - (this.freeParams ? 1 : 0);
        int i = 0;
        while (i < len) {
            this.hiddenParameter[i] = params[start];
            ++i;
            ++start;
        }
        if (this.freeParams) {
            this.hiddenParameter[i] = 0.0;
        }
        if (this.isNormalized()) {
            this.logHiddenNorm = Normalisation.getLogSum(this.hiddenParameter);
            this.norm = 0.0;
        } else {
            this.logHiddenNorm = 0.0;
            this.norm = Double.NaN;
        }
        for (i = 0; i < this.logHiddenPotential.length; ++i) {
            this.logHiddenPotential[i] = this.hiddenParameter[i] - this.logHiddenNorm;
            this.hiddenPotential[i] = Math.exp(this.logHiddenPotential[i]);
            this.partNorm[i] = this.logHiddenPotential[i];
        }
    }

    protected void setParametersForFunction(int index, double[] params, int start) {
        this.function[index].setParameters(params, start);
    }

    @Override
    public final StringBuffer toXML() {
        StringBuffer b = new StringBuffer(10000);
        XMLParser.appendObjectWithTags(b, this.length, "length");
        XMLParser.appendObjectWithTags(b, this.starts, "starts");
        XMLParser.appendObjectWithTags(b, this.freeParams, "freeParams");
        XMLParser.appendObjectWithTags(b, this.function, "function");
        XMLParser.appendObjectWithTags(b, this.optimizeHidden, "optimizeHidden");
        XMLParser.appendObjectWithTags(b, this.plugIn, "plugIn");
        XMLParser.appendObjectWithTags(b, this.hiddenParameter, "hiddenParameter");
        b.append(this.getFurtherInformation());
        XMLParser.addTags(b, this.getXMLTag());
        return b;
    }

    @Override
    protected final void fromXML(StringBuffer b) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(b, this.getXMLTag());
        this.length = XMLParser.extractObjectForTags(xml, "length", Integer.TYPE);
        this.starts = XMLParser.extractObjectForTags(xml, "starts", Integer.TYPE);
        this.freeParams = XMLParser.extractObjectForTags(xml, "freeParams", Boolean.TYPE);
        this.function = XMLParser.extractObjectForTags(xml, "function", NormalizableScoringFunction[].class);
        this.alphabets = this.function[0].getAlphabetContainer();
        this.optimizeHidden = XMLParser.extractObjectForTags(xml, "optimizeHidden", Boolean.TYPE);
        this.plugIn = XMLParser.extractObjectForTags(xml, "plugIn", Boolean.TYPE);
        this.hiddenParameter = XMLParser.extractObjectForTags(xml, "hiddenParameter", double[].class);
        this.hiddenPotential = new double[this.hiddenParameter.length];
        this.logHiddenPotential = new double[this.hiddenParameter.length];
        this.partNorm = new double[this.hiddenParameter.length];
        this.componentScore = new double[this.hiddenParameter.length];
        this.extractFurtherInformation(xml);
        this.isNormalized = this.determineIsNormalized();
        this.setHiddenParameters(this.hiddenParameter, 0);
        this.norm = Double.NaN;
        this.init(this.freeParams);
        this.computeLogGammaSum();
    }

    protected StringBuffer getFurtherInformation() {
        return new StringBuffer(1);
    }

    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
    }

    protected int[] getIndices(int index) {
        int[] erg = new int[]{0, -1};
        while (index >= this.paramRef[erg[0]]) {
            erg[0] = erg[0] + 1;
        }
        erg[0] = erg[0] - 1;
        erg[1] = index - this.paramRef[erg[0]];
        return erg;
    }

    protected String getXMLTag() {
        return this.getClass().getSimpleName();
    }

    protected void init(boolean freeParams) {
        this.initWithLength(freeParams, this.function.length + 2);
    }

    protected final void initWithLength(boolean freeParams, int len) {
        int i;
        if (this.paramRef == null || this.paramRef.length != len) {
            this.paramRef = new int[len];
        }
        if (this.iList == null) {
            this.iList = new IntList[Math.max(this.function.length, this.hiddenParameter.length)];
            this.dList = new DoubleList[this.iList.length];
            for (i = 0; i < this.iList.length; ++i) {
                this.iList[i] = new IntList();
                this.dList[i] = new DoubleList();
            }
        }
        for (i = 0; i < this.function.length; ++i) {
            int h;
            int n = h = this.function[i] == null ? 0 : this.function[i].getNumberOfParameters();
            if (h == -1) {
                this.paramRef = null;
                return;
            }
            this.paramRef[i + 1] = this.paramRef[i] + h;
        }
        this.paramRef[i + 1] = this.optimizeHidden ? this.paramRef[i] + this.hiddenParameter.length - (freeParams ? 1 : 0) : this.paramRef[i];
        this.freeParams = freeParams;
    }

    protected void computeHiddenParameter(double[] statistic, boolean add) {
        int i;
        int j = this.hiddenParameter.length;
        double sum = 0.0;
        double offset = 0.0;
        for (i = 0; i < j; ++i) {
            if (add) {
                int n = i;
                statistic[n] = statistic[n] + this.getHyperparameterForHiddenParameter(i);
            }
            sum += statistic[i];
        }
        sum = Math.log(sum);
        if (this.freeParams) {
            offset = Math.log(statistic[--j]) - sum - this.getLogNormalizationConstantForComponent(j);
            this.hiddenParameter[j] = 0.0;
        }
        for (i = 0; i < j; ++i) {
            this.hiddenParameter[i] = Math.log(statistic[i]) - sum - this.getLogNormalizationConstantForComponent(i) - offset;
        }
        this.setHiddenParameters(this.hiddenParameter, 0);
    }

    protected void precomputeNorm() {
        for (int i = 0; i < this.hiddenPotential.length; ++i) {
            this.partNorm[i] = this.logHiddenPotential[i] + this.getLogNormalizationConstantForComponent(i);
        }
        this.norm = Normalisation.getLogSum(this.partNorm);
    }

    protected abstract double getLogNormalizationConstantForComponent(int var1);

    protected abstract void fillComponentScores(Sequence var1, int var2);

    @Override
    public final boolean isNormalized() {
        return this.isNormalized;
    }

    public NormalizableScoringFunction getFunction(int index) throws CloneNotSupportedException {
        return this.function[index] != null ? (NormalizableScoringFunction)this.function[index].clone() : null;
    }

    public NormalizableScoringFunction[] getFunctions() throws CloneNotSupportedException {
        return (NormalizableScoringFunction[])ArrayHandler.clone((Cloneable[])this.function);
    }
}

