/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.mix.motifSearch;

public class CDFOfNormal {
    private static final double[] a = new double[]{2.2352520354606837, 161.02823106855587, 1067.6894854603709, 18154.98125334356, 0.06568233791820745};
    private static final double[] b = new double[]{47.202581904688245, 976.0985517377767, 10260.932208618979, 45507.78933502673};
    private static final double[] c = new double[]{0.39894151208813466, 8.883149794388377, 93.50665613217785, 597.2702763948002, 2494.5375852903726, 6848.190450536283, 11602.65143764735, 9842.714838383978, 1.0765576773720192E-8};
    private static final double[] d = new double[]{22.266688044328117, 235.387901782625, 1519.3775994075547, 6485.558298266761, 18615.571640885097, 34900.95272114598, 38912.00328609327, 19685.429676859992};
    private static final double[] p = new double[]{0.215898534057957, 0.12740116116024736, 0.022235277870649807, 0.0014216191932278934, 2.9112874951168793E-5, 0.023073441764940174};
    private static final double[] q = new double[]{1.284260096144911, 0.4682382124808651, 0.06598813786892856, 0.0037823963320275824, 7.297515550839662E-5};
    private static final double M_SQRT_32 = Math.sqrt(32.0);
    private static final double M_1_SQRT_2PI = 1.0 / Math.sqrt(Math.PI * 2);

    public static double getLogCDF(double x) {
        double cum;
        boolean negative;
        double eps = 5.0E-6;
        double xAbs = Math.abs(x);
        boolean bl = negative = x < 0.0;
        if (xAbs <= 0.67448975) {
            double xden;
            double xnum;
            if (xAbs > eps) {
                double xsq = x * x;
                xnum = a[4] * xsq;
                xden = xsq;
                for (int i = 0; i < 3; ++i) {
                    xnum = (xnum + a[i]) * xsq;
                    xden = (xden + b[i]) * xsq;
                }
            } else {
                xden = 0.0;
                xnum = 0.0;
            }
            double temp = x * (xnum + a[3]) / (xden + b[3]);
            cum = Math.log(0.5 + temp);
        } else if (xAbs <= M_SQRT_32) {
            double xnum = c[8] * xAbs;
            double xden = xAbs;
            for (int i = 0; i < 7; ++i) {
                xnum = (xnum + c[i]) * xAbs;
                xden = (xden + d[i]) * xAbs;
            }
            double temp = (xnum + c[7]) / (xden + d[7]);
            cum = CDFOfNormal.compute(xAbs, temp, negative);
        } else {
            double xsq = 1.0 / (x * x);
            double xnum = p[5] * xsq;
            double xden = xsq;
            for (int i = 0; i < 4; ++i) {
                xnum = (xnum + p[i]) * xsq;
                xden = (xden + q[i]) * xsq;
            }
            double temp = xsq * (xnum + p[4]) / (xden + q[4]);
            temp = (M_1_SQRT_2PI - temp) / xAbs;
            cum = CDFOfNormal.compute(x, temp, negative);
        }
        return cum;
    }

    private static double compute(double xAbs, double temp, boolean negative) {
        double xSq = Math.floor(xAbs * 16.0) / 16.0;
        double t = -0.5 * (xSq * xSq + (xAbs - xSq) * (xAbs + xSq));
        if (negative) {
            return t + Math.log(temp);
        }
        return Math.log1p(-Math.exp(t) * temp);
    }
}

