/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.ontology.InvalidTermException;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.SimpleBioEntry;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.SimpleRichFeature;

public class ThinRichSequence
extends SimpleBioEntry
implements RichSequence {
    private static final String ISCIRCULAR = "X";
    private Set features = new TreeSet();
    private Double symListVersion;
    private boolean circular;
    private Alphabet alphabet;
    private int length = 0;

    public ThinRichSequence(Namespace ns, String name, String accession, int version, Alphabet alpha, Double seqversion) {
        super(ns, name, accession, version);
        this.symListVersion = seqversion;
        this.circular = false;
        this.alphabet = alpha;
    }

    protected ThinRichSequence() {
    }

    public Double getSeqVersion() {
        return this.symListVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeqVersion(Double seqVersion) throws ChangeVetoException {
        if (!this.hasListeners(RichSequence.SYMLISTVERSION)) {
            this.symListVersion = seqVersion;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichSequence.SYMLISTVERSION, seqVersion, this.symListVersion);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichSequence.SYMLISTVERSION);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.symListVersion = seqVersion;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCircular(boolean circular) throws ChangeVetoException {
        if (!this.hasListeners(RichSequence.CIRCULAR)) {
            this.circular = circular;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichSequence.CIRCULAR, new Boolean(circular), new Boolean(this.circular));
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichSequence.CIRCULAR);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.circular = circular;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public boolean getCircular() {
        return this.circular;
    }

    String getCircularChar() {
        return this.getCircular() ? ISCIRCULAR : null;
    }

    void setCircularChar(String isHiddenChar) throws ChangeVetoException {
        this.setCircular(isHiddenChar != null || isHiddenChar != null && isHiddenChar.length() > 0);
    }

    public void edit(Edit edit) throws IndexOutOfBoundsException, IllegalAlphabetException, ChangeVetoException {
        RichObjectFactory.getDefaultRichSequenceHandler().edit(this, edit);
    }

    public Symbol symbolAt(int index) throws IndexOutOfBoundsException {
        return RichObjectFactory.getDefaultRichSequenceHandler().symbolAt(this, index);
    }

    public List toList() {
        return RichObjectFactory.getDefaultRichSequenceHandler().toList(this);
    }

    public String subStr(int start, int end) throws IndexOutOfBoundsException {
        return RichObjectFactory.getDefaultRichSequenceHandler().subStr(this, start, end);
    }

    public SymbolList subList(int start, int end) throws IndexOutOfBoundsException {
        return RichObjectFactory.getDefaultRichSequenceHandler().subList(this, start, end);
    }

    public String seqString() {
        return RichObjectFactory.getDefaultRichSequenceHandler().seqString(this);
    }

    public int length() {
        return this.length;
    }

    public Iterator iterator() {
        return RichObjectFactory.getDefaultRichSequenceHandler().iterator(this);
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    protected void setAlphabetName(String alphaname) throws IllegalSymbolException, BioException {
        if (alphaname.equals("protein")) {
            alphaname = ProteinTools.getTAlphabet().getName();
        }
        this.alphabet = AlphabetManager.alphabetForName(alphaname);
    }

    protected String getAlphabetName() {
        if (this.alphabet == null) {
            return null;
        }
        String name = this.alphabet.getName();
        if (name.equals(ProteinTools.getTAlphabet().getName())) {
            return "protein";
        }
        return name;
    }

    protected void setSequenceLength(int length) {
        this.length = length;
    }

    protected int getSequenceLength() {
        return this.length;
    }

    public String getURN() {
        return this.getName();
    }

    public FeatureHolder filter(FeatureFilter fc, boolean recurse) {
        SimpleFeatureHolder fh = new SimpleFeatureHolder();
        for (RichFeature f : this.features) {
            try {
                if (!fc.accept(f)) continue;
                fh.addFeature(f);
            }
            catch (ChangeVetoException e) {
                throw new RuntimeException("What? You don't like our features??");
            }
        }
        return fh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feature createFeature(Feature.Template ft) throws BioException, ChangeVetoException {
        SimpleRichFeature f;
        try {
            f = new SimpleRichFeature(this, ft);
        }
        catch (InvalidTermException e) {
            throw new ChangeVetoException("They don't like our term", e);
        }
        if (!this.hasListeners(RichSequence.FEATURES)) {
            this.features.add(f);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichSequence.FEATURES, f, null);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichSequence.FEATURES);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.features.add(f);
                cs.firePostChangeEvent(ce);
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeature(Feature f) throws ChangeVetoException, BioException {
        if (!(f instanceof RichFeature)) {
            f = RichFeature.Tools.enrich(f);
        }
        if (!this.hasListeners(RichSequence.FEATURES)) {
            this.features.remove(f);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichSequence.FEATURES, null, f);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichSequence.FEATURES);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.features.remove(f);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public boolean containsFeature(Feature f) {
        try {
            if (!(f instanceof RichFeature)) {
                f = RichFeature.Tools.enrich(f);
            }
        }
        catch (ChangeVetoException e) {
            return false;
        }
        return this.features.contains(f);
    }

    public FeatureHolder filter(FeatureFilter filter) {
        boolean recurse = !FilterUtils.areProperSubset(filter, FeatureFilter.top_level);
        return this.filter(filter, recurse);
    }

    public Set getFeatureSet() {
        return this.features;
    }

    public void setFeatureSet(Set features) throws ChangeVetoException {
        this.features = features;
    }

    public FeatureFilter getSchema() {
        return FeatureFilter.top_level;
    }

    public Iterator features() {
        return this.getFeatureSet().iterator();
    }

    public int countFeatures() {
        return this.features.size();
    }

    public SymbolList getInternalSymbolList() {
        return SymbolList.EMPTY_LIST;
    }
}

