/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.assessment;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.classifier.assessment.ClassifierAssessmentAssessParameterSet;
import de.jstacs.data.Sample;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import java.util.ArrayList;

public class KFoldCVAssessParameterSet
extends ClassifierAssessmentAssessParameterSet {
    public KFoldCVAssessParameterSet() throws UnsupportedOperationException {
    }

    public KFoldCVAssessParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public KFoldCVAssessParameterSet(Sample.PartitionMethod dataSplitMethod, int elementLength, boolean exceptionIfMPNotComputable, int k) throws SimpleParameter.IllegalValueException {
        super(elementLength, exceptionIfMPNotComputable);
        ((Parameter)this.parameters.get(2)).setValue(new Integer(k));
        ((Parameter)this.parameters.get(3)).setValue((Object)dataSplitMethod);
    }

    @Override
    protected void initializeMyParametersArrayList() {
        this.initParameterList(4);
    }

    @Override
    protected void loadParameters() throws Exception {
        super.loadParameters();
        this.parameters.add(new SimpleParameter(DataType.INT, "k", "Defines the folds of a KFoldCrossValidation.", true, new NumberValidator<Integer>(2, Integer.MAX_VALUE)));
        this.parameters.add(new EnumParameter(Sample.PartitionMethod.class, "The method used to compute the percentages of the partitions", true));
    }

    public int getK() {
        return (Integer)this.getParameterAt(2).getValue();
    }

    public Sample.PartitionMethod getDataSplitMethod() {
        return (Sample.PartitionMethod)((EnumParameter)this.getParameterAt(3)).getValue();
    }

    public ArrayList<Result> getAnnotation() {
        ArrayList<Result> l = new ArrayList<Result>(2);
        l.add(new NumericalResult("k", "The folds of a KFoldCrossValidation.", this.getK()));
        l.add(new CategoricalResult("dataSplitMethod", "Describes how data should be splitted in ClassifierAssessment.evaluateClassifier())", this.getDataSplitMethod().name()));
        return l;
    }
}

