/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased.sampling;

import de.jstacs.NonParsableException;
import de.jstacs.classifier.scoringFunctionBased.SFBasedOptimizableFunction;
import de.jstacs.classifier.scoringFunctionBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifier.scoringFunctionBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifier.scoringFunctionBased.gendismix.LearningPrinciple;
import de.jstacs.classifier.scoringFunctionBased.gendismix.LogGenDisMixFunction;
import de.jstacs.classifier.scoringFunctionBased.logPrior.LogPrior;
import de.jstacs.classifier.scoringFunctionBased.sampling.SamplingGenDisMixClassifierParameterSet;
import de.jstacs.classifier.scoringFunctionBased.sampling.SamplingScoreBasedClassifier;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.sampling.BurnInTest;
import de.jstacs.scoringFunctions.NormalizableScoringFunction;
import de.jstacs.scoringFunctions.SamplingScoringFunction;

public class SamplingGenDisMixClassifier
extends SamplingScoreBasedClassifier {
    private LogPrior prior;
    private double[] beta;
    private double factor;

    public SamplingGenDisMixClassifier(SamplingGenDisMixClassifierParameterSet params, BurnInTest burnInTest, double[] classVariances, LogPrior prior, double[] beta, SamplingScoringFunction ... scoringFunctions) throws CloneNotSupportedException {
        super(params, burnInTest, classVariances, scoringFunctions);
        this.prior = prior;
        this.beta = (double[])beta.clone();
        this.factor = 0.0;
        for (int i = 0; i < beta.length; ++i) {
            if (beta[i] > 0.0 && this.factor == 0.0) {
                this.factor = 1.0 / beta[i];
                continue;
            }
            if (!(beta[i] > 0.0) || !(this.factor > 0.0) || 1.0 / this.factor == beta[i]) continue;
            this.factor = 1.0;
        }
    }

    public SamplingGenDisMixClassifier(SamplingGenDisMixClassifierParameterSet params, BurnInTest burnInTest, double[] classVariances, LogPrior prior, LearningPrinciple principle, SamplingScoringFunction ... scoringFunctions) throws CloneNotSupportedException {
        this(params, burnInTest, classVariances, prior, LearningPrinciple.getBeta(principle), scoringFunctions);
    }

    public SamplingGenDisMixClassifier(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    protected SFBasedOptimizableFunction getFunction(Sample[] data, double[][] weights) throws Exception {
        LogGenDisMixFunction fun = new LogGenDisMixFunction(((SamplingGenDisMixClassifierParameterSet)this.params).getNumberOfThreads(), this.scoringFunctions, data, weights, this.prior, this.beta, false, this.params.getFreeParameters());
        fun.reset();
        return fun;
    }

    @Override
    protected double modifyFunctionValue(double value) {
        return this.factor * value;
    }

    @Override
    protected String getXMLTag() {
        return "SamplingGenDisMixClassifier";
    }

    @Override
    protected StringBuffer getFurtherClassifierInfos() {
        StringBuffer xml = super.getFurtherClassifierInfos();
        XMLParser.appendObjectWithTags(xml, this.prior, "prior");
        XMLParser.appendObjectWithTags(xml, this.beta, "beta");
        return xml;
    }

    @Override
    protected void extractFurtherClassifierInfosFromXML(StringBuffer xml) throws NonParsableException {
        this.prior = XMLParser.extractObjectForTags(xml, "prior", LogPrior.class);
        this.beta = XMLParser.extractObjectForTags(xml, "beta", double[].class);
    }

    public GenDisMixClassifier getClassifierForBestParameters(GenDisMixClassifierParameterSet params) throws Exception {
        GenDisMixClassifier cls = new GenDisMixClassifier(params, this.prior, this.beta, (NormalizableScoringFunction[])this.scoringFunctions);
        cls.initUsingParameters(this.getBestParameters());
        return cls;
    }

    public GenDisMixClassifier getClassifierForMeanParameters(GenDisMixClassifierParameterSet params, boolean testBurnIn, int minBurnInSteps) throws Exception {
        GenDisMixClassifier cls = new GenDisMixClassifier(params, this.prior, this.beta, (NormalizableScoringFunction[])this.scoringFunctions);
        cls.initUsingParameters(this.getMeanParameters(testBurnIn, minBurnInSteps));
        return cls;
    }
}

