/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased.sampling;

import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.WrongAlphabetException;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.classifier.AbstractScoreBasedClassifier;
import de.jstacs.classifier.ClassDimensionException;
import de.jstacs.classifier.scoringFunctionBased.SFBasedOptimizableFunction;
import de.jstacs.classifier.scoringFunctionBased.sampling.SamplingScoreBasedClassifierParameterSet;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.WrongLengthException;
import de.jstacs.io.FileManager;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.io.XMLParser;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.sampling.BurnInTest;
import de.jstacs.sampling.SamplingComponent;
import de.jstacs.scoringFunctions.SamplingScoringFunction;
import de.jstacs.utils.Pair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import javax.naming.OperationNotSupportedException;

public abstract class SamplingScoreBasedClassifier
extends AbstractScoreBasedClassifier {
    private static Random r = new Random();
    protected SamplingScoreBasedClassifierParameterSet params;
    protected SamplingScoringFunction[] scoringFunctions;
    protected double[] currentParameters;
    protected double[] initParameters;
    protected double currentScore;
    protected double[] previousParameters;
    protected double[][] lastParameters;
    protected double[] lastScore;
    private int[][] groupedParameters;
    private int[] parameterOffsets;
    private double[] classVariances;
    private double[] samplingSds;
    private boolean isTrained;
    protected BurnInTest burnInTest;
    private Integer burnInLength;
    private ScoringFunctionSamplingComponent samplingComponent;
    private File tempDir;
    private boolean deleteOnExit = true;

    @Override
    protected StringBuffer getFurtherClassifierInfos() {
        StringBuffer xml = super.getFurtherClassifierInfos();
        XMLParser.appendObjectWithTags(xml, this.params, "parameters");
        XMLParser.appendObjectWithTags(xml, this.scoringFunctions, "scoringFunctions");
        XMLParser.appendObjectWithTags(xml, this.currentParameters, "currentParameters");
        XMLParser.appendObjectWithTags(xml, this.initParameters, "initParameters");
        XMLParser.appendObjectWithTags(xml, this.currentScore, "currentScore");
        XMLParser.appendObjectWithTags(xml, this.previousParameters, "previousParameters");
        XMLParser.appendObjectWithTags(xml, this.lastParameters, "lastParameters");
        XMLParser.appendObjectWithTags(xml, this.lastScore, "lastScore");
        XMLParser.appendObjectWithTags(xml, this.groupedParameters, "groupedParameters");
        XMLParser.appendObjectWithTags(xml, this.parameterOffsets, "parametersOffsets");
        XMLParser.appendObjectWithTags(xml, this.classVariances, "classVariances");
        XMLParser.appendObjectWithTags(xml, this.samplingSds, "samplingSds");
        XMLParser.appendObjectWithTags(xml, this.isTrained, "isTrained");
        XMLParser.appendObjectWithTags(xml, this.burnInTest, "burnInTest");
        XMLParser.appendObjectWithTags(xml, this.burnInLength, "burnInLength");
        ScoringFunctionSamplingComponent sfsc = this.getSamplingComponent();
        try {
            StringBuffer sb = sfsc.saveParameters();
            XMLParser.addTags(sb, "sampledParameters");
            xml.append(sb);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return xml;
    }

    @Override
    protected void extractFurtherClassifierInfosFromXML(StringBuffer xml) throws NonParsableException {
        this.params = XMLParser.extractObjectForTags(xml, "parameters", SamplingScoreBasedClassifierParameterSet.class);
        this.scoringFunctions = XMLParser.extractObjectForTags(xml, "scoringFunctions", SamplingScoringFunction[].class);
        this.currentParameters = XMLParser.extractObjectForTags(xml, "currentParameters", double[].class);
        this.initParameters = XMLParser.extractObjectForTags(xml, "initParameters", double[].class);
        this.currentScore = XMLParser.extractObjectForTags(xml, "currentScore", Double.TYPE);
        this.previousParameters = XMLParser.extractObjectForTags(xml, "previousParameters", double[].class);
        this.lastParameters = XMLParser.extractObjectForTags(xml, "lastParameters", double[][].class);
        this.lastScore = XMLParser.extractObjectForTags(xml, "lastScore", double[].class);
        this.groupedParameters = XMLParser.extractObjectForTags(xml, "groupedParameters", int[][].class);
        this.parameterOffsets = XMLParser.extractObjectForTags(xml, "parameterOffsets", int[].class);
        this.classVariances = XMLParser.extractObjectForTags(xml, "classVariances", double[].class);
        this.samplingSds = XMLParser.extractObjectForTags(xml, "samplingSds", double[].class);
        this.isTrained = XMLParser.extractObjectForTags(xml, "isTrained", Boolean.TYPE);
        this.burnInTest = XMLParser.extractObjectForTags(xml, "burnInTest", BurnInTest.class);
        this.burnInLength = XMLParser.extractObjectForTags(xml, "burnInLength", Integer.class);
        ScoringFunctionSamplingComponent sfsc = this.getSamplingComponent();
        try {
            sfsc.initForSampling(this.params.getNumberOfStarts());
            StringBuffer sb = XMLParser.extractForTag(xml, "sampledParameters");
            sfsc.createFiles(sb);
        }
        catch (Exception e) {
            NonParsableException ex = new NonParsableException(e.getMessage());
            ex.setStackTrace(e.getStackTrace());
        }
    }

    public SamplingScoreBasedClassifier(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    protected SamplingScoreBasedClassifier(SamplingScoreBasedClassifierParameterSet params, BurnInTest burnInTest, double[] classVariances, SamplingScoringFunction ... scoringFunctions) throws CloneNotSupportedException {
        super(params.getAlphabetContainer(), params.getLength(), scoringFunctions.length);
        this.params = params.clone();
        this.scoringFunctions = (SamplingScoringFunction[])scoringFunctions.clone();
        this.burnInLength = null;
        this.classVariances = (double[])classVariances.clone();
        if (burnInTest != null) {
            this.burnInTest = burnInTest.clone();
        }
    }

    @Override
    public CategoricalResult[] getClassifierAnnotation() {
        CategoricalResult[] res = new CategoricalResult[this.scoringFunctions.length + 1];
        res[0] = new CategoricalResult("classifier", "a <b>short</b> description of the classifier", this.getInstanceName());
        int i = 0;
        while (i < this.scoringFunctions.length) {
            res[i + 1] = new CategoricalResult("class info " + i, "some information about the scoring function for class " + i, this.scoringFunctions[i++].getInstanceName());
        }
        return res;
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        NumericalResult[] pars = new NumericalResult[this.scoringFunctions.length];
        for (int i = 0; i < this.scoringFunctions.length; ++i) {
            pars[i] = new NumericalResult("Number of parameters " + (i + 1), "The number of parameters for scoring function " + (i + 1) + ", -1 indicates unknown number of parameters.", this.scoringFunctions[i].getNumberOfParameters());
        }
        return new NumericalResultSet(new NumericalResult[][]{pars});
    }

    @Override
    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    protected abstract SFBasedOptimizableFunction getFunction(Sample[] var1, double[][] var2) throws Exception;

    protected double modifyFunctionValue(double value) {
        return value;
    }

    protected ScoringFunctionSamplingComponent getSamplingComponent() {
        if (this.samplingComponent == null) {
            this.samplingComponent = new ScoringFunctionSamplingComponent(this.params.getOutfilePrefix());
        }
        return this.samplingComponent;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
        this.samplingComponent = null;
        this.isTrained = false;
    }

    public boolean getDeleteOnExit() {
        return this.deleteOnExit;
    }

    public void setDeleteOnExit(boolean deleteOnExit) throws Exception {
        if (this.samplingComponent != null && !deleteOnExit) {
            throw new Exception("Cannot revoke delete on exit after creating files.");
        }
        this.deleteOnExit = deleteOnExit;
    }

    protected void init(int starts, boolean adaptVariance, String outfilePrefix) throws Exception {
        int i;
        int j;
        int k;
        int i2;
        boolean freeParams = this.params.getFreeParameters();
        int numParams = 0;
        numParams += this.scoringFunctions.length - (freeParams ? 1 : 0);
        LinkedList<int[]> list = new LinkedList<int[]>();
        int[] temp2 = new int[this.scoringFunctions.length - (freeParams ? 1 : 0) + 1];
        for (i2 = 0; i2 < temp2.length; ++i2) {
            temp2[i2] = i2 - 1;
        }
        list.add(temp2);
        this.parameterOffsets = new int[this.scoringFunctions.length + 1];
        for (i2 = 0; i2 < this.scoringFunctions.length; ++i2) {
            this.parameterOffsets[i2] = numParams;
            this.scoringFunctions[i2].initializeFunctionRandomly(freeParams);
            int[][] temp = this.scoringFunctions[i2].getSamplingGroups(numParams);
            for (int j2 = 0; j2 < temp.length; ++j2) {
                temp2 = new int[temp[j2].length + 1];
                temp2[0] = i2;
                for (k = 0; k < temp[j2].length; ++k) {
                    temp2[k + 1] = temp[j2][k];
                }
                list.add(temp2);
            }
            numParams += this.scoringFunctions[i2].getNumberOfParameters();
        }
        this.parameterOffsets[this.parameterOffsets.length - 1] = numParams;
        this.groupedParameters = (int[][])list.toArray((T[])new int[0][0]);
        this.currentParameters = new double[numParams];
        this.samplingSds = new double[numParams];
        double[] temp = this.getClassWeights();
        for (j = 0; j < temp.length - (freeParams ? 1 : 0); ++j) {
            this.currentParameters[j] = freeParams ? temp[j] - temp[temp.length - 1] : temp[j];
            this.samplingSds[j] = Math.sqrt(this.classVariances[j]);
        }
        for (i = 0; i < this.scoringFunctions.length; ++i) {
            temp = this.scoringFunctions[i].getCurrentParameterValues();
            System.arraycopy(temp, 0, this.currentParameters, j, temp.length);
            for (k = 0; k < temp.length; ++k) {
                if (adaptVariance) {
                    try {
                        this.samplingSds[j + k] = Math.sqrt(this.classVariances[i] * (double)this.scoringFunctions[i].getSizeOfEventSpaceForRandomVariablesOfParameter(k));
                        if (!Double.isNaN(this.samplingSds[j + k])) continue;
                        this.samplingSds[j + k] = Math.sqrt(this.classVariances[i]);
                    }
                    catch (Exception e) {
                        this.samplingSds[j + k] = Math.sqrt(this.classVariances[i]);
                    }
                    continue;
                }
                this.samplingSds[j + k] = Math.sqrt(this.classVariances[i]);
            }
            j += temp.length;
        }
        if (this.initParameters != null && this.initParameters.length == this.currentParameters.length) {
            this.currentParameters = (double[])this.initParameters.clone();
        }
        this.previousParameters = (double[])this.currentParameters.clone();
        this.lastScore = new double[starts];
        Arrays.fill(this.lastScore, Double.NEGATIVE_INFINITY);
        this.lastParameters = new double[starts][];
        this.lastParameters[0] = (double[])this.currentParameters.clone();
        for (i = 1; i < starts; ++i) {
            this.lastParameters[i] = (double[])this.currentParameters.clone();
            for (k = 0; k < this.scoringFunctions.length; ++k) {
                this.scoringFunctions[k].initializeFunctionRandomly(freeParams);
                System.arraycopy(this.scoringFunctions[k].getCurrentParameterValues(), 0, this.lastParameters[i], this.parameterOffsets[k], this.parameterOffsets[k + 1] - this.parameterOffsets[k]);
            }
        }
        ScoringFunctionSamplingComponent sfsc = this.getSamplingComponent();
        sfsc.initForSampling(starts);
    }

    protected double sampleNSteps(SFBasedOptimizableFunction function, ScoringFunctionSamplingComponent component, BurnInTest test, int numSteps, SamplingScheme scheme) throws Exception {
        double newValue = this.currentScore == Double.NEGATIVE_INFINITY ? this.modifyFunctionValue(function.evaluateFunction(this.currentParameters)) : this.currentScore;
        for (int i = 0; i < numSteps; ++i) {
            double previousValue = newValue;
            if (Double.isNaN(newValue = this.doOneSamplingStep(function, scheme, previousValue))) {
                newValue = previousValue;
            }
            this.currentScore = newValue;
            component.acceptParameters();
            if (test == null) continue;
            test.setValue(newValue);
        }
        return newValue;
    }

    protected void sample(ScoringFunctionSamplingComponent sfsc, SFBasedOptimizableFunction function) throws Exception {
        int i;
        boolean afterBurnIn = false;
        int numIterations = 0;
        int starts = this.params.getNumberOfStarts();
        int numberOfTestIterations = this.params.getNumberOfTestSamplings();
        int numberOfStationaryIterations = this.params.getNumberOfStationarySamplings();
        SamplingScheme scheme = this.params.getSamplingScheme();
        while (!afterBurnIn) {
            for (i = 0; i < starts; ++i) {
                sfsc.extendSampling(i, true);
                this.burnInTest.setCurrentSamplingIndex(i);
                this.sampleNSteps(function, sfsc, this.burnInTest, numberOfTestIterations, scheme);
            }
            this.burnInLength = this.burnInTest.getLengthOfBurnIn();
            if ((numIterations += numberOfTestIterations) <= this.burnInLength) continue;
            afterBurnIn = true;
        }
        for (i = 0; i < starts; ++i) {
            sfsc.extendSampling(i, false);
            this.sampleNSteps(function, sfsc, this.burnInTest, numberOfStationaryIterations - (numIterations - this.burnInLength), scheme);
        }
    }

    protected double doOneSamplingStep(SFBasedOptimizableFunction function, SamplingScheme scheme, double previousValue) throws Exception {
        int i;
        double returnValue = Double.NaN;
        this.switchPars(0, this.currentParameters.length, false);
        for (i = 0; i < this.scoringFunctions.length; ++i) {
            this.currentParameters[i] = r.nextGaussian() * this.samplingSds[i] + this.previousParameters[i];
        }
        if (scheme == SamplingScheme.ALL_PARAMETERS) {
            for (i = this.scoringFunctions.length; i < this.currentParameters.length; ++i) {
                this.currentParameters[i] = r.nextGaussian() * this.samplingSds[i] + this.previousParameters[i];
            }
            double temp = this.testParameters(function, previousValue);
            if (Double.isNaN(temp)) {
                this.switchPars(0, this.currentParameters.length, true);
            }
            return temp;
        }
        if (scheme == SamplingScheme.FUNCTION_WISE) {
            double temp = this.testParameters(function, previousValue);
            if (!Double.isNaN(temp)) {
                previousValue = temp;
                returnValue = temp;
            }
            this.switchPars(0, this.scoringFunctions.length, Double.isNaN(temp));
            for (int i2 = 0; i2 < this.scoringFunctions.length; ++i2) {
                for (int j = this.parameterOffsets[i2]; j < this.parameterOffsets[i2 + 1]; ++j) {
                    this.currentParameters[i2] = r.nextGaussian() * this.samplingSds[j] + this.previousParameters[j];
                }
                temp = this.testParameters(function, previousValue);
                if (!Double.isNaN(temp)) {
                    previousValue = temp;
                    returnValue = temp;
                }
                this.switchPars(this.parameterOffsets[i2], this.parameterOffsets[i2 + 1], Double.isNaN(temp));
            }
            return returnValue;
        }
        if (scheme == SamplingScheme.GROUPED) {
            double temp = this.testParameters(function, previousValue);
            if (!Double.isNaN(temp)) {
                previousValue = temp;
                returnValue = temp;
            }
            this.switchPars(0, this.scoringFunctions.length, Double.isNaN(temp));
            for (int i3 = 0; i3 < this.groupedParameters.length; ++i3) {
                for (int j = 1; j < this.groupedParameters[i3].length; ++j) {
                    int idx = this.groupedParameters[i3][j];
                    this.currentParameters[idx] = r.nextGaussian() * this.samplingSds[idx] + this.previousParameters[idx];
                }
                temp = this.testParameters(function, previousValue);
                if (!Double.isNaN(temp)) {
                    previousValue = temp;
                    returnValue = temp;
                }
                this.switchPars(this.groupedParameters[i3], Double.isNaN(temp));
            }
            return returnValue;
        }
        throw new Exception("Sampling scheme not implemented.");
    }

    private double testParameters(SFBasedOptimizableFunction function, double previousValue) throws DimensionException, EvaluationException {
        double newValue = this.modifyFunctionValue(function.evaluateFunction(this.currentParameters));
        if (Math.log(r.nextDouble()) < newValue - previousValue) {
            return newValue;
        }
        return Double.NaN;
    }

    private void switchPars(int start, int end, boolean rollback) {
        if (rollback) {
            System.arraycopy(this.previousParameters, start, this.currentParameters, start, end - start);
        } else {
            System.arraycopy(this.currentParameters, start, this.previousParameters, start, end - start);
        }
    }

    private void switchPars(int[] idxs, boolean rollback) {
        if (rollback) {
            for (int i = 1; i < idxs.length; ++i) {
                this.currentParameters[idxs[i]] = this.previousParameters[idxs[i]];
            }
        } else {
            for (int i = 1; i < idxs.length; ++i) {
                this.previousParameters[idxs[i]] = this.currentParameters[idxs[i]];
            }
        }
    }

    @Override
    protected double getScore(Sequence seq, int cls, boolean check) throws IllegalArgumentException, NotTrainedException, Exception {
        if (check) {
            super.check(seq);
        }
        ScoringFunctionSamplingComponent sfsc = this.getSamplingComponent();
        int starts = this.params.getNumberOfStarts();
        sfsc.initForSampling(starts);
        sfsc.samplingStopped();
        if (this.burnInLength == null) {
            this.precomputeBurnInLength(sfsc);
        }
        double score = 0.0;
        double n = 0.0;
        for (int i = 0; i < starts; ++i) {
            sfsc.parseParameterSet(i, this.burnInLength);
            while (sfsc.parseNextParameterSet()) {
                this.setParameters(this.currentParameters);
                score += this.getClassWeight(cls) + this.scoringFunctions[cls].getLogScore(seq);
                n += 1.0;
            }
        }
        return score / n;
    }

    @Override
    public double[] getScores(Sample s) throws Exception {
        int i;
        if (this.scoringFunctions.length != 2) {
            throw new OperationNotSupportedException("This method is only for 2-class-classifiers.");
        }
        if (s == null) {
            return new double[0];
        }
        this.check(s);
        int starts = this.params.getNumberOfStarts();
        ScoringFunctionSamplingComponent sfsc = this.getSamplingComponent();
        sfsc.initForSampling(starts);
        sfsc.samplingStopped();
        if (this.burnInLength == null) {
            this.precomputeBurnInLength(sfsc);
        }
        double[] scores = new double[s.getNumberOfElements()];
        double n = 0.0;
        for (i = 0; i < starts; ++i) {
            sfsc.parseParameterSet(i, this.burnInLength);
            while (sfsc.parseNextParameterSet()) {
                this.setParameters(this.currentParameters);
                int j = 0;
                while (j < scores.length) {
                    Sequence seq = s.getElementAt(j);
                    int n2 = j++;
                    scores[n2] = scores[n2] + (this.getClassWeight(0) - this.getClassWeight(1) + this.scoringFunctions[0].getLogScore(seq) - this.scoringFunctions[1].getLogScore(seq));
                }
                n += 1.0;
            }
        }
        i = 0;
        while (i < scores.length) {
            int n3 = i++;
            scores[n3] = scores[n3] / n;
        }
        return scores;
    }

    public void setInitParameters(double[] parameters) {
        this.initParameters = (double[])parameters.clone();
    }

    private void setParameters(double[] currentParameters) {
        this.setClassWeights(false, currentParameters, 0);
        for (int i = 0; i < this.scoringFunctions.length; ++i) {
            this.scoringFunctions[i].setParameters(currentParameters, this.parameterOffsets[i]);
        }
    }

    @Override
    public boolean isTrained() {
        return this.isTrained;
    }

    private Pair<Sample[], double[][]> check(Sample[] data, double[][] weights) throws ClassDimensionException, WrongAlphabetException, WrongLengthException {
        if (weights != null && data.length != ((double[][])weights).length) {
            throw new IllegalArgumentException("data and weights do not match");
        }
        if (this.scoringFunctions.length != data.length) {
            throw new ClassDimensionException();
        }
        if (weights == null) {
            weights = new double[data.length][];
        }
        Sample[] reduced = new Sample[data.length];
        double[][] newWeights = new double[data.length][];
        AlphabetContainer abc = this.getAlphabetContainer();
        int l = this.getLength();
        for (int i = 0; i < this.scoringFunctions.length; ++i) {
            if (weights[i] != null && data[i].getNumberOfElements() != weights[i].length) {
                throw new IllegalArgumentException("At least for one sample: The dimension of the sample and the weight do not match.");
            }
            if (!abc.checkConsistency(data[i].getAlphabetContainer())) {
                throw new IllegalArgumentException("At least one sample is not defined over the correct alphabets.");
            }
            Sample.WeightedSampleFactory wsf = data[i].getElementLength() != l ? new Sample.WeightedSampleFactory(Sample.WeightedSampleFactory.SortOperation.NO_SORT, data[i], weights[i], l) : new Sample.WeightedSampleFactory(Sample.WeightedSampleFactory.SortOperation.NO_SORT, data[i], weights[i]);
            reduced[i] = wsf.getSample();
            newWeights[i] = wsf.getWeights();
        }
        return new Pair<Sample[], double[][]>(reduced, newWeights);
    }

    public void doSingleSampling(Sample[] s, double[][] weights, int numSteps, String outfilePrefix) throws Exception {
        Pair<Sample[], double[][]> pair = this.check(s, weights);
        s = pair.getFirstElement();
        weights = pair.getSecondElement();
        this.init(1, this.params.getAdaptVariance(), outfilePrefix);
        SFBasedOptimizableFunction function = this.getFunction(s, weights);
        ScoringFunctionSamplingComponent sfsc = this.getSamplingComponent();
        sfsc.extendSampling(0, false);
        this.sampleNSteps(function, sfsc, null, numSteps, this.params.getSamplingScheme());
        sfsc.samplingStopped();
    }

    @Override
    public void train(Sample[] s, double[][] weights) throws Exception {
        Pair<Sample[], double[][]> pair = this.check(s, weights);
        s = pair.getFirstElement();
        weights = pair.getSecondElement();
        this.init(this.params.getNumberOfStarts(), this.params.getAdaptVariance(), this.params.getOutfilePrefix());
        ScoringFunctionSamplingComponent sfsc = this.getSamplingComponent();
        if (this.burnInTest != null) {
            this.burnInTest.resetAllValues();
        }
        SFBasedOptimizableFunction function = this.getFunction(s, weights);
        this.sample(sfsc, function);
        sfsc.samplingStopped();
        this.burnInLength = 0;
        this.isTrained = true;
    }

    protected void precomputeBurnInLength(ScoringFunctionSamplingComponent sfsc) throws Exception {
        if (this.burnInTest == null) {
            this.burnInLength = 0;
        }
        int starts = this.params.getNumberOfStarts();
        for (int i = 0; i < starts; ++i) {
            sfsc.parseParameterSet(i, 0);
            this.burnInTest.setCurrentSamplingIndex(i);
            while (sfsc.parseNextParameterSet()) {
                this.burnInTest.setValue(this.currentScore);
            }
        }
        this.burnInLength = this.burnInTest.getLengthOfBurnIn();
    }

    protected double[] getBestParameters() throws Exception {
        int starts = this.params.getNumberOfStarts();
        ScoringFunctionSamplingComponent sfsc = this.getSamplingComponent();
        double best = Double.NEGATIVE_INFINITY;
        double[] bestParameters = null;
        for (int i = 0; i < starts; ++i) {
            sfsc.parseParameterSet(i, 0);
            while (sfsc.parseNextParameterSet()) {
                if (!(this.currentScore > best)) continue;
                if (bestParameters == null) {
                    bestParameters = (double[])this.currentParameters.clone();
                } else {
                    System.arraycopy(this.currentParameters, 0, bestParameters, 0, this.currentParameters.length);
                }
                best = this.currentScore;
            }
        }
        return bestParameters;
    }

    protected double[] getMeanParameters(boolean testBurnIn, int minBurnInSteps) throws Exception {
        int i;
        int starts = this.params.getNumberOfStarts();
        ScoringFunctionSamplingComponent sfsc = this.getSamplingComponent();
        if (testBurnIn && this.burnInLength == null) {
            this.precomputeBurnInLength(sfsc);
        }
        double[] meanParameters = null;
        double n = 0.0;
        for (i = 0; i < starts; ++i) {
            double k = 0.0;
            sfsc.parseParameterSet(i, 0);
            while (sfsc.parseNextParameterSet()) {
                if (k >= (double)minBurnInSteps && (!testBurnIn || k > (double)this.burnInLength.intValue())) {
                    if (meanParameters == null) {
                        meanParameters = (double[])this.currentParameters.clone();
                    } else {
                        for (int j = 0; j < this.currentParameters.length; ++j) {
                            int n2 = j;
                            meanParameters[n2] = meanParameters[n2] + this.currentParameters[j];
                        }
                    }
                    n += 1.0;
                }
                k += 1.0;
            }
        }
        i = 0;
        while (i < meanParameters.length) {
            int n3 = i++;
            meanParameters[n3] = meanParameters[n3] / n;
        }
        return meanParameters;
    }

    public void joinAndSetParameterFiles(boolean add, File ... files) throws Exception {
        ScoringFunctionSamplingComponent sfsc;
        boolean b;
        if (this.lastParameters == null) {
            this.init(this.params.getNumberOfStarts(), this.params.getAdaptVariance(), this.params.getOutfilePrefix());
        }
        if (b = (sfsc = this.getSamplingComponent()).joinAndSetParameterFiles(add, files)) {
            if (add) {
                this.params.setNumberOfStarts(this.params.getNumberOfStarts() + files.length);
            } else {
                this.params.setNumberOfStarts(files.length);
            }
        }
    }

    protected class ScoringFunctionSamplingComponent
    implements SamplingComponent {
        private File[] outfiles;
        private PrintWriter curr;
        private SparseStringExtractor extract;
        private String outfilePrefix;
        private boolean inSamplingMode = false;
        private int currSampling;

        public ScoringFunctionSamplingComponent(String outfilePrefix) {
            this.outfilePrefix = outfilePrefix;
            this.currSampling = -1;
        }

        public boolean joinAndSetParameterFiles(boolean add, File[] files) throws Exception {
            int l = -1;
            double[][] newLastParameters = new double[files.length][];
            for (int i = 0; i < files.length; ++i) {
                SparseStringExtractor ex = new SparseStringExtractor(files[i]);
                while (ex.hasMoreElements()) {
                    String str = ex.nextElement();
                    String[] splt1 = str.split("\t");
                    splt1[1] = splt1[1].substring(1, splt1[1].length() - 1);
                    String[] splt = splt1[1].split(", ");
                    if (l == -1) {
                        l = splt.length;
                        if (SamplingScoreBasedClassifier.this.currentParameters != null && SamplingScoreBasedClassifier.this.currentParameters.length != l) {
                            throw new Exception("Number of parameters does not match scoring functions: expected " + SamplingScoreBasedClassifier.this.currentParameters.length + " but found " + splt.length);
                        }
                    } else if (splt.length != 0 && l != splt.length) {
                        throw new Exception("Numbers of parameters between different files do not match: expected " + l + " but found " + splt.length);
                    }
                    if (ex.hasMoreElements()) continue;
                    newLastParameters[i] = new double[splt.length];
                    for (int j = 0; j < newLastParameters[i].length; ++j) {
                        newLastParameters[i][j] = Double.parseDouble(splt[j]);
                    }
                }
            }
            int off = 0;
            off = add ? this.outfiles.length : 0;
            File[] temp = new File[off + files.length];
            double[][] temp2 = new double[temp.length][];
            if (add) {
                System.arraycopy(this.outfiles, 0, temp, 0, off);
                System.arraycopy(SamplingScoreBasedClassifier.this.lastParameters, 0, temp2, 0, off);
            }
            for (int i = 0; i < files.length; ++i) {
                temp[i + off] = this.getOutfile(i + off);
                FileManager.copy(files[i].getAbsolutePath(), temp[i + off].getAbsolutePath());
                temp2[i + off] = newLastParameters[i];
            }
            this.outfiles = temp;
            SamplingScoreBasedClassifier.this.lastParameters = temp2;
            if (!add) {
                System.arraycopy(SamplingScoreBasedClassifier.this.lastParameters[0], 0, SamplingScoreBasedClassifier.this.currentParameters, 0, SamplingScoreBasedClassifier.this.currentParameters.length);
            }
            return true;
        }

        @Override
        public boolean parseParameterSet(int sampling, int n) throws Exception {
            this.currSampling = sampling;
            this.extract = new SparseStringExtractor(this.outfiles[sampling]);
            int i = 0;
            while (this.extract.hasMoreElements() && i < n) {
                this.extract.nextElement();
            }
            return this.parseNextParameterSet();
        }

        @Override
        public boolean parseNextParameterSet() {
            if (!this.extract.hasMoreElements()) {
                return false;
            }
            String str = this.extract.nextElement();
            String[] splt1 = str.split("\t");
            splt1[1] = splt1[1].substring(1, splt1[1].length() - 1);
            String[] splt = splt1[1].split(", ");
            if (SamplingScoreBasedClassifier.this.currentParameters.length != splt.length) {
                return false;
            }
            for (int j = 0; j < splt.length; ++j) {
                SamplingScoreBasedClassifier.this.currentParameters[j] = Double.parseDouble(splt[j]);
            }
            SamplingScoreBasedClassifier.this.currentScore = Double.parseDouble(splt1[0]);
            return true;
        }

        @Override
        public void initForSampling(int starts) throws IOException {
            this.outfiles = new File[starts];
            for (int i = 0; i < starts; ++i) {
                this.outfiles[i] = this.getOutfile(i);
            }
            this.inSamplingMode = true;
        }

        private File getOutfile(int idx) throws IOException {
            File f = File.createTempFile(this.outfilePrefix, idx + ".sam", SamplingScoreBasedClassifier.this.tempDir);
            if (SamplingScoreBasedClassifier.this.deleteOnExit) {
                f.deleteOnExit();
            }
            return f;
        }

        @Override
        public void extendSampling(int sampling, boolean append) throws IOException {
            if (this.currSampling >= 0) {
                System.arraycopy(SamplingScoreBasedClassifier.this.currentParameters, 0, SamplingScoreBasedClassifier.this.lastParameters[this.currSampling], 0, SamplingScoreBasedClassifier.this.currentParameters.length);
                SamplingScoreBasedClassifier.this.lastScore[this.currSampling] = SamplingScoreBasedClassifier.this.currentScore;
            }
            System.arraycopy(SamplingScoreBasedClassifier.this.lastParameters[sampling], 0, SamplingScoreBasedClassifier.this.currentParameters, 0, SamplingScoreBasedClassifier.this.currentParameters.length);
            SamplingScoreBasedClassifier.this.currentScore = SamplingScoreBasedClassifier.this.lastScore[sampling];
            this.currSampling = sampling;
            this.curr = new PrintWriter(new FileOutputStream(this.outfiles[sampling], append));
        }

        @Override
        public void samplingStopped() throws IOException {
            if (this.curr != null) {
                this.curr.close();
            }
            this.inSamplingMode = false;
        }

        @Override
        public boolean isInSamplingMode() {
            return this.inSamplingMode;
        }

        @Override
        public void acceptParameters() throws IOException {
            this.curr.println(SamplingScoreBasedClassifier.this.currentScore + "\t" + Arrays.toString(SamplingScoreBasedClassifier.this.currentParameters));
            this.curr.flush();
        }

        protected StringBuffer saveParameters() throws IOException {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.outfiles.length; ++i) {
                StringBuffer temp = FileManager.readFile(this.outfiles[i]);
                XMLParser.addTagsAndAttributes(temp, "outfile", "pos=\"i\"");
                sb.append(temp);
            }
            return sb;
        }

        protected void createFiles(StringBuffer contents) throws NonParsableException, IOException {
            HashMap<String, String> posFilter = new HashMap<String, String>();
            for (int i = 0; i < this.outfiles.length; ++i) {
                posFilter.put("pos", i + "");
                StringBuffer temp = XMLParser.extractForTag(contents, "outfile", null, posFilter);
                FileManager.writeFile(this.outfiles[i], temp);
            }
        }
    }

    public static enum SamplingScheme {
        ALL_PARAMETERS,
        FUNCTION_WISE,
        GROUPED;

    }
}

