/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete.inhomogeneous.shared;

import de.jstacs.NonParsableException;
import de.jstacs.algorithms.graphs.tensor.SymmetricTensor;
import de.jstacs.classifier.ClassDimensionException;
import de.jstacs.classifier.modelBased.ModelBasedClassifier;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.models.Model;
import de.jstacs.models.discrete.inhomogeneous.FSDAGModel;
import de.jstacs.models.discrete.inhomogeneous.StructureLearner;
import de.jstacs.models.discrete.inhomogeneous.parameters.BayesianNetworkModelParameterSet;
import de.jstacs.results.CategoricalResult;

public class SharedStructureClassifier
extends ModelBasedClassifier {
    private StructureLearner.ModelType model;
    private byte order;
    private StructureLearner.LearningType method;
    private StructureLearner sl;

    public SharedStructureClassifier(int length, StructureLearner.ModelType model, byte order, StructureLearner.LearningType method, FSDAGModel ... models) throws IllegalArgumentException, CloneNotSupportedException, ClassDimensionException {
        super(true, (Model[])models);
        this.model = model;
        if (order < 0) {
            throw new IllegalArgumentException("The value of order has to be non-negative.");
        }
        this.order = order;
        this.method = method;
        this.sl = new StructureLearner(this.getAlphabetContainer(), length);
    }

    public SharedStructureClassifier(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public SharedStructureClassifier clone() throws CloneNotSupportedException {
        SharedStructureClassifier clone = (SharedStructureClassifier)super.clone();
        clone.sl = new StructureLearner(this.getAlphabetContainer(), this.getLength());
        return clone;
    }

    @Override
    public void train(Sample[] data, double[][] weights) throws IllegalArgumentException, Exception {
        int dimension = this.models.length;
        SymmetricTensor[] parts = new SymmetricTensor[dimension];
        double[] w = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            this.sl.setESS(((FSDAGModel)this.models[i]).getESS());
            parts[i] = this.sl.getTensor(data[i], weights[i], this.order, this.method);
            w[i] = 1.0;
        }
        FSDAGModel.train(this.models, StructureLearner.getStructure(new SymmetricTensor(parts, w), this.model, this.order), weights, data);
    }

    @Override
    public String getInstanceName() {
        return "shared-structure classifier";
    }

    @Override
    protected void extractFurtherClassifierInfosFromXML(StringBuffer xml) throws NonParsableException {
        super.extractFurtherClassifierInfosFromXML(xml);
        this.model = XMLParser.extractObjectForTags(xml, "model", StructureLearner.ModelType.class);
        this.order = XMLParser.extractObjectForTags(xml, "order", Byte.TYPE);
        this.method = XMLParser.extractObjectForTags(xml, "method", StructureLearner.LearningType.class);
        this.sl = new StructureLearner(this.getAlphabetContainer(), this.getLength());
    }

    @Override
    protected StringBuffer getFurtherClassifierInfos() {
        StringBuffer xml = super.getFurtherClassifierInfos();
        XMLParser.appendObjectWithTags(xml, (Object)this.model, "model");
        XMLParser.appendObjectWithTags(xml, this.order, "order");
        XMLParser.appendObjectWithTags(xml, (Object)this.method, "method");
        return xml;
    }

    @Override
    public CategoricalResult[] getClassifierAnnotation() {
        CategoricalResult[] res = new CategoricalResult[this.models.length + 1];
        res[0] = new CategoricalResult("classifier", "a <b>short</b> description of the classifier", this.getInstanceName());
        int i = 0;
        while (i < this.models.length) {
            res[i + 1] = new CategoricalResult("class info " + i, "some information about the class", BayesianNetworkModelParameterSet.getModelInstanceName(this.model, this.order, this.method, ((FSDAGModel)this.models[i++]).getESS()));
        }
        return res;
    }
}

