/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.hmm;

import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.Storable;
import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.WrongLengthException;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.XMLParser;
import de.jstacs.models.Model;
import de.jstacs.models.hmm.HMMTrainingParameterSet;
import de.jstacs.models.hmm.State;
import de.jstacs.models.hmm.Transition;
import de.jstacs.models.hmm.states.emissions.Emission;
import de.jstacs.models.hmm.transitions.BasicHigherOrderTransition;
import de.jstacs.models.hmm.transitions.HigherOrderTransition;
import de.jstacs.models.hmm.transitions.elements.TransitionElement;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.ToolBox;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public abstract class AbstractHMM
implements Cloneable,
Storable,
Model {
    protected State[] states;
    protected String[] name;
    protected int[] emissionIdx;
    protected boolean[] forward;
    protected Emission[] emission;
    protected Transition transition;
    protected double[][] fwdMatrix;
    protected double[][] bwdMatrix;
    protected AlphabetContainer con;
    protected HMMTrainingParameterSet trainingParameter;
    protected SafeOutputStream sostream;
    protected boolean[] finalState;
    public static final String START_NODE = "START";

    protected AbstractHMM(HMMTrainingParameterSet trainingParameterSet, String[] name, int[] emissionIdx, boolean[] forward, Emission[] emission) throws CloneNotSupportedException, WrongAlphabetException {
        if (!trainingParameterSet.hasDefaultOrIsSet()) {
            throw new IllegalArgumentException("Please check the training parameters.");
        }
        this.trainingParameter = (HMMTrainingParameterSet)trainingParameterSet.clone();
        this.setOutputStream(SafeOutputStream.DEFAULT_STREAM);
        int n = name.length;
        this.name = new String[n];
        HashSet<String> hash = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            if (hash.contains(name[i])) {
                throw new IllegalArgumentException("The state names should be unique. Please check: " + name[i]);
            }
            this.name[i] = name[i];
            hash.add(name[i]);
        }
        hash.clear();
        hash = null;
        if (emissionIdx == null) {
            this.emissionIdx = new int[n];
            for (int e = 0; e < n; ++e) {
                this.emissionIdx[e] = e;
            }
        } else {
            if (n != emissionIdx.length) {
                throw new IllegalArgumentException();
            }
            this.emissionIdx = (int[])emissionIdx.clone();
        }
        if (forward == null) {
            this.forward = new boolean[n];
            Arrays.fill(this.forward, true);
        } else {
            if (n != forward.length) {
                throw new IllegalArgumentException();
            }
            this.forward = (boolean[])forward.clone();
        }
        if (emission.length > n) {
            throw new IllegalArgumentException();
        }
        this.con = AbstractHMM.getAlphabetContainer(emission);
        this.emission = (Emission[])ArrayHandler.clone((Cloneable[])emission);
    }

    private static AlphabetContainer getAlphabetContainer(Emission ... e) throws WrongAlphabetException {
        AlphabetContainer con = null;
        int i = 0;
        while (con == null) {
            con = e[i++].getAlphabetContainer();
        }
        while (i < e.length) {
            AlphabetContainer current;
            if ((current = e[i++].getAlphabetContainer()) == null || current.checkConsistency(con)) continue;
            throw new WrongAlphabetException("All emission should use the same AlphabetContainer.");
        }
        if (!con.isSimple()) {
            throw new IllegalArgumentException("The AlphabetContainer has to be simple.");
        }
        return con;
    }

    protected AbstractHMM(StringBuffer xml) throws NonParsableException {
        this.fromXML(xml);
        this.setOutputStream(SafeOutputStream.DEFAULT_STREAM);
    }

    protected void initTransition(BasicHigherOrderTransition.AbstractTransitionElement ... te) throws Exception {
        boolean[] isSilent = new boolean[this.states.length];
        for (int i = 0; i < this.states.length; ++i) {
            isSilent[i] = this.states[i].isSilent();
        }
        if (te instanceof TransitionElement[]) {
            this.transition = new HigherOrderTransition(isSilent, (TransitionElement[])te);
        } else {
            int t = 0;
            TransitionElement[] help = new TransitionElement[te.length];
            for (int i = 0; i < help.length && te[t] instanceof TransitionElement; ++i) {
                help[t] = (TransitionElement)te[t];
            }
            this.transition = t == te.length ? new HigherOrderTransition(isSilent, help) : new BasicHigherOrderTransition(isSilent, te);
        }
    }

    protected abstract String getXMLTag();

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.transition, "transition");
        XMLParser.appendObjectWithTags(xml, this.name, "name");
        XMLParser.appendObjectWithTags(xml, this.emissionIdx, "emissionIdx");
        XMLParser.appendObjectWithTags(xml, this.forward, "strand");
        XMLParser.appendObjectWithTags(xml, this.emission, "emission");
        XMLParser.appendObjectWithTags(xml, this.trainingParameter, "trainingParameter");
        this.appendFurtherInformation(xml);
        XMLParser.addTags(xml, this.getXMLTag());
        return xml;
    }

    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getXMLTag());
        this.transition = (Transition)XMLParser.extractObjectForTags(xml, "transition");
        this.name = XMLParser.extractObjectForTags(xml, "name", String[].class);
        this.emissionIdx = XMLParser.extractObjectForTags(xml, "emissionIdx", int[].class);
        this.forward = XMLParser.extractObjectForTags(xml, "strand", boolean[].class);
        this.emission = XMLParser.extractObjectForTags(xml, "emission", Emission[].class);
        this.trainingParameter = (HMMTrainingParameterSet)XMLParser.extractObjectForTags(xml, "trainingParameter");
        this.extractFurtherInformation(xml);
        try {
            this.con = AbstractHMM.getAlphabetContainer(this.emission);
        }
        catch (WrongAlphabetException e) {
            NonParsableException npe = new NonParsableException(e.getMessage());
            throw npe;
        }
        this.createStates();
        this.determineFinalStates();
    }

    protected abstract void appendFurtherInformation(StringBuffer var1);

    protected abstract void extractFurtherInformation(StringBuffer var1) throws NonParsableException;

    @Override
    public AbstractHMM clone() throws CloneNotSupportedException {
        AbstractHMM clone = (AbstractHMM)super.clone();
        clone.transition = this.transition.clone();
        clone.fwdMatrix = (double[][])ArrayHandler.clone((Cloneable[])this.fwdMatrix);
        clone.bwdMatrix = (double[][])ArrayHandler.clone((Cloneable[])this.bwdMatrix);
        clone.finalState = (boolean[])this.finalState.clone();
        clone.trainingParameter = (HMMTrainingParameterSet)this.trainingParameter.clone();
        clone.setOutputStream(this.sostream.doesNothing() ? null : SafeOutputStream.DEFAULT_STREAM);
        return clone;
    }

    protected abstract void createStates();

    protected abstract void fillFwdMatrix(int var1, int var2, Sequence var3) throws Exception;

    protected abstract void fillBwdMatrix(int var1, int var2, Sequence var3) throws Exception;

    @Override
    public AlphabetContainer getAlphabetContainer() {
        return this.con;
    }

    @Override
    public boolean setNewAlphabetContainerInstance(AlphabetContainer abc) {
        if (abc.checkConsistency(this.con)) {
            this.con = abc;
            return true;
        }
        return false;
    }

    public String getGraphvizRepresentation(NumberFormat nf) {
        return this.getGraphvizRepresentation(nf, null, null, false);
    }

    public String getGraphvizRepresentation(NumberFormat nf, boolean sameTypeSameRank) {
        return this.getGraphvizRepresentation(nf, null, null, sameTypeSameRank);
    }

    public String getGraphvizRepresentation(NumberFormat nf, Sample data, double[] weight, boolean sameTypeSameRank) {
        double[] freq = null;
        double maxFreq = 0.0;
        if (data != null) {
            try {
                freq = this.getStateFreq(data, weight);
                maxFreq = ToolBox.max(freq);
            }
            catch (Exception e) {
                e.printStackTrace();
                freq = new double[this.states.length];
                maxFreq = 0.0;
            }
        } else {
            freq = new double[this.states.length];
            Arrays.fill(freq, -1.0);
            maxFreq = -1.0;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("digraph G {\n\trankdir=" + (sameTypeSameRank ? "TB" : "LR") + "\n\tedge[arrowhead=vee, arrowsize=0.5]\n\n");
        sb.append("\tSTART[shape=point];\n\n");
        for (int s = 0; s < this.states.length; ++s) {
            sb.append("\t" + s + "[" + this.states[s].getGraphvizNodeOptions(freq[s], maxFreq, nf) + ",color=" + (this.finalState[s] ? "red" : "black") + "];\n");
        }
        if (sameTypeSameRank) {
            StringBuffer ranks = new StringBuffer();
            HashMap<String, IntList> map = new HashMap<String, IntList>();
            for (int s = 0; s < this.states.length; ++s) {
                String key = this.states[s].getEmissionType();
                if (map.get(key) == null) {
                    map.put(key, new IntList());
                }
                ((IntList)map.get(key)).add(s);
            }
            for (String key : map.keySet()) {
                ranks.append("{rank=same; ");
                IntList list = (IntList)map.get(key);
                for (int i = 0; i < list.length(); ++i) {
                    ranks.append(list.get(i) + " ");
                }
                ranks.append(";}\n");
            }
            sb.append(ranks);
        }
        sb.append("\n");
        sb.append(this.transition.getGraphizNetworkRepresentation(nf, null, data != null));
        sb.append("}");
        return sb.toString();
    }

    private double[] getStateFreq(Sample data, double[] weight) throws Exception {
        double[] res = new double[this.states.length];
        if (data != null) {
            double w = 1.0;
            double sum = 0.0;
            double[][] current = this.createMatrixForStatePosterior(0, data.getMaximalElementLength() - 1);
            for (int i = 0; i < data.getNumberOfElements(); ++i) {
                Sequence seq = data.getElementAt(i);
                this.fillLogStatePosteriorMatrix(current, 0, seq.getLength() - 1, data.getElementAt(i), false);
                if (weight != null) {
                    w = weight[i];
                }
                sum += w;
                for (int s = 0; s < this.states.length; ++s) {
                    int n = s;
                    res[n] = res[n] + w * Math.exp(Normalisation.getLogSum(current[s]));
                }
            }
            int s = 0;
            while (s < this.states.length) {
                int n = s++;
                res[n] = res[n] / sum;
            }
        }
        return res;
    }

    protected double[][] createMatrixForStatePosterior(int startPos, int endPos) {
        return new double[this.states.length][endPos - startPos + 1 + 1];
    }

    protected abstract void fillLogStatePosteriorMatrix(double[][] var1, int var2, int var3, Sequence var4, boolean var5) throws Exception;

    public double[][] getLogStatePosteriorMatrixFor(int startPos, int endPos, Sequence seq) throws Exception {
        double[][] m = this.createMatrixForStatePosterior(startPos, endPos);
        this.fillLogStatePosteriorMatrix(m, startPos, endPos, seq, true);
        return this.getFinalStatePosterioriMatrix(m);
    }

    protected double[][] getFinalStatePosterioriMatrix(double[][] intermediate) {
        double[][] res = new double[intermediate.length][];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new double[intermediate[i].length - 1];
            System.arraycopy(intermediate[i], 1, res[i], 0, res[i].length);
        }
        return res;
    }

    public double[][] getStatePosteriorMatrixFor(Sequence seq) throws Exception {
        double[][] matrix = this.getLogStatePosteriorMatrixFor(0, seq.getLength() - 1, seq);
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = Math.exp(matrix[i][j]);
            }
        }
        return matrix;
    }

    public double[][][] getLogStatePosteriorMatrixFor(Sample data) throws Exception {
        double[][][] matrix = new double[data.getNumberOfElements()][][];
        for (int i = 0; i < matrix.length; ++i) {
            Sequence s = data.getElementAt(i);
            matrix[i] = this.getLogStatePosteriorMatrixFor(0, s.getLength() - 1, s);
        }
        return matrix;
    }

    public double[][][] getStatePosteriorMatrixFor(Sample data) throws Exception {
        double[][][] matrix = new double[data.getNumberOfElements()][][];
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i] = this.getStatePosteriorMatrixFor(data.getElementAt(i));
        }
        return matrix;
    }

    public abstract Pair<IntList, Double> getViterbiPathFor(int var1, int var2, Sequence var3) throws Exception;

    public Pair<IntList, Double> getViterbiPathFor(Sequence seq) throws Exception {
        return this.getViterbiPathFor(0, seq.getLength() - 1, seq);
    }

    public Pair<IntList, Double>[] getViterbiPathsFor(Sample data) throws Exception {
        Pair[] matrix = new Pair[data.getNumberOfElements()];
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i] = this.getViterbiPathFor(data.getElementAt(i));
        }
        return matrix;
    }

    public abstract double getLogProbForPath(IntList var1, int var2, Sequence var3) throws Exception;

    protected abstract void createHelperVariables();

    protected void provideMatrix(int type, int length) {
        Object matrix;
        this.createHelperVariables();
        ++length;
        switch (type) {
            case 0: {
                matrix = this.fwdMatrix;
                break;
            }
            case 1: {
                matrix = this.bwdMatrix;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown matrix type");
            }
        }
        if (matrix == null || ((double[][])matrix).length < length) {
            matrix = new double[length][];
            int maxOrder = this.transition.getMaximalMarkovOrder();
            int dim = -1;
            int l = 0;
            for (l = 0; l <= maxOrder && l < length; ++l) {
                dim = this.transition.getNumberOfIndexes(l);
                matrix[l] = new double[dim];
            }
            while (l < length) {
                matrix[l++] = new double[dim];
            }
        }
        for (int l = 0; l < length; ++l) {
            Arrays.fill(matrix[l], Double.NEGATIVE_INFINITY);
        }
        switch (type) {
            case 0: {
                this.fwdMatrix = matrix;
                break;
            }
            case 1: {
                this.bwdMatrix = matrix;
            }
        }
    }

    public int getNumberOfStates() {
        return this.states.length;
    }

    @Override
    public double getProbFor(Sequence sequence) throws NotTrainedException, Exception {
        return this.getProbFor(sequence, 0, sequence.getLength() - 1);
    }

    @Override
    public double getProbFor(Sequence sequence, int startpos) throws NotTrainedException, Exception {
        return Math.exp(this.getLogProbFor(sequence, startpos));
    }

    @Override
    public double getProbFor(Sequence sequence, int startpos, int endpos) throws Exception {
        return Math.exp(this.getLogProbFor(sequence, startpos, endpos));
    }

    @Override
    public double getLogProbFor(Sequence sequence) throws Exception {
        return this.getLogProbFor(sequence, 0, sequence.getLength() - 1);
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos) throws Exception {
        if (this.getLength() == 0) {
            return this.getLogProbFor(sequence, startpos, sequence.getLength() - 1);
        }
        return this.getLogProbFor(sequence, startpos, startpos + this.getLength() - 1);
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws Exception {
        int l = endpos - startpos + 1;
        int len = this.getLength();
        if (!sequence.getAlphabetContainer().checkConsistency(this.getAlphabetContainer())) {
            throw new WrongAlphabetException("The AlphabetContainer of the sequence and the model do not match.");
        }
        if (len != 0 && l != len) {
            throw new WrongLengthException("The given start position (" + startpos + ") and end position (" + endpos + ") yield an length of " + l + " which is not possible for the current model that models sequences of length " + len + ".");
        }
        return this.logProb(startpos, endpos, sequence);
    }

    protected static RuntimeException getRunTimeException(Exception e) {
        RuntimeException re;
        if (e instanceof RuntimeException) {
            re = (RuntimeException)e;
        } else {
            re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
        }
        return re;
    }

    protected double logProb(int startpos, int endpos, Sequence sequence) throws Exception {
        try {
            this.fillBwdMatrix(startpos, endpos, sequence);
        }
        catch (Exception e) {
            throw AbstractHMM.getRunTimeException(e);
        }
        return this.bwdMatrix[0][0];
    }

    @Override
    public double getPriorTerm() throws Exception {
        return Math.exp(this.getLogPriorTerm());
    }

    @Override
    public void train(Sample data) throws Exception {
        this.train(data, null);
    }

    public final void setOutputStream(OutputStream o) {
        this.sostream = new SafeOutputStream(o);
    }

    protected void finalize() throws Throwable {
        this.transition = null;
        this.states = null;
        this.trainingParameter = null;
        this.bwdMatrix = null;
        this.fwdMatrix = null;
        super.finalize();
    }

    protected void determineFinalStates() {
        int i;
        this.finalState = this.transition.isAbsoring();
        for (i = 0; i < this.finalState.length && !this.finalState[i]; ++i) {
        }
        if (i == this.finalState.length) {
            for (i = 0; i < this.finalState.length; ++i) {
                this.finalState[i] = !this.states[i].isSilent();
            }
        }
    }

    public static int[][] decodeStatePosterior(double[][] ... statePosterior) {
        int[][] res = new int[statePosterior.length][];
        for (int s = 0; s < res.length; ++s) {
            res[s] = new int[statePosterior[s][0].length];
            for (int l = 0; l < res[s].length; ++l) {
                res[s][l] = 0;
                for (int j = 1; j < statePosterior[s].length; ++j) {
                    if (!(statePosterior[s][res[s][l]][l] < statePosterior[s][j][l])) continue;
                    res[s][l] = j;
                }
            }
        }
        return res;
    }

    @Override
    public String toString() {
        String res = "Transition:\n-----------\n" + this.transition.toString(this.name);
        res = res + "\nStates:\n-------\n";
        for (int e = 0; e < this.states.length; ++e) {
            res = res + this.states[e] + "\n";
        }
        return res;
    }
}

