/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery;

import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.annotation.LocatedSequenceAnnotation;
import de.jstacs.data.sequences.annotation.LocatedSequenceAnnotationWithLength;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.ArrayHandler;
import de.jstacs.results.ListResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.DoubleList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class MotifDiscoveryAssessment {
    public static ListResult assess(Sample truth, Sample prediction, int maxDiff) throws Exception {
        if (truth.getNumberOfElements() != prediction.getNumberOfElements()) {
            throw new Exception("Truth must contain same number of sequences as prediction.");
        }
        HashMap<String, IdentifiersOfType> mapT = new HashMap<String, IdentifiersOfType>();
        HashMap<String, IdentifiersOfType> mapP = new HashMap<String, IdentifiersOfType>();
        for (int i = 0; i < truth.getNumberOfElements(); ++i) {
            Sequence seqP;
            Sequence seqT = truth.getElementAt(i);
            if (!seqT.equals(seqP = prediction.getElementAt(i))) {
                throw new Exception("samples incomparable: check sequence " + i);
            }
            SequenceAnnotation[] ann = seqT.getAnnotation();
            if (ann != null) {
                MotifDiscoveryAssessment.fillLocatedSequenceAnnotations(mapT, ann);
            }
            if ((ann = seqP.getAnnotation()) == null) continue;
            MotifDiscoveryAssessment.fillLocatedSequenceAnnotations(mapP, ann);
        }
        ResultSet[] ress = new NumericalResultSet[mapT.size()];
        Collection collT = mapT.values();
        Iterator itT = collT.iterator();
        int idx = 0;
        while (itT.hasNext()) {
            IdentifiersOfType idT = (IdentifiersOfType)itT.next();
            idT.reset();
            idT.nextPermutation();
            int[][] annotT = new int[truth.getNumberOfElements()][];
            for (int i = 0; i < truth.getNumberOfElements(); ++i) {
                annotT[i] = MotifDiscoveryAssessment.getAnnot(truth.getElementAt(i), idT);
            }
            IdentifiersOfType idP = mapP.get(idT.getType());
            if (idP == null) {
                ress[idx] = new NumericalResultSet(new NumericalResult[0][]);
                ++idx;
                continue;
            }
            idP.reset();
            int[][] annotP = new int[prediction.getNumberOfElements()][];
            ResultSet bestNMeasures = null;
            ResultSet bestSMeasures = null;
            while (idP.nextPermutation()) {
                for (int i = 0; i < prediction.getNumberOfElements(); ++i) {
                    annotP[i] = MotifDiscoveryAssessment.getAnnot(prediction.getElementAt(i), idP);
                }
                NumericalResultSet nMeasures = MotifDiscoveryAssessment.computeNucleotideLevelMeasures(annotT, annotP, idT);
                if (bestNMeasures != null && ((NumericalResultSet)bestNMeasures).getResultAt(bestNMeasures.getNumberOfResults() - 1).getResult().compareTo(nMeasures.getResultAt(nMeasures.getNumberOfResults() - 1).getResult()) >= 0) continue;
                bestNMeasures = nMeasures;
                bestSMeasures = MotifDiscoveryAssessment.computeSiteLevelMeasures(truth, prediction, maxDiff, idT, idP);
            }
            ress[idx] = new NumericalResultSet(ArrayHandler.cast(NumericalResult.class, bestNMeasures.getResults()), ArrayHandler.cast(NumericalResult.class, bestSMeasures.getResults()));
            ++idx;
        }
        return new ListResult("Motif discovery assessment", "Assessment of the motif discovery result on nucleotide and site level", null, ress);
    }

    private static NumericalResultSet computeSiteLevelMeasures(Sample truth, Sample prediction, int maxDiff, IdentifiersOfType idT, IdentifiersOfType idP) {
        LinkedList<LocatedSequenceAnnotation> listT = new LinkedList<LocatedSequenceAnnotation>();
        LinkedList<LocatedSequenceAnnotation> listP = new LinkedList<LocatedSequenceAnnotation>();
        LinkedList<NumericalResult> list = new LinkedList<NumericalResult>();
        Iterator it = idT.keySet().iterator();
        while (it.hasNext()) {
            double tp = 0.0;
            double fn = 0.0;
            double fp = 0.0;
            String t = (String)it.next();
            for (int i = 0; i < truth.getNumberOfElements(); ++i) {
                boolean found;
                listT.clear();
                listP.clear();
                Sequence seq = truth.getElementAt(i);
                MotifDiscoveryAssessment.getLSA(listT, seq.getAnnotation(), idT.getType(), t);
                seq = prediction.getElementAt(i);
                MotifDiscoveryAssessment.getLSA(listP, seq.getAnnotation(), idP.getType(), idP.getIdentifierForIdx((Integer)idT.get(t)));
                Iterator itT = listT.iterator();
                Iterator itP = null;
                while (itT.hasNext()) {
                    found = false;
                    LocatedSequenceAnnotation anT = (LocatedSequenceAnnotation)itT.next();
                    for (LocatedSequenceAnnotation anP : listP) {
                        if (Math.abs(anT.getPosition() - anP.getPosition()) > maxDiff) continue;
                        found = true;
                    }
                    if (found) {
                        tp += 1.0;
                        continue;
                    }
                    fn += 1.0;
                }
                itP = listP.iterator();
                while (itP.hasNext()) {
                    found = false;
                    LocatedSequenceAnnotation anP = (LocatedSequenceAnnotation)itP.next();
                    for (LocatedSequenceAnnotation anT : listT) {
                        if (Math.abs(anT.getPosition() - anP.getPosition()) > maxDiff) continue;
                        found = true;
                    }
                    if (found) continue;
                    fp += 1.0;
                }
            }
            list.add(new NumericalResult("sSn: " + idT.getType() + ", " + t, "Sensitivity for type " + idT.getType() + " and identifier " + t + " (site level)", tp / (tp + fn)));
            list.add(new NumericalResult("sPPV: " + idT.getType() + ", " + t, "Positive predictive value for type " + idT.getType() + " and identifier " + t + " (site level)", tp / (tp + fp)));
            list.add(new NumericalResult("sPC: " + idT.getType() + ", " + t, "Performance coefficient for type " + idT.getType() + " and identifier " + t + " (site level)", tp / (tp + fn + fp)));
            list.add(new NumericalResult("sASP: " + idT.getType() + ", " + t, "Average site performance for type " + idT.getType() + " and identifier " + t + " (site level)", (tp / (tp + fn) + tp / (tp + fp)) / 2.0));
        }
        return new NumericalResultSet(list);
    }

    private static void getLSA(LinkedList<LocatedSequenceAnnotation> list, SequenceAnnotation[] anns, String type, String id) {
        if (anns == null) {
            return;
        }
        for (int i = 0; i < anns.length; ++i) {
            SequenceAnnotation[] sub;
            SequenceAnnotation ann = anns[i];
            if (ann instanceof LocatedSequenceAnnotation && ann.getType().equals(type) && ann.getIdentifier().equals(id)) {
                list.add((LocatedSequenceAnnotation)ann);
            }
            if ((sub = ann.getSubAnnotations()) == null) continue;
            MotifDiscoveryAssessment.getLSA(list, sub, type, id);
        }
    }

    private static NumericalResultSet computeNucleotideLevelMeasures(int[][] truth, int[][] prediction, IdentifiersOfType ids) {
        Iterator it = ids.entrySet().iterator();
        LinkedList<NumericalResult> list = new LinkedList<NumericalResult>();
        while (it.hasNext()) {
            Map.Entry en = it.next();
            double tp = 0.0;
            double tn = 0.0;
            double fp = 0.0;
            double fn = 0.0;
            for (int i = 0; i < truth.length; ++i) {
                for (int j = 0; j < truth[i].length; ++j) {
                    if (truth[i][j] == (Integer)en.getValue()) {
                        if (prediction[i][j] == truth[i][j]) {
                            tp += 1.0;
                            continue;
                        }
                        fn += 1.0;
                        continue;
                    }
                    if (prediction[i][j] != (Integer)en.getValue()) {
                        tn += 1.0;
                        continue;
                    }
                    fp += 1.0;
                }
            }
            list.add(new NumericalResult("nSn: " + ids.getType() + ", " + (String)en.getKey(), "Sensitivity for type " + ids.getType() + " and identifier " + (String)en.getKey() + " (nucleotide level)", tp / (tp + fn)));
            list.add(new NumericalResult("nSp: " + ids.getType() + ", " + (String)en.getKey(), "Specificity for type " + ids.getType() + " and identifier " + (String)en.getKey() + " (nucleotide level)", tn / (tn + fp)));
            list.add(new NumericalResult("nPPV: " + ids.getType() + ", " + (String)en.getKey(), "Positive predictive value for type " + ids.getType() + " and identifier " + (String)en.getKey() + " (nucleotide level)", tp / (tp + fp)));
            list.add(new NumericalResult("nPC: " + ids.getType() + ", " + (String)en.getKey(), "Performance coefficient for type " + ids.getType() + " and identifier " + (String)en.getKey() + " (nucleotide level)", tp / (tp + fn + fp)));
            list.add(new NumericalResult("nASP: " + ids.getType() + ", " + (String)en.getKey(), "Average site performance for type " + ids.getType() + " and identifier " + (String)en.getKey() + " (nucleotide level)", (tp / (tp + fn) + tp / (tp + fp)) / 2.0));
            list.add(new NumericalResult("nCC: " + ids.getType() + ", " + (String)en.getKey(), "Correlation coefficient for type " + ids.getType() + " and identifier " + (String)en.getKey() + " (nucleotide level)", (tp * tn - fn * fp) / Math.sqrt((tp + fn) * (tn + fp) * (tp + fp) * (tn + fn))));
            list.add(new NumericalResult("nCR: " + ids.getType() + ", " + (String)en.getKey(), "Classification rate for type " + ids.getType() + " and identifier " + (String)en.getKey() + " (nucleotide level)", (tp + tn) / (tp + tn + fp + fn)));
        }
        int corr = 0;
        int wr = 0;
        for (int i = 0; i < truth.length; ++i) {
            for (int j = 0; j < truth[i].length; ++j) {
                if (truth[i][j] == prediction[i][j]) {
                    ++corr;
                    continue;
                }
                ++wr;
            }
        }
        list.add(new NumericalResult("ngCR: " + ids.getType(), "Global classification rate for type " + ids.getType() + " (nucleotide level)", (double)corr / (double)(corr + wr)));
        return new NumericalResultSet(list);
    }

    private static int[] getAnnot(Sequence seq, IdentifiersOfType ids) {
        int[] annot = new int[seq.getLength()];
        Arrays.fill(annot, -1);
        SequenceAnnotation[] ann = seq.getAnnotation();
        if (ann != null) {
            MotifDiscoveryAssessment.getAnnot(annot, ann, ids);
        }
        return annot;
    }

    private static void getAnnot(int[] annot, SequenceAnnotation[] anns, IdentifiersOfType ids) {
        for (int i = 0; i < anns.length; ++i) {
            SequenceAnnotation[] sub;
            SequenceAnnotation ann = anns[i];
            if (ann.getType().equals(ids.getType()) && ann instanceof LocatedSequenceAnnotation) {
                int idx;
                int pos = ((LocatedSequenceAnnotation)ann).getPosition();
                annot[pos] = idx = ids.getIdxForIdentifier((LocatedSequenceAnnotation)ann);
                if (ann instanceof LocatedSequenceAnnotationWithLength) {
                    int length = ((LocatedSequenceAnnotationWithLength)ann).getLength();
                    for (int j = 1; j < length; ++j) {
                        annot[pos + j] = idx;
                    }
                }
            }
            if ((sub = ann.getSubAnnotations()) == null) continue;
            MotifDiscoveryAssessment.getAnnot(annot, sub, ids);
        }
    }

    private static void fillLocatedSequenceAnnotations(HashMap<String, IdentifiersOfType> map, SequenceAnnotation[] anns) throws Exception {
        for (int i = 0; i < anns.length; ++i) {
            SequenceAnnotation[] sub;
            SequenceAnnotation ann = anns[i];
            if (ann instanceof LocatedSequenceAnnotation) {
                if (map.get(ann.getType()) == null) {
                    map.put(ann.getType(), new IdentifiersOfType(ann.getType()));
                }
                map.get(ann.getType()).addIdentifier((LocatedSequenceAnnotation)ann);
            }
            if ((sub = ann.getSubAnnotations()) == null) continue;
            MotifDiscoveryAssessment.fillLocatedSequenceAnnotations(map, sub);
        }
    }

    public static double[][] getSortedValuesForMotifAndFlanking(Sample data, double[][] values, double offset, double factor, String identifier) {
        boolean[] added = null;
        DoubleList pos = new DoubleList(1000);
        DoubleList neg = new DoubleList(100000);
        for (int i = 0; i < data.getNumberOfElements(); ++i) {
            int k;
            Sequence seq = data.getElementAt(i);
            SequenceAnnotation[] seqAn = seq.getAnnotation();
            if (added == null || added.length != seq.getLength()) {
                added = new boolean[seq.getLength()];
            }
            Arrays.fill(added, false);
            if (seqAn != null) {
                for (int j = 0; j < seqAn.length; ++j) {
                    if (!(seqAn[j] instanceof LocatedSequenceAnnotationWithLength) || !seqAn[j].getIdentifier().equalsIgnoreCase(identifier)) continue;
                    LocatedSequenceAnnotationWithLength lsawl = (LocatedSequenceAnnotationWithLength)seqAn[j];
                    int s = lsawl.getPosition();
                    int l = lsawl.getLength();
                    k = 0;
                    while (k < l) {
                        if (!added[s]) {
                            pos.add(offset + factor * values[i][s]);
                            added[s] = true;
                        }
                        ++k;
                        ++s;
                    }
                }
            }
            for (k = 0; k < added.length; ++k) {
                if (added[k]) continue;
                neg.add(offset + factor * values[i][k]);
            }
        }
        double[][] res = new double[][]{pos.toArray(), neg.toArray()};
        Arrays.sort(res[0]);
        Arrays.sort(res[1]);
        return res;
    }

    public static double[][] getSortedScoresForMotifAndFlanking(Sample data, Sample pred, String identifier) {
        boolean[] added = new boolean[data.getElementLength()];
        double[] scores = new double[data.getElementLength()];
        DoubleList pos = new DoubleList(1000);
        DoubleList neg = new DoubleList(100000);
        for (int i = 0; i < data.getNumberOfElements(); ++i) {
            int k;
            LocatedSequenceAnnotationWithLength lsawl;
            Arrays.fill(added, false);
            SequenceAnnotation[] seqAn = data.getElementAt(i).getAnnotation();
            SequenceAnnotation[] predAn = pred.getElementAt(i).getAnnotation();
            Arrays.fill(scores, -1.7976931348623157E308);
            for (int p = 0; predAn != null && p < predAn.length; ++p) {
                int q;
                if (!(predAn[p] instanceof LocatedSequenceAnnotationWithLength)) continue;
                lsawl = (LocatedSequenceAnnotationWithLength)predAn[p];
                int start = lsawl.getPosition();
                int end = lsawl.getEnd();
                double score = -1.7976931348623157E308;
                Result[] addRes = lsawl.getAnnotations();
                for (q = 0; q < addRes.length; ++q) {
                    if (!"score".equals(addRes[q].getName()) || !(addRes[q] instanceof NumericalResult)) continue;
                    score = (Double)((NumericalResult)addRes[q]).getResult();
                }
                for (q = start; q < end; ++q) {
                    scores[q] = Math.max(score, scores[q]);
                }
            }
            if (seqAn != null) {
                for (int j = 0; j < seqAn.length; ++j) {
                    if (!(seqAn[j] instanceof LocatedSequenceAnnotationWithLength) || !seqAn[j].getIdentifier().equalsIgnoreCase(identifier)) continue;
                    lsawl = (LocatedSequenceAnnotationWithLength)seqAn[j];
                    int s = lsawl.getPosition();
                    int l = lsawl.getLength();
                    k = 0;
                    while (k < l) {
                        if (!added[s]) {
                            pos.add(scores[s]);
                            added[s] = true;
                        }
                        ++k;
                        ++s;
                    }
                }
            }
            for (k = 0; k < added.length; ++k) {
                if (added[k]) continue;
                neg.add(scores[k]);
            }
        }
        double[][] res = new double[][]{pos.toArray(), neg.toArray()};
        Arrays.sort(res[0]);
        Arrays.sort(res[1]);
        return res;
    }

    private static class IdentifiersOfType
    extends HashMap<String, Integer> {
        private String type;
        private int nextIdx;
        private int[] perm;
        private int exchangeNext;

        public IdentifiersOfType(String type) {
            this.type = type;
            this.nextIdx = 0;
        }

        public String getType() {
            return this.type;
        }

        public void addIdentifier(LocatedSequenceAnnotation ann) throws Exception {
            if (ann.getType() != this.type) {
                throw new Exception("Wrong type");
            }
            String id = ann.getIdentifier();
            if (this.get(id) == null) {
                this.put(id, this.nextIdx);
                ++this.nextIdx;
            }
        }

        public String getIdentifierForIdx(int idx) {
            for (Map.Entry en : this.entrySet()) {
                if ((Integer)en.getValue() != idx) continue;
                return (String)en.getKey();
            }
            return null;
        }

        public int getIdxForIdentifier(LocatedSequenceAnnotation ann) {
            String id = ann.getIdentifier();
            return this.perm[(Integer)this.get(id)];
        }

        public void reset() {
            this.perm = null;
        }

        public boolean nextPermutation() {
            if (this.perm == null) {
                this.perm = new int[this.size()];
                for (int i = 0; i < this.perm.length; ++i) {
                    this.perm[i] = i;
                }
                this.exchangeNext = this.perm.length - 1;
                return true;
            }
            if (this.perm.length == 1) {
                return false;
            }
            int temp = this.perm[this.exchangeNext];
            this.perm[this.exchangeNext] = this.perm[this.exchangeNext - 1];
            this.perm[this.exchangeNext - 1] = temp;
            --this.exchangeNext;
            if (this.exchangeNext == 0) {
                this.exchangeNext = this.perm.length - 1;
            }
            for (int i = 0; i < this.perm.length - 1; ++i) {
                if (this.perm[i] == this.perm[i + 1] - 1) continue;
                return true;
            }
            return false;
        }
    }
}

