/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.RangeIterator;
import de.jstacs.parameters.Rangeable;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.utils.galaxy.GalaxyAdaptor;

public class ParameterSetContainer
extends Parameter
implements Rangeable,
RangeIterator,
GalaxyConvertible {
    private String name;
    private String comment;
    private ParameterSet parameters;
    protected String errorMessage;

    public ParameterSetContainer(String name, String comment, ParameterSet content) {
        this.name = name;
        this.comment = comment;
        this.parameters = content;
        this.parameters.setParent(this);
        this.errorMessage = null;
    }

    public ParameterSetContainer(StringBuffer representation) throws NonParsableException {
        this.fromXML(representation);
    }

    @Override
    public ParameterSetContainer clone() throws CloneNotSupportedException {
        ParameterSetContainer clone = (ParameterSetContainer)super.clone();
        ParameterSet parameterSet = clone.parameters = this.parameters == null ? null : this.parameters.clone();
        if (clone.parameters != null) {
            clone.parameters.setParent(clone);
        }
        return clone;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataType getDatatype() {
        return DataType.PARAMETERSET;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public boolean checkValue(Object value) {
        return value == null || this.parameters.getClass().isInstance(value);
    }

    @Override
    public void setValue(Object value) throws SimpleParameter.IllegalValueException {
        if (!this.checkValue(value)) {
            throw new SimpleParameter.IllegalValueException("Only parameter sets allowed for ParameterSetContainer!");
        }
        this.parameters = (ParameterSet)value;
        this.parameters.setParent(this);
    }

    @Override
    public ParameterSet getValue() {
        return this.parameters;
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        return this.parameters != null && this.parameters.hasDefaultOrIsSet();
    }

    @Override
    public boolean isSet() {
        return this.parameters != null;
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public String getErrorMessage() {
        return this.parameters.getErrorMessage();
    }

    @Override
    public void simplify() {
        this.parameters.simplify();
    }

    @Override
    public void reset() {
        this.parameters.reset();
    }

    @Override
    public void setDefault(Object defaultValue) throws Exception {
        throw new Exception("Not applicable to ParameterSetContainer");
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameter");
        XMLParser.appendObjectWithTags(buf, this.name, "name");
        XMLParser.appendObjectWithTags(buf, this.comment, "comment");
        XMLParser.appendObjectWithTags(buf, this.errorMessage, "errorMessage");
        XMLParser.appendObjectWithTags(buf, this.parameters, "parameters");
        XMLParser.addTags(buf, "parameterSetContainer");
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "parameterSetContainer");
        super.fromXML(XMLParser.extractForTag(representation, "superParameter"));
        this.name = XMLParser.extractObjectForTags(representation, "name", String.class);
        this.comment = XMLParser.extractObjectForTags(representation, "comment", String.class);
        this.errorMessage = XMLParser.parseString(XMLParser.extractObjectForTags(representation, "errorMessage", String.class));
        this.parameters = XMLParser.extractObjectForTags(representation, "parameters", ParameterSet.class);
        this.parameters.setParent(this);
    }

    @Override
    public boolean isRangeable() {
        return true;
    }

    @Override
    public Parameter getRangedInstance() throws Exception {
        this.parameters.makeRanged();
        return this;
    }

    @Override
    public boolean next() throws ParameterException {
        return this.parameters.next();
    }

    @Override
    public void resetToFirst() {
        this.parameters.resetToFirst();
    }

    @Override
    public boolean isRanged() {
        return this.parameters.isRanged();
    }

    @Override
    public int getNumberOfValues() {
        return this.parameters.getNumberOfValues();
    }

    @Override
    public String valuesToString() {
        return "(" + this.parameters.valuesToString() + ")";
    }

    @Override
    public void toGalaxy(String namePrefix, String configPrefix, int depth, StringBuffer descBuffer, StringBuffer configBuffer) throws Exception {
        StringBuffer pars = new StringBuffer();
        this.parameters.toGalaxy(namePrefix, configPrefix, depth + 1, pars, configBuffer);
        String color = GalaxyAdaptor.getColor(depth);
        StringBuffer buf = new StringBuffer();
        XMLParser.addTagsAndAttributes(buf, "param", "type=\"hidden\" name=\"" + namePrefix + "_contbegin" + "\" help=\"&lt;hr style=&quot;height:2px;background-color:" + color + ";color:" + color + ";border:none&quot; /&gt;\"");
        buf.append(pars);
        StringBuffer buf2 = new StringBuffer();
        XMLParser.addTagsAndAttributes(buf2, "param", "type=\"hidden\" name=\"" + namePrefix + "_contend" + "\" help=\"&lt;hr style=&quot;height:2px;background-color:" + color + ";color:" + color + ";border:none&quot; /&gt;\"");
        buf.append(buf2);
        descBuffer.append(buf);
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
        this.parameters.fromGalaxy(namePrefix, command);
    }
}

