/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.AlphabetContainerParameterSet;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.Rangeable;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;

public abstract class SequenceScoringParameterSet
extends InstanceParameterSet {
    protected Parameter alphabet;
    protected Parameter length;
    private boolean variableLength;

    public SequenceScoringParameterSet(Class instanceClass, AlphabetContainer.AlphabetContainerType type, boolean simple) {
        this(instanceClass, type, simple, false);
    }

    public SequenceScoringParameterSet(Class instanceClass, AlphabetContainer.AlphabetContainerType type, boolean simple, boolean variableLength) {
        super(instanceClass);
        this.variableLength = variableLength;
        try {
            this.alphabet = new ParameterSetContainer("Alphabet", "The alphabet the model works on", new AlphabetContainerParameterSet(type, simple));
            this.length = variableLength ? new SimpleParameter(DataType.INT, "Length", "The length of sequences the model can work on", true, new NumberValidator<Integer>(0, 0), 0) : new SimpleParameter(DataType.INT, "Length", "The length of sequences the model can work on", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE));
        }
        catch (ParameterException doesNotHappen) {
            // empty catch block
        }
        try {
            this.loadParameters();
        }
        catch (Exception e) {
            UnsupportedOperationException u = new UnsupportedOperationException(e.getMessage());
            u.setStackTrace(e.getStackTrace());
            throw u;
        }
    }

    public SequenceScoringParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public SequenceScoringParameterSet(Class instanceClass, AlphabetContainer alphabet, int length, boolean variableLength) throws Exception {
        this(instanceClass, alphabet.getType(), alphabet.isSimple(), variableLength);
        this.length.setValue(length);
        this.alphabet.setValue(alphabet.getCurrentParameterSet());
    }

    public SequenceScoringParameterSet(Class instanceClass, AlphabetContainer alphabet) throws Exception {
        this(instanceClass, alphabet, 0, true);
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        boolean erg;
        boolean bl = erg = super.hasDefaultOrIsSet() && this.alphabet.hasDefaultOrIsSet() && this.length.hasDefaultOrIsSet();
        if (erg) {
            int l = 0;
            if (this.alphabet != null) {
                l = ((AlphabetContainerParameterSet)this.alphabet.getValue()).getPossibleLength();
            }
            if (!(erg &= l == 0 || (Integer)this.length.getValue() == l)) {
                this.errorMessage = "The length of the alphabet and the length of the model must match!";
            }
        }
        return erg;
    }

    @Override
    public void reset() {
        super.reset();
        this.length.reset();
        this.alphabet.reset();
    }

    public AlphabetContainer getAlphabetContainer() {
        try {
            AlphabetContainer cont = new AlphabetContainer((AlphabetContainerParameterSet)this.alphabet.getValue());
            return cont;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getLength() throws IllegalArgumentException {
        int l = (Integer)this.length.getValue();
        if (this.variableLength && l != 0) {
            throw new IllegalArgumentException("The model can handle sequences of variable length, but length is defined as " + l);
        }
        return l;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "sequenceScoringParameterSet");
        super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
        this.variableLength = XMLParser.extractObjectForTags(representation, "variableLength", Boolean.TYPE);
        StringBuffer alphStringB = XMLParser.extractForTag(representation, "alphabet");
        this.alphabet = alphStringB == null ? null : new ParameterSetContainer(alphStringB);
        this.length = new SimpleParameter(XMLParser.extractForTag(representation, "length"));
    }

    @Override
    public int getNumberOfParameters() {
        if (this.variableLength) {
            return super.getNumberOfParameters() + 1;
        }
        return super.getNumberOfParameters() + 2;
    }

    @Override
    protected void replaceParametersWithRangedInstance() throws Exception {
        if (this.alphabet instanceof Rangeable && ((Rangeable)((Object)this.alphabet)).isRangeable()) {
            this.alphabet = ((Rangeable)((Object)this.alphabet)).getRangedInstance();
        }
        if (this.length instanceof Rangeable && ((Rangeable)((Object)this.length)).isRangeable()) {
            this.length = ((Rangeable)((Object)this.length)).getRangedInstance();
        }
        super.replaceParametersWithRangedInstance();
    }

    @Override
    public Parameter getParameterAt(int i) {
        if (i < super.getNumberOfParameters()) {
            return super.getParameterAt(i);
        }
        if (i == super.getNumberOfParameters()) {
            return this.alphabet;
        }
        if (!this.variableLength) {
            return this.length;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameters");
        XMLParser.appendObjectWithTags(buf, this.variableLength, "variableLength");
        if (this.alphabet != null) {
            XMLParser.appendObjectWithTags(buf, this.alphabet, "alphabet");
        }
        XMLParser.appendObjectWithTags(buf, this.length, "length");
        XMLParser.addTags(buf, "sequenceScoringParameterSet");
        return buf;
    }

    public boolean equals(Object o) {
        if (o instanceof SequenceScoringParameterSet) {
            boolean erg;
            SequenceScoringParameterSet comp = (SequenceScoringParameterSet)o;
            int i = 0;
            for (erg = this.getInstanceClass().equals(comp.getInstanceClass()) && this.getLength() == comp.getLength() && this.parameters.size() == comp.parameters.size() && this.getAlphabetContainer().checkConsistency(comp.getAlphabetContainer()) ? true : false; i < this.parameters.size() && erg; erg &= ((Parameter)this.parameters.get(i)).equals(comp.parameters.get(i++))) {
            }
            return erg;
        }
        return false;
    }

    @Override
    public SequenceScoringParameterSet clone() throws CloneNotSupportedException {
        SequenceScoringParameterSet res = (SequenceScoringParameterSet)super.clone();
        res.alphabet = this.alphabet.clone();
        res.length = this.length.clone();
        return res;
    }
}

