/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageResult
extends Result {
    private BufferedImage image;
    private static final String XML_TAG = "ImageResult";

    public ImageResult(String name, String comment, BufferedImage image) {
        super(name, comment, DataType.PNG);
        this.image = image;
    }

    public ImageResult(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public BufferedImage getResult() {
        return this.image;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.name, "name");
        XMLParser.appendObjectWithTags(xml, this.comment, "comment");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        try {
            ImageIO.write((RenderedImage)this.image, "png", baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        XMLParser.appendObjectWithTags(xml, Base64.encode(baos.toByteArray()), "image");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, XML_TAG);
        this.name = (String)XMLParser.extractObjectForTags(representation, "name");
        this.comment = (String)XMLParser.extractObjectForTags(representation, "comment");
        try {
            byte[] bytearray = Base64.decode((String)XMLParser.extractObjectForTags(representation, "image"));
            this.image = ImageIO.read(new ByteArrayInputStream(bytearray));
        }
        catch (Exception e) {
            throw new NonParsableException(e.getMessage());
        }
    }

    public String toString() {
        return this.name + ": [image]";
    }
}

