/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.results.ResultSet;
import java.util.Arrays;

public abstract class TwoClassAbstractPerformanceMeasure
extends AbstractPerformanceMeasure {
    protected TwoClassAbstractPerformanceMeasure() {
    }

    protected TwoClassAbstractPerformanceMeasure(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public ResultSet compute(double[][][] classSpecificScores) {
        if (classSpecificScores.length != 2) {
            throw new RuntimeException("Only two classes possible for " + this.getName());
        }
        double[][] classificationScores = new double[2][];
        for (int i = 0; i < classSpecificScores.length; ++i) {
            classificationScores[i] = new double[classSpecificScores[i].length];
            for (int j = 0; j < classSpecificScores[i].length; ++j) {
                if (classSpecificScores[i][j].length != 2) {
                    throw new RuntimeException("Only two classes possible for " + this.getName());
                }
                classificationScores[i][j] = classSpecificScores[i][j][0] - classSpecificScores[i][j][1];
            }
            Arrays.sort(classificationScores[i]);
        }
        return this.compute(classificationScores[0], classificationScores[1]);
    }

    @Override
    public final int getAllowedNumberOfClasses() {
        return 2;
    }
}

