/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.bioJava;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.bioJava.SimpleSequenceIterator;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.LocatedSequenceAnnotation;
import de.jstacs.data.sequences.annotation.LocatedSequenceAnnotationWithLength;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import de.jstacs.results.SimpleResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.NameTokenization;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojavax.Namespace;
import org.biojavax.SimpleNamespace;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.RichSequenceBuilder;
import org.biojavax.bio.seq.io.RichSequenceBuilderFactory;
import org.biojavax.ontology.SimpleComparableTerm;

public class BioJavaAdapter {
    private static final Result[] EMPTY_RESULT_ARRAY = new Result[0];
    private static final String ANNOTATION_ID = "BJRSA";

    public static DataSet sequenceIteratorToDataSet(SequenceIterator it, FeatureFilter filter) throws Exception {
        LinkedList<Sequence> parsed = new LinkedList<Sequence>();
        org.biojava.bio.seq.Sequence current = it.nextSequence();
        Alphabet bioAbc = current.getAlphabet();
        List l = bioAbc.getAlphabets();
        de.jstacs.data.alphabets.Alphabet[] abc = new de.jstacs.data.alphabets.Alphabet[l.size()];
        for (int i = 0; i < abc.length; ++i) {
            Alphabet abcCurrent = (Alphabet)l.get(i);
            if (abcCurrent.getAlphabets().size() == 1) {
                if (abcCurrent.getName().equals("DNA")) {
                    abc[i] = DNAAlphabet.SINGLETON;
                    continue;
                }
                if (abcCurrent instanceof FiniteAlphabet) {
                    FiniteAlphabet finAbc = (FiniteAlphabet)bioAbc;
                    SymbolTokenization t = finAbc.getTokenization("default");
                    Iterator symIt = finAbc.iterator();
                    LinkedList<String> sym = new LinkedList<String>();
                    while (symIt.hasNext()) {
                        Symbol s = (Symbol)symIt.next();
                        sym.add(t.tokenizeSymbol(s));
                    }
                    abc[i] = new DiscreteAlphabet(true, sym.toArray(new String[0]));
                    continue;
                }
                throw new Exception("not finite");
            }
            throw new Exception("size > 1");
        }
        AlphabetContainer con = abc.length == 1 && abc[0] == DNAAlphabet.SINGLETON ? DNAAlphabetContainer.SINGLETON : new AlphabetContainer(abc);
        SequenceAnnotation[] empty = new SequenceAnnotation[]{};
        LinkedList<SequenceAnnotation> annotations = new LinkedList<SequenceAnnotation>();
        while (true) {
            annotations.clear();
            if (current instanceof RichSequence) {
                RichSequence rseq = (RichSequence)current;
                annotations.add(BioJavaAdapter.getRichSequenceAnnotation(rseq));
            }
            Object features = null;
            features = filter == null ? current : current.filter(filter);
            if (features.countFeatures() > 0) {
                Iterator itFeat = features.features();
                while (itFeat.hasNext()) {
                    annotations.add(BioJavaAdapter.featuresToAnnotation((Feature)itFeat.next()));
                }
            }
            SequenceAnnotation[] annota = null;
            if (annotations.size() > 0) {
                annota = annotations.toArray(empty);
            }
            parsed.add(Sequence.create(con, annota, current.seqString(), con.getDelim()));
            if (!it.hasNext()) break;
            current = it.nextSequence();
        }
        return new DataSet("", parsed.toArray(new Sequence[0]));
    }

    private static SequenceAnnotation getRichSequenceAnnotation(RichSequence rseq) {
        LinkedList<SimpleResult> results = new LinkedList<SimpleResult>();
        String temp = rseq.getDescription();
        if (temp != null) {
            results.add(new CategoricalResult("Description", "The description of the sequence", temp));
        }
        if ((temp = rseq.getAccession()) != null) {
            results.add(new CategoricalResult("Accession", "The accession of the sequence", temp));
        }
        if ((temp = rseq.getName()) != null) {
            results.add(new CategoricalResult("Name", "The name of the sequence", temp));
        }
        if ((temp = rseq.getIdentifier()) != null) {
            results.add(new CategoricalResult("ID", "The identifier of the sequence", temp));
        }
        int vers = rseq.getVersion();
        results.add(new NumericalResult("Version", "The version of the sequence", vers));
        return new SequenceAnnotation("BioJava RichSequence Annotation", ANNOTATION_ID, results);
    }

    private static SequenceAnnotation featuresToAnnotation(Feature feature) {
        org.biojava.bio.seq.Sequence fseq;
        LinkedList<SequenceAnnotation> subAnnot = new LinkedList<SequenceAnnotation>();
        if (feature.countFeatures() > 0) {
            Iterator it = feature.features();
            while (it.hasNext()) {
                subAnnot.add(BioJavaAdapter.featuresToAnnotation((Feature)it.next()));
            }
        }
        String id = null;
        LinkedList<CategoricalResult> results = new LinkedList<CategoricalResult>();
        Annotation ann = feature.getAnnotation();
        for (Map.Entry en : ann.asMap().entrySet()) {
            if (en.getKey() instanceof SimpleComparableTerm) {
                if (((SimpleComparableTerm)en.getKey()).getName().equalsIgnoreCase("identifier")) {
                    id = en.getValue().toString();
                    continue;
                }
                results.add(new CategoricalResult(((SimpleComparableTerm)en.getKey()).getName(), ((SimpleComparableTerm)en.getKey()).getDescription(), en.getValue().toString()));
                continue;
            }
            if (en.getKey().toString().equalsIgnoreCase("identifier")) {
                id = en.getValue().toString();
                continue;
            }
            results.add(new CategoricalResult(en.getKey().toString(), "", en.getValue().toString()));
        }
        SequenceAnnotation[] subs = null;
        if (subAnnot.size() > 0) {
            subs = subAnnot.toArray(new SequenceAnnotation[0]);
        }
        Location loc = feature.getLocation();
        String type = feature.getType();
        if (id == null) {
            id = feature.getType() + "_[" + feature.getLocation().toString() + "]";
        }
        if ((fseq = feature.getSequence()) instanceof RichSequence) {
            results.add(new CategoricalResult("Accession", "Accession", ((RichSequence)fseq).getAccession()));
        }
        if (loc == Location.empty) {
            return new SequenceAnnotation(type, id, subs, results.toArray(EMPTY_RESULT_ARRAY));
        }
        if (loc.getMin() == loc.getMax()) {
            return new LocatedSequenceAnnotation(loc.getMin() - 1, type, id, subs, results.toArray(EMPTY_RESULT_ARRAY));
        }
        if (loc.isContiguous()) {
            return new LocatedSequenceAnnotationWithLength(loc.getMin() - 1, loc.getMax() - loc.getMin() + 1, type, id, subs, results.toArray(EMPTY_RESULT_ARRAY));
        }
        Iterator subLocs = loc.blockIterator();
        LinkedList<SequenceAnnotation> subLocAnnots = new LinkedList<SequenceAnnotation>();
        int i = 0;
        while (subLocs.hasNext()) {
            Location subLoc = (Location)subLocs.next();
            if (subLoc.getMin() == subLoc.getMax()) {
                subLocAnnots.add(new LocatedSequenceAnnotation(subLoc.getMin() - 1, feature.getType(), "Sub location " + (i + 1), new Result[0]));
            } else {
                subLocAnnots.add(new LocatedSequenceAnnotationWithLength(subLoc.getMin() - 1, subLoc.getMax() - subLoc.getMin() + 1, feature.getType(), "Sub location " + (i + 1), new Result[0]));
            }
            ++i;
        }
        subLocAnnots.addAll(0, subAnnot);
        return new LocatedSequenceAnnotationWithLength(loc.getMin() - 1, loc.getMax() - loc.getMin() + 1, type, id, subLocAnnots.toArray(new SequenceAnnotation[0]), new Result[0]);
    }

    public static SequenceIterator dataSetToSequenceIterator(DataSet sample, boolean flat) throws WrongAlphabetException, BioException {
        LinkedList<RichSequence> bjSeqs = new LinkedList<RichSequence>();
        AlphabetContainer cont = sample.getAlphabetContainer();
        if (!cont.isSimple() || !cont.isDiscrete()) {
            throw new WrongAlphabetException("Only simple and discrete alphabets can be used");
        }
        FiniteAlphabet bjAlph = null;
        if (cont.isSimple()) {
            DiscreteAlphabet alph = (DiscreteAlphabet)cont.getAlphabetAt(0);
            if (alph instanceof DNAAlphabet) {
                bjAlph = DNATools.getDNA();
            } else {
                HashSet<AtomicSymbol> symbols = new HashSet<AtomicSymbol>();
                for (int i = 0; i < (int)alph.length(); ++i) {
                    symbols.add(AlphabetManager.createSymbol((String)alph.getSymbolAt(i)));
                }
                bjAlph = new SimpleAlphabet(symbols, "discrete");
                AlphabetManager.registerAlphabet((String)bjAlph.getName(), (Alphabet)bjAlph);
                ((SimpleAlphabet)bjAlph).putTokenization("default", (SymbolTokenization)new WorkingWordTokenization(bjAlph, !cont.ignoresCase(), cont.getDelim()));
            }
        } else {
            LinkedList<FiniteAlphabet> alphabets = new LinkedList<FiniteAlphabet>();
            for (int i = 0; i < cont.getPossibleLength(); ++i) {
                DiscreteAlphabet alph = (DiscreteAlphabet)cont.getAlphabetAt(i);
                FiniteAlphabet tempAlph = null;
                if (alph instanceof DNAAlphabet) {
                    tempAlph = DNATools.getDNA();
                } else {
                    HashSet<AtomicSymbol> symbols = new HashSet<AtomicSymbol>();
                    for (int j = 0; j < (int)alph.length(); ++j) {
                        symbols.add(AlphabetManager.createSymbol((String)alph.getSymbolAt(j)));
                    }
                    tempAlph = new SimpleAlphabet(symbols);
                }
                alphabets.add(tempAlph);
            }
        }
        int numSeqs = sample.getNumberOfElements();
        for (int i = 0; i < numSeqs; ++i) {
            Sequence seq = sample.getElementAt(i);
            RichSequence bjSeq = BioJavaAdapter.getSequence(bjAlph, cont, seq, "Sequence_" + (i + 1));
            SequenceAnnotation[] ann = seq.getAnnotation();
            if (ann != null) {
                for (int a = 0; a < ann.length; ++a) {
                    if (ann[a].getIdentifier().equals(ANNOTATION_ID)) continue;
                    BioJavaAdapter.annotationToFeatures(ann[a], (FeatureHolder)bjSeq, seq, flat);
                }
            }
            bjSeqs.add(bjSeq);
        }
        return new SimpleSequenceIterator(bjSeqs.toArray(new org.biojava.bio.seq.Sequence[0]));
    }

    private static RichSequence getSequence(FiniteAlphabet bjAlph, AlphabetContainer cont, Sequence seq, String defaultName) throws BioException {
        SimpleSymbolList ssl = new SimpleSymbolList(bjAlph.getTokenization("default"), seq.toString());
        Symbol[] symbols = ssl.toList().toArray(new Symbol[0]);
        RichSequenceBuilder builder = (RichSequenceBuilder)RichSequenceBuilderFactory.FACTORY.makeSequenceBuilder();
        builder.startSequence();
        builder.addSymbols((Alphabet)bjAlph, symbols, 0, symbols.length);
        boolean setName = false;
        boolean setAccession = false;
        SequenceAnnotation[] ann = seq.getAnnotation();
        if (ann != null) {
            int idx = -1;
            for (int i = 0; i < ann.length; ++i) {
                if (!ann[i].getIdentifier().equals(ANNOTATION_ID)) continue;
                idx = i;
                break;
            }
            if (idx > -1) {
                Result[] res = ann[idx].getResults();
                for (int i = 0; i < res.length; ++i) {
                    if (res[i].getName().equals("Description")) {
                        builder.setDescription(res[i].getValue().toString());
                        continue;
                    }
                    if (res[i].getName().equals("Accession")) {
                        builder.setAccession(res[i].getValue().toString());
                        setAccession = true;
                        continue;
                    }
                    if (res[i].getName().equals("Name")) {
                        builder.setName(res[i].getValue().toString());
                        setName = true;
                        continue;
                    }
                    if (res[i].getName().equals("ID")) {
                        builder.setIdentifier(res[i].getValue().toString());
                        continue;
                    }
                    if (!res[i].equals("Version")) continue;
                    builder.setVersion(Integer.parseInt(res[i].getValue().toString()));
                }
            }
        }
        if (!setName) {
            builder.setName(defaultName);
        }
        if (!setAccession) {
            builder.setAccession(defaultName);
        }
        builder.setNamespace((Namespace)new SimpleNamespace("default"));
        builder.endSequence();
        return builder.makeRichSequence();
    }

    private static void annotationToFeatures(SequenceAnnotation annotation, FeatureHolder holder, Sequence seq, boolean flat) throws BioException {
        StrandedFeature.Template templ = null;
        if (annotation instanceof StrandedLocatedSequenceAnnotationWithLength) {
            templ = new StrandedFeature.Template();
            StrandedFeature.Strand strand = templ.strand = ((StrandedLocatedSequenceAnnotationWithLength)annotation).getStrandedness().equals((Object)StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD) ? StrandedFeature.POSITIVE : StrandedFeature.NEGATIVE;
        }
        if (annotation instanceof LocatedSequenceAnnotationWithLength) {
            templ = new Feature.Template();
            templ.location = new RangeLocation(((LocatedSequenceAnnotation)annotation).getPosition() + 1, ((LocatedSequenceAnnotationWithLength)annotation).getEnd());
        } else if (annotation instanceof LocatedSequenceAnnotation) {
            templ = new Feature.Template();
            templ.location = new PointLocation(((LocatedSequenceAnnotation)annotation).getPosition() + 1);
        } else {
            templ = new Feature.Template();
            templ.location = new RangeLocation(1, seq.getLength());
        }
        String t = annotation.getType();
        t = t.replace(' ', '_');
        if (t.length() > 15) {
            t = t.substring(0, 15);
        }
        templ.type = t;
        templ.source = "BioJavaAdapter: " + annotation.getType() + ", " + annotation.getIdentifier();
        Result[] res = annotation.getAnnotations();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("identifier", annotation.getIdentifier());
        if (res != null) {
            for (int i = 0; i < res.length; ++i) {
                map.put(res[i].getName(), res[i].getValue().toString());
            }
        }
        templ.annotation = new SimpleAnnotation(map);
        Feature f = holder.createFeature((Feature.Template)templ);
        SequenceAnnotation[] annotations = annotation.getSubAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                if (flat) {
                    BioJavaAdapter.annotationToFeatures(annotations[i], holder, seq, flat);
                    continue;
                }
                BioJavaAdapter.annotationToFeatures(annotations[i], (FeatureHolder)f, seq, flat);
            }
        }
    }

    private static class WorkingWordTokenization
    extends NameTokenization {
        private String delim;

        private WorkingWordTokenization(FiniteAlphabet fab, boolean caseSensitive, String delim) {
            super(fab, caseSensitive);
            this.delim = delim;
        }

        private WorkingWordTokenization(FiniteAlphabet fab, String delim) {
            super(fab);
            this.delim = delim;
        }

        public String tokenizeSymbolList(SymbolList sl) throws IllegalSymbolException, IllegalAlphabetException {
            if (sl.getAlphabet() != this.getAlphabet()) {
                throw new IllegalAlphabetException("Alphabet " + sl.getAlphabet().getName() + " does not match " + this.getAlphabet().getName());
            }
            StringBuffer sb = new StringBuffer();
            Iterator i = sl.iterator();
            while (i.hasNext()) {
                Symbol sym = (Symbol)i.next();
                sb.append(this.tokenizeSymbol(sym));
                if (!i.hasNext()) continue;
                sb.append(this.delim);
            }
            return sb.substring(0);
        }

        protected List splitString(String seq) throws IllegalSymbolException {
            String[] parts = seq.split(this.delim);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].length() <= 0) continue;
                list.add(parts[i]);
            }
            return list;
        }
    }
}

