/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete;

import de.jstacs.algorithms.graphs.UnionFind;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.Constraint;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.CombinationIterator;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.InhCondProb;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.MEMConstraint;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class ConstraintManager {
    private ConstraintManager() {
    }

    public static void computeFreqs(double ess, Constraint ... constr) throws IllegalArgumentException {
        if (ess < 0.0) {
            throw new IllegalArgumentException("The ess has to be non-negative.");
        }
        for (int counter1 = 0; counter1 < constr.length; ++counter1) {
            constr[counter1].estimate(ess);
        }
    }

    public static double countInhomogeneous(AlphabetContainer alphabets, int length, DataSet data, double[] weights, boolean reset, Constraint ... constr) throws WrongAlphabetException, IllegalArgumentException {
        int counter1;
        int d = data.getNumberOfElements();
        double all = 0.0;
        if (weights != null && d != weights.length) {
            throw new IllegalArgumentException("The weights are not suitable for the data (wrong dimension).");
        }
        if (!alphabets.checkConsistency(data.getAlphabetContainer())) {
            throw new WrongAlphabetException("The alphabets of the model and the sample are not suitable.");
        }
        if (data.getElementLength() != length) {
            throw new IllegalArgumentException("The sequence length of the model and the sample are not suitable.");
        }
        if (reset) {
            for (counter1 = 0; counter1 < constr.length; ++counter1) {
                constr[counter1].reset();
            }
        }
        DataSet.ElementEnumerator ei = new DataSet.ElementEnumerator(data);
        if (weights == null) {
            all = d;
            for (counter1 = 0; counter1 < d; ++counter1) {
                Sequence seq = ei.nextElement();
                for (int counter2 = 0; counter2 < constr.length; ++counter2) {
                    constr[counter2].add(seq, 0, 1.0);
                }
            }
        } else {
            for (counter1 = 0; counter1 < d; ++counter1) {
                Sequence seq = ei.nextElement();
                if (weights[counter1] > 0.0) {
                    all += weights[counter1];
                    for (int counter2 = 0; counter2 < constr.length; ++counter2) {
                        constr[counter2].add(seq, 0, weights[counter1]);
                    }
                    continue;
                }
                if (!(weights[counter1] < 0.0)) continue;
                throw new IllegalArgumentException("All weights have to be non-negative. Violated in position " + counter1 + ".");
            }
        }
        return all;
    }

    public static void drawFreqs(double ess, InhCondProb ... constr) throws IllegalArgumentException {
        if (ess < 0.0) {
            throw new IllegalArgumentException("The ess has to be non-negative.");
        }
        for (int counter1 = 0; counter1 < constr.length; ++counter1) {
            constr[counter1].drawParameters(ess);
        }
    }

    public static ArrayList<int[]> extract(int length, String encoded) throws IllegalArgumentException {
        int i;
        StringTokenizer st = new StringTokenizer(encoded, ";");
        ArrayList<int[]> list = new ArrayList<int[]>();
        boolean[][] constrAbbrev = new boolean[length + 1][];
        constrAbbrev[0] = null;
        constrAbbrev[1] = new boolean[]{false};
        for (i = 2; i < constrAbbrev.length; ++i) {
            constrAbbrev[i] = new boolean[length - i + 1];
            Arrays.fill(constrAbbrev[i], false);
        }
        while (st.hasMoreTokens()) {
            int m;
            String current = st.nextToken().trim();
            int mp = current.indexOf("m");
            int sp = current.indexOf("s");
            if (mp >= 0 && sp > 0) {
                m = Integer.parseInt(current.substring(mp + 1, sp));
                if (m > length) {
                    throw new IllegalArgumentException("The marginal order of " + m + " is not possible for length " + length);
                }
                String help = current.substring(sp + 1);
                if (help.equals("x")) {
                    for (i = 0; i < constrAbbrev[m].length; ++i) {
                        constrAbbrev[m][i] = true;
                    }
                    continue;
                }
                constrAbbrev[m][Integer.parseInt((String)current.substring((int)(sp + 1)))] = true;
                continue;
            }
            m = 0;
            StringTokenizer simple = new StringTokenizer(current, ",");
            int[] pos = new int[simple.countTokens()];
            mp = 0;
            while (simple.hasMoreTokens()) {
                i = Integer.parseInt(simple.nextToken());
                if (0 <= i && i < length) {
                    pos[mp++] = i;
                    continue;
                }
                throw new IllegalArgumentException("Could not correctly parse \"" + current + "\".");
            }
            list.add(ConstraintManager.getSortedUnique(pos));
        }
        ConstraintManager.add(constrAbbrev, list);
        return list;
    }

    private static String unfold(String constraint, int startpos, int endpos) {
        ArrayList<int[]> list = ConstraintManager.extract(endpos - startpos, constraint);
        StringBuffer erg = new StringBuffer(list.size() * 10);
        for (int i = 0; i < list.size(); ++i) {
            int[] current = list.get(i);
            erg.append(current[0] + startpos);
            for (int j = 1; j < current.length; ++j) {
                erg.append("," + (current[j] + startpos));
            }
            erg.append(";");
        }
        return erg.toString();
    }

    public static double getEntropy(Constraint c) {
        int i;
        double h = 0.0;
        double[] temps = new double[c.getNumberOfSpecificConstraints()];
        for (i = 0; i < temps.length; ++i) {
            if (!(c.getFreq(i) > 0.0)) continue;
            temps[i] = c.getFreq(i) * Math.log(c.getFreq(i));
        }
        Arrays.sort(temps);
        for (i = 0; i < temps.length; ++i) {
            h -= temps[i];
        }
        return h;
    }

    public static double getLogGammaSum(Constraint c, double ess) {
        int i = 0;
        int l = c.getNumberOfSpecificConstraints();
        double pc = ess / (double)l;
        double sum = (double)l * Gamma.logOfGamma((double)pc);
        while (i < l) {
            sum -= Gamma.logOfGamma((double)(c.getCount(i++) + pc));
        }
        return sum;
    }

    public static void reduce(AbstractList<int[]> list) {
        block0: for (int counter1 = 0; counter1 < list.size(); ++counter1) {
            int[] helpPos = list.get(counter1);
            int counter2 = counter1 + 1;
            while (counter2 < list.size()) {
                int[] current = list.get(counter2);
                if (helpPos.length < current.length) {
                    if (ConstraintManager.isSubset(helpPos, current)) {
                        list.remove(counter1);
                        --counter1;
                        continue block0;
                    }
                    ++counter2;
                    continue;
                }
                if (ConstraintManager.isSubset(current, helpPos)) {
                    list.remove(counter2);
                    continue;
                }
                ++counter2;
            }
        }
    }

    private static void add(boolean[][] constrAbbrev, ArrayList<int[]> list) {
        int distance;
        int counter2;
        int length = constrAbbrev.length - 1;
        int max = 0;
        int counter1 = 1;
        for (counter2 = 1; counter2 <= length; ++counter2) {
            for (distance = 0; distance < constrAbbrev[counter2].length; ++distance) {
                if (!constrAbbrev[counter2][distance]) continue;
                max = counter2;
            }
        }
        CombinationIterator c = new CombinationIterator(length, max);
        while (counter1 <= max) {
            for (counter2 = 0; counter2 < constrAbbrev[counter1].length && !constrAbbrev[counter1][counter2]; ++counter2) {
            }
            if (counter2 != constrAbbrev[counter1].length) {
                c.setCurrentLength(counter1);
                do {
                    int[] current = c.getCombination();
                    distance = 1 - counter1;
                    counter2 = 1;
                    while (counter2 < counter1) {
                        distance += current[counter2] - current[counter2++ - 1];
                    }
                    if (!constrAbbrev[counter1][distance]) continue;
                    list.add(current);
                } while (c.next());
            }
            ++counter1;
        }
    }

    private static int[] getIntersection(int[] array1, int[] array2) {
        int counter1 = 0;
        int counter2 = 0;
        int length = 0;
        int[] zerg = new int[Math.min(array1.length, array2.length)];
        while (counter1 < array1.length && counter2 < array2.length) {
            while (counter1 < array1.length && array1[counter1] < array2[counter2]) {
                ++counter1;
            }
            if (counter1 >= array1.length) continue;
            while (counter2 < array2.length && array1[counter1] > array2[counter2]) {
                ++counter2;
            }
            if (counter2 >= array2.length || array1[counter1] != array2[counter2]) continue;
            zerg[length++] = array1[counter1++];
            ++counter2;
        }
        int[] erg = new int[length];
        System.arraycopy(zerg, 0, erg, 0, length);
        return erg;
    }

    private static int[] getSortedUnique(int[] pos) throws IllegalArgumentException {
        int i;
        int[] sorted = new int[pos.length];
        System.arraycopy(pos, 0, sorted, 0, pos.length);
        Arrays.sort(sorted);
        for (i = 1; i < pos.length && sorted[i - 1] < sorted[i]; ++i) {
        }
        if (i < sorted.length) {
            throw new IllegalArgumentException("The position array is not unique.");
        }
        return sorted;
    }

    private static boolean isSubset(int[] candidateSubset, int[] set) {
        int counter1 = 0;
        int counter2 = 0;
        while (counter2 < candidateSubset.length) {
            while (counter1 < set.length && set[counter1] < candidateSubset[counter2]) {
                ++counter1;
            }
            if (counter1 == set.length || set[counter1] > candidateSubset[counter2]) {
                return false;
            }
            ++counter2;
            ++counter1;
        }
        return true;
    }

    private static ArrayList[] split(AbstractList<int[]> list, int length, int[][] indices) {
        int counter1;
        ArrayList[] constr = new ArrayList[indices.length];
        int[] component = new int[length];
        for (counter1 = 0; counter1 < indices.length; ++counter1) {
            constr[counter1] = new ArrayList();
            for (int counter2 = 0; counter2 < indices[counter1].length; ++counter2) {
                component[indices[counter1][counter2]] = counter1;
            }
        }
        for (counter1 = 0; counter1 < list.size(); ++counter1) {
            int[] current = list.get(counter1);
            constr[component[current[0]]].add(current);
        }
        return constr;
    }

    private static int[][] unionFind(AbstractList<int[]> list, int[] alphabetLength, int leafOutIndex) {
        UnionFind uf = new UnionFind(alphabetLength.length);
        for (int counter1 = 0; counter1 < list.size(); ++counter1) {
            if (counter1 == leafOutIndex) continue;
            int[] current = list.get(counter1);
            for (int counter2 = 1; counter2 < current.length; ++counter2) {
                uf.union(current[0], current[counter2]);
            }
        }
        return uf.getComponents();
    }

    public static MEMConstraint[] createConstraints(AbstractList<int[]> list, int[] alphabetLength, int[] indices) {
        if (alphabetLength.length == indices.length) {
            return ConstraintManager.createConstraints(list, alphabetLength);
        }
        int[] corrected = new int[alphabetLength.length];
        int i = 0;
        while (i < indices.length) {
            corrected[indices[i]] = i++;
        }
        MEMConstraint[] constr = new MEMConstraint[list.size()];
        for (i = 0; i < constr.length; ++i) {
            int[] pos = list.get(i);
            int[] corPos = new int[pos.length];
            for (int j = 0; j < pos.length; ++j) {
                corPos[j] = corrected[pos[j]];
            }
            constr[i] = new MEMConstraint(pos, alphabetLength, corPos);
        }
        return constr;
    }

    public static MEMConstraint[] createConstraints(AbstractList<int[]> list, int[] alphabetLength) {
        MEMConstraint[] constr = new MEMConstraint[list.size()];
        for (int i = 0; i < constr.length; ++i) {
            constr[i] = new MEMConstraint(list.get(i), alphabetLength);
        }
        return constr;
    }
}

