/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.Constraint;

public abstract class InhConstraint
extends Constraint
implements Cloneable {
    protected int[] offset;

    private static int product(int[] selected, int[] values) {
        int erg = 1;
        int i = 0;
        while (i < selected.length) {
            erg *= values[selected[i++]];
        }
        return erg;
    }

    protected InhConstraint(int[] pos, int[] alphabetLength) {
        super(pos, InhConstraint.product(pos, alphabetLength));
        int i = pos.length;
        this.offset = new int[i--];
        this.offset[i--] = 1;
        while (i >= 0) {
            this.offset[i] = this.offset[i + 1] * alphabetLength[pos[i + 1]];
            --i;
        }
    }

    protected InhConstraint(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    protected void extractAdditionalInfo(StringBuffer xml) throws NonParsableException {
        this.offset = XMLParser.extractObjectForTags(xml, "offset", int[].class);
    }

    @Override
    public InhConstraint clone() throws CloneNotSupportedException {
        InhConstraint clone = (InhConstraint)super.clone();
        clone.offset = (int[])this.offset.clone();
        return clone;
    }

    @Override
    public int satisfiesSpecificConstraint(Sequence s, int start) {
        int erg = 0;
        for (int counter = 0; counter < this.usedPositions.length; ++counter) {
            erg += this.offset[counter] * s.discreteVal(start + this.usedPositions[counter]);
        }
        return erg;
    }

    @Override
    protected void appendAdditionalInfo(StringBuffer xml) {
        XMLParser.appendObjectWithTags(xml, this.offset, "offset");
    }

    @Override
    public String getDescription(AlphabetContainer con, int i) {
        String res = null;
        for (int j = 0; j < this.offset.length; ++j) {
            DiscreteAlphabet d = (DiscreteAlphabet)con.getAlphabetAt(this.usedPositions[j]);
            String s = "X_" + this.usedPositions[j] + "=" + d.getSymbolAt(i / this.offset[j]);
            res = res == null ? s : s + ", " + res;
            i %= this.offset[j];
        }
        return "P(" + res + ")";
    }
}

