/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous;

import de.jstacs.algorithms.graphs.tensor.SymmetricTensor;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.StructureLearner;
import de.jstacs.utils.REnvironment;
import java.awt.image.BufferedImage;

public class TwoPointEvaluater {
    private static final byte order = 1;

    public static double[][] getMIInBits(DataSet s, double[] weights) throws IllegalArgumentException {
        int i;
        int l = s.getElementLength();
        int[] j = new int[1];
        StructureLearner sl = new StructureLearner(s.getAlphabetContainer(), l);
        SymmetricTensor tensor = null;
        try {
            tensor = sl.getTensor(s, weights, (byte)1, StructureLearner.LearningType.ML_OR_MAP);
        }
        catch (WrongAlphabetException w) {
            throw new IllegalArgumentException();
        }
        double sum = 0.0;
        if (weights != null) {
            for (i = 0; i < weights.length; ++i) {
                sum += weights[i];
            }
        } else {
            sum = s.getNumberOfElements();
        }
        double[][] mi = new double[l][l];
        while (i < l) {
            j[0] = i + 1;
            while (j[0] < l) {
                double d = tensor.getValue((byte)1, i, j) / sum;
                mi[j[0]][i] = d;
                mi[i][j[0]] = d;
                j[0] = j[0] + 1;
            }
            ++i;
        }
        return mi;
    }

    public static BufferedImage getImage(double[][] mi, REnvironment r) throws Exception {
        r.createMatrix("mi", mi);
        r.eval("mini = min( mi ); maxi = max( mi );");
        r.eval("lim = c(mini, maxi);c = rev( gray((1:1000)/1000) ); l=1:dim(mi)[1];");
        r.eval("skala = seq( mini, maxi, length = 1000 ); m = matrix( skala, ncol = 1000 );");
        BufferedImage b = r.plot("layout( matrix( c(1,2), ncol=2 ), width=c(12,3) ); par( las=1 );image( l, l, mi, xlab = \"position\",  ylab = \"position\", zlim = lim, col = c, main = \"mutual information\" );par( mar = c(5, 0, 4, 6) + 0.1);image( 1, skala, m, col = c, xlab = \"\", ylab = \"\", main = \"scale\", axes = FALSE );axis( 4, seq(mini,maxi,length=5), round( seq(mini,maxi,length=5), digits = 4 ) )", 1080.0, 864.0);
        return b;
    }

    public static double getMax(double[][] mi) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < mi.length; ++i) {
            for (int j = 0; j < mi[i].length; ++j) {
                if (!(mi[i][j] > max)) continue;
                max = mi[i][j];
            }
        }
        return max;
    }
}

