/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.GroupIterator;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomIterator
implements Iterator<Atom> {
    Structure structure;
    Group group;
    int current_atom_pos;
    GroupIterator groupiter;

    public AtomIterator(Structure struct) {
        this.structure = struct;
        this.current_atom_pos = -1;
        this.groupiter = new GroupIterator(this.structure);
        this.group = this.groupiter.hasNext() ? this.groupiter.next() : null;
    }

    public Chain getCurrentChain() {
        return this.groupiter.getCurrentChain();
    }

    public int getCurrentModel() {
        return this.groupiter.getCurrentModel();
    }

    public AtomIterator(Group g) {
        this.structure = null;
        this.group = g;
        this.current_atom_pos = -1;
        this.groupiter = null;
    }

    @Override
    public boolean hasNext() {
        if (this.group == null) {
            return false;
        }
        if (this.current_atom_pos < this.group.size() - 1) {
            return true;
        }
        if (this.groupiter != null) {
            GroupIterator tmp = (GroupIterator)this.groupiter.clone();
            while (tmp.hasNext()) {
                Group tmpg = tmp.next();
                if (tmpg.size() <= 0) continue;
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    @Override
    public Atom next() throws NoSuchElementException {
        Atom a;
        ++this.current_atom_pos;
        if (this.current_atom_pos >= this.group.size()) {
            if (this.groupiter == null) {
                throw new NoSuchElementException("no more atoms found in group!");
            }
            if (this.groupiter.hasNext()) {
                this.group = this.groupiter.next();
                this.current_atom_pos = -1;
                return this.next();
            }
            throw new NoSuchElementException("no more atoms found in structure!");
        }
        try {
            a = this.group.getAtom(this.current_atom_pos);
        }
        catch (StructureException e) {
            System.err.println("current_atom_pos " + this.current_atom_pos + " group " + this.group + "size:" + this.group.size());
            e.printStackTrace();
            throw new NoSuchElementException("error wile trying to retrieve atom");
        }
        return a;
    }

    @Override
    public void remove() {
    }
}

