/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.TwoClassAbstractPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import java.util.ArrayList;

public class PRCurve
extends TwoClassAbstractPerformanceMeasure {
    public static final String NAME = "Precision-Recall curve";

    public PRCurve() {
    }

    public PRCurve(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ResultSet compute(double[] sortedScoresClass0, double[] sortedScoresClass1) {
        boolean unique;
        int j;
        ArrayList<double[]> list = null;
        if (!(this instanceof NumericalPerformanceMeasure)) {
            list = new ArrayList<double[]>();
        }
        int i_old = 0;
        int j_old = 0;
        int i = 0;
        int d = sortedScoresClass1.length;
        int m = sortedScoresClass0.length;
        double erg = 0.0;
        double help1 = 0.0;
        double help2 = 0.0;
        for (j = 0; j < d && sortedScoresClass0[i] > sortedScoresClass1[j]; ++j) {
        }
        double[] p = new double[]{(double)(m - i) / (double)m, (double)(m - i) / (double)(m - i + d - j)};
        if (list != null) {
            list.add((double[])p.clone());
        }
        boolean fromMotif = false;
        if (j < d && sortedScoresClass0[i] == sortedScoresClass1[j]) {
            unique = false;
        } else {
            unique = true;
            fromMotif = true;
        }
        while (i < m && j < d) {
            i_old = i;
            j_old = j;
            if (unique) {
                if (fromMotif) {
                    while (i < m && sortedScoresClass1[j] > sortedScoresClass0[i]) {
                        ++i;
                    }
                } else {
                    while (j < d && sortedScoresClass0[i] > sortedScoresClass1[j]) {
                        ++j;
                    }
                }
            } else {
                while (i + 1 < m && sortedScoresClass0[i] == sortedScoresClass0[i + 1]) {
                    ++i;
                }
                while (j + 1 < d && sortedScoresClass1[j] == sortedScoresClass1[j + 1]) {
                    ++j;
                }
                ++i;
                ++j;
            }
            if (i == i_old) {
                p[1] = (double)(m - i) / (double)(m - i + d - j);
                if (list != null) {
                    list.add((double[])p.clone());
                }
            } else if (i < m || j < d) {
                double propTerm = (double)(j - j_old) / (double)(i - i_old);
                ++i_old;
                double helpJ = (double)j_old + propTerm;
                while (i_old <= i) {
                    help1 = (double)(m - i_old) / (double)m;
                    help2 = (double)(m - i_old) / ((double)(m - i_old + d) - helpJ);
                    helpJ += propTerm;
                    erg += (p[1] + help2) / 2.0 * (p[0] - help1);
                    p[0] = help1;
                    p[1] = help2;
                    if (list != null) {
                        list.add((double[])p.clone());
                    }
                    ++i_old;
                }
            } else {
                erg += p[1] * p[0];
                p[0] = 0.0;
                if (list != null) {
                    list.add((double[])p.clone());
                }
            }
            if (i >= m || j >= d) continue;
            if (sortedScoresClass0[i] == sortedScoresClass1[j]) {
                unique = false;
                continue;
            }
            unique = true;
            if (sortedScoresClass0[i] < sortedScoresClass1[j]) {
                fromMotif = true;
                continue;
            }
            fromMotif = false;
        }
        if (i < m) {
            help1 = 0.0;
            erg += p[1] * (p[0] - help1);
            p[0] = help1;
            if (list != null) {
                list.add((double[])p.clone());
            }
        }
        NumericalResult auc = new NumericalResult("AUC-PR", "Area under the " + this.getName(), erg);
        if (list == null) {
            return new NumericalResultSet(auc);
        }
        return new ResultSet(new Result[][]{{auc, new AbstractScoreBasedClassifier.DoubleTableResult(this.getName(), this.getName(), list)}});
    }
}

