/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;

public class ExpandableParameterSet
extends ParameterSet {
    protected ParameterSet template;
    protected String nameTemplate;
    protected String commentTemplate;
    private int count;
    private int initCount;

    public ExpandableParameterSet(ParameterSet template, String nameTemplate, String commentTemplate) throws CloneNotSupportedException {
        this(template, nameTemplate, commentTemplate, 1);
    }

    public ExpandableParameterSet(ParameterSet template, String nameTemplate, String commentTemplate, int initCount) throws CloneNotSupportedException {
        this.template = template;
        this.nameTemplate = nameTemplate;
        this.commentTemplate = commentTemplate;
        this.count = 0;
        this.initCount = initCount;
        for (int i = 0; i < initCount; ++i) {
            this.addParameterToSet();
        }
    }

    public ExpandableParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public ExpandableParameterSet(ParameterSet[] templateAndContent, String nameTemplate, String commentTemplate) {
        if (templateAndContent.length == 0) {
            throw new IllegalArgumentException("You must provide at least one ParameterSet.");
        }
        this.template = templateAndContent[0];
        this.nameTemplate = nameTemplate;
        this.commentTemplate = commentTemplate;
        if (this.notAllGivenParameterSetsAreOfTemplateType(templateAndContent)) {
            throw new IllegalArgumentException("At least one of the given ParameterSets is not of the specified template-Type");
        }
        for (int i = 0; i < templateAndContent.length; ++i) {
            this.parameters.add(new Parameter[]{new ParameterSetContainer(nameTemplate + " no. " + (i + 1), commentTemplate, templateAndContent[i])});
        }
        this.initCount = this.count = templateAndContent.length;
    }

    @Override
    public ExpandableParameterSet clone() throws CloneNotSupportedException {
        ExpandableParameterSet clone = (ExpandableParameterSet)super.clone();
        clone.template = this.template.clone();
        return clone;
    }

    public void addParameterToSet() throws CloneNotSupportedException {
        ParameterSetContainer simplePar = new ParameterSetContainer(this.nameTemplate + " no. " + ++this.count, this.commentTemplate, this.template.clone());
        this.parameters.add(new Parameter[]{simplePar});
    }

    public boolean replaceContentWith(ParameterSet[] paramSetArray) {
        if (this.notAllGivenParameterSetsAreOfTemplateType(paramSetArray)) {
            return false;
        }
        this.initParameterList(paramSetArray.length);
        for (int i = 0; i < paramSetArray.length; ++i) {
            this.parameters.add(new Parameter[]{new ParameterSetContainer(this.nameTemplate + " no. " + (i + 1), this.commentTemplate, paramSetArray[i])});
        }
        this.count = paramSetArray.length;
        return true;
    }

    private boolean notAllGivenParameterSetsAreOfTemplateType(ParameterSet[] temp) {
        Class<?> clazz = this.template.getClass();
        for (int i = 0; i < temp.length; ++i) {
            if (temp[i].getClass() == clazz) continue;
            return true;
        }
        return false;
    }

    public boolean parameterRemovable() {
        return this.count > 0;
    }

    public void removeParameterFromSet() {
        if (this.count > 0) {
            this.parameters.remove(this.parameters.size() - 1);
            --this.count;
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameters");
        XMLParser.appendObjectWithTags(buf, this.template, "template");
        XMLParser.appendObjectWithTags(buf, this.nameTemplate, "nameTemplate");
        XMLParser.appendObjectWithTags(buf, this.commentTemplate, "commentTemplate");
        XMLParser.appendObjectWithTags(buf, this.initCount, "initCount");
        XMLParser.addTags(buf, "expandableParameterSet");
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "expandableParameterSet");
        super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
        this.template = XMLParser.extractObjectForTags(representation, "template", ParameterSet.class);
        this.nameTemplate = XMLParser.extractObjectForTags(representation, "nameTemplate", String.class);
        this.commentTemplate = XMLParser.extractObjectForTags(representation, "commentTemplate", String.class);
        this.initCount = XMLParser.extractObjectForTags(representation, "initCount", Integer.TYPE);
    }

    @Override
    public void toGalaxy(String namePrefix, String configPrefix, int depth, StringBuffer descBuffer, StringBuffer configBuffer) throws Exception {
        namePrefix = namePrefix + "_" + this.nameTemplate.replaceAll("\\s", "_");
        for (int i = 0; i < this.getNumberOfParameters() - this.count; ++i) {
            ((GalaxyConvertible)((Object)this.getParameterAt(i))).toGalaxy(namePrefix + "_ps", configPrefix, depth + 1, descBuffer, configBuffer);
        }
        StringBuffer buf = new StringBuffer();
        StringBuffer buf2 = new StringBuffer();
        buf2.append("$len($" + configPrefix + namePrefix + ")");
        XMLParser.addTags(buf2, namePrefix + "_len");
        buf2.append("\n");
        buf2.append("#for $" + namePrefix + "_i, $" + namePrefix + "_run in enumerate($" + configPrefix + namePrefix + ")\n");
        this.template.toGalaxy(namePrefix, namePrefix + "_run.", depth + 1, buf, buf2);
        buf2.append("#end for");
        XMLParser.addTagsAndAttributes(buf, "repeat", "name=\"" + namePrefix + "\" title=\"" + this.nameTemplate + "\"");
        descBuffer.append(buf);
        configBuffer.append(buf2);
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
        int i;
        namePrefix = namePrefix + "_" + this.nameTemplate.replaceAll("\\s", "_");
        while (this.count > 0) {
            this.removeParameterFromSet();
        }
        for (int num = XMLParser.extractObjectForTags(command, new StringBuilder().append(namePrefix).append("_len").toString(), Integer.TYPE).intValue(); num > 0; --num) {
            this.addParameterToSet();
        }
        for (i = 0; i < this.getNumberOfParameters() - this.count; ++i) {
            ((GalaxyConvertible)((Object)this.getParameterAt(i))).fromGalaxy(namePrefix + "_ps", command);
        }
        while (i < this.getNumberOfParameters()) {
            ((GalaxyConvertible)((Object)this.getParameterAt(i))).fromGalaxy(namePrefix, command);
            ++i;
        }
    }
}

