/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.continuous;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.continuous.GaussianEmission;

public class PluginGaussianEmission
extends GaussianEmission {
    protected double meanValue;
    protected double standardDeviation;
    private static final String TAG = "GaussianEmission_NoRandomInit";

    public PluginGaussianEmission(double mean, double sd, double ess, double priorMu, double priorAlpha, double priorBeta) {
        super(new AlphabetContainer((Alphabet)new ContinuousAlphabet()), ess, priorMu, priorAlpha, priorBeta, false);
        this.meanValue = mean;
        this.standardDeviation = sd;
        this.setParameter(new double[]{this.meanValue, Math.log(1.0 / Math.pow(this.standardDeviation, 2.0))}, 0);
        this.precompute();
    }

    public PluginGaussianEmission(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public void initializeFunctionRandomly() {
        this.setParameter(new double[]{this.meanValue, Math.log(1.0 / Math.pow(this.standardDeviation, 2.0))}, 0);
        this.precompute();
    }

    @Override
    public String toString() {
        double[] parameters = new double[2];
        this.fillCurrentParameter(parameters);
        return "   - Mean = " + parameters[0] + "\t Sd = " + Math.pow(1.0 / Math.exp(parameters[1]), 0.5);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.appendObjectWithTags(buf, this.meanValue, "MeanValue");
        XMLParser.appendObjectWithTags(buf, this.standardDeviation, "StandardDeviation");
        XMLParser.addTags(buf, TAG);
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, TAG);
        this.meanValue = XMLParser.extractObjectForTags(xml, "MeanValue", Double.TYPE);
        this.standardDeviation = XMLParser.extractObjectForTags(xml, "StandardDeviation", Double.TYPE);
        super.fromXML(xml);
    }
}

