/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.biojava.utils.ClassTools;

public class Services {
    public static Set getImplementationNames(Class serviceIF) throws IOException {
        return Services.getImplementationNames(serviceIF, ClassTools.getClassLoader(Services.class));
    }

    public static Set getImplementationNames(Class serviceIF, ClassLoader loader) throws IOException {
        String serviceName = serviceIF.getName();
        Enumeration<URL> serviceFiles = loader.getResources("META-INF/services/" + serviceName);
        HashSet<String> names = new HashSet<String>();
        while (serviceFiles.hasMoreElements()) {
            String implName;
            URL serviceFile = serviceFiles.nextElement();
            BufferedReader serviceReader = new BufferedReader(new InputStreamReader(serviceFile.openStream()));
            while ((implName = serviceReader.readLine()) != null) {
                if (implName.length() <= 0) continue;
                names.add(implName);
            }
        }
        return Collections.unmodifiableSet(names);
    }
}

