/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers;

import de.jstacs.NotTrainedException;
import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasureParameterSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;

public class MappingClassifier
extends AbstractScoreBasedClassifier {
    private AbstractScoreBasedClassifier classifier;
    private int[][] classMapping;

    private static int getNum(int[] mapping) {
        HashSet<Integer> hash = new HashSet<Integer>();
        for (int i = 0; i < mapping.length; ++i) {
            if (hash.contains(mapping[i])) continue;
            hash.add(mapping[i]);
        }
        return hash.size();
    }

    public MappingClassifier(AbstractScoreBasedClassifier classifier, int ... mapping) throws CloneNotSupportedException {
        super(classifier.getAlphabetContainer(), classifier.getLength(), MappingClassifier.getNum(mapping));
        int i;
        if (mapping.length != classifier.getNumberOfClasses()) {
            throw new IllegalArgumentException("The length of the mapping is not correct.");
        }
        IntList[] il = new IntList[this.getNumberOfClasses()];
        for (i = 0; i < il.length; ++i) {
            il[i] = new IntList();
        }
        for (i = 0; i < mapping.length; ++i) {
            il[mapping[i]].add(i);
        }
        this.classMapping = new int[il.length][];
        for (i = 0; i < il.length; ++i) {
            if (il[i].length() == 0) {
                throw new IllegalArgumentException("Mapping to class " + i + " is empty");
            }
            this.classMapping[i] = il[i].toArray();
        }
        this.classifier = classifier.clone();
    }

    public MappingClassifier(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    protected void extractFurtherClassifierInfosFromXML(StringBuffer xml) throws NonParsableException {
        super.extractFurtherClassifierInfosFromXML(xml);
        this.classifier = XMLParser.extractObjectForTags(xml, "classifier", AbstractScoreBasedClassifier.class);
        this.classMapping = XMLParser.extractObjectForTags(xml, "mapping", int[][].class);
    }

    @Override
    protected StringBuffer getFurtherClassifierInfos() {
        StringBuffer xml = super.getFurtherClassifierInfos();
        XMLParser.appendObjectWithTags(xml, this.classifier, "classifier");
        XMLParser.appendObjectWithTags(xml, this.classMapping, "mapping");
        return xml;
    }

    @Override
    protected double getScore(Sequence seq, int i, boolean check) throws IllegalArgumentException, NotTrainedException, Exception {
        if (check) {
            this.check(seq);
        }
        double res = this.classifier.getScore(seq, this.classMapping[i][0], true);
        for (int idx = 1; idx < this.classMapping[i].length; ++idx) {
            res = Normalisation.getLogSum(res, this.classifier.getScore(seq, this.classMapping[i][1], false));
        }
        return res;
    }

    @Override
    public CategoricalResult[] getClassifierAnnotation() {
        return this.classifier.getClassifierAnnotation();
    }

    @Override
    public String getInstanceName() {
        return "MappingClassifier of " + this.classifier.getInstanceName();
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return this.classifier.getNumericalCharacteristics();
    }

    @Override
    protected String getXMLTag() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isInitialized() {
        return this.classifier.isInitialized();
    }

    @Override
    public void train(DataSet[] s, double[][] weights) throws Exception {
        this.classifier.train(s, weights);
    }

    @Override
    protected boolean getResults(LinkedList list, DataSet[] s, PerformanceMeasureParameterSet params, boolean exceptionIfNotComputeable) throws Exception {
        if (s.length == this.getNumberOfClasses()) {
            return super.getResults(list, s, params, exceptionIfNotComputeable);
        }
        return super.getResults(list, this.mapDataSet(s), params, exceptionIfNotComputeable);
    }

    public DataSet[] mapDataSet(DataSet[] s) {
        boolean[] in = new boolean[this.classifier.getNumberOfClasses()];
        DataSet[] mapped = new DataSet[this.classMapping.length];
        try {
            for (int i = 0; i < mapped.length; ++i) {
                Arrays.fill(in, false);
                for (int j = 0; j < this.classMapping[i].length; ++j) {
                    in[this.classMapping[i][j]] = true;
                }
                mapped[i] = DataSet.union(s, in);
            }
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return mapped;
    }
}

