/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.DataType;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.TwoClassAbstractPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;

public class SensitivityForFixedSpecificity
extends TwoClassAbstractPerformanceMeasure
implements NumericalPerformanceMeasure {
    public SensitivityForFixedSpecificity() {
        try {
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Specificity", "The fixed specificity for the sensitivity.", true, new NumberValidator<Double>(0.0, 1.0), 0.999)});
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
    }

    public SensitivityForFixedSpecificity(double specificity) throws Exception {
        this();
        this.getParameterAt(0).setValue(specificity);
    }

    public SensitivityForFixedSpecificity(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getName() {
        return "Sensitivity for a fixed specificity";
    }

    @Override
    public NumericalResultSet compute(double[] sortedScoresClass0, double[] sortedScoresClass1) {
        int i;
        double specificity = (Double)this.getParameterAt(0).getValue();
        int m = sortedScoresClass0.length;
        double threshold = sortedScoresClass1[(int)Math.ceil(specificity * (double)(sortedScoresClass1.length - 1))];
        for (i = 0; i < m && sortedScoresClass0[i] <= threshold; ++i) {
        }
        return new NumericalResultSet(new NumericalResult[][]{{new NumericalResult(this.getName() + " of " + specificity, "", (double)(m - i) / (double)m), new NumericalResult("Threshold for the " + this.getName().toLowerCase() + " of " + specificity, "", threshold)}});
    }

    @Override
    public NumericalResultSet compute(double[][][] classSpecificScores) {
        return (NumericalResultSet)super.compute(classSpecificScores);
    }
}

