/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.galaxy;

import de.jstacs.DataType;
import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.DataSetResult;
import de.jstacs.results.ImageResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.MeanResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.SimpleResult;
import de.jstacs.results.StorableResult;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import javax.imageio.ImageIO;

public class GalaxyAdaptor {
    private ParameterSet parameters;
    private String toolname;
    private String description;
    private String help;
    private String command;
    private String version;
    private Protocol protocol;
    private boolean exportProtocol;
    private LinkedList<OutputElement> list = new LinkedList();
    private String outfile;
    private String outfileId;
    private String newFilePath;
    private String htmlFilesPath;
    private static String stylesheetURL = "/static/style/base.css";
    private static int htmlId = 0;
    private static String[] colors = new String[]{"#99FFFF", "#CCCCFF", "#99FFCC", "#CCFF99", "#FFCC99"};

    public static String getColor(int depth) {
        while (depth >= colors.length) {
            depth -= colors.length;
        }
        return colors[depth];
    }

    public static int getHtmlId() {
        return htmlId++;
    }

    public GalaxyAdaptor(ParameterSet parameters, String toolname, String description, String version, String command) {
        this.parameters = parameters;
        this.toolname = toolname;
        this.description = description;
        this.version = version;
        this.help = description;
        this.command = command;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void setHelp(File helpfile) throws IOException {
        BufferedReader read = new BufferedReader(new FileReader(helpfile));
        String temp = null;
        StringBuffer helpb = new StringBuffer();
        while ((temp = read.readLine()) != null) {
            helpb.append(temp);
            helpb.append("\n");
        }
        this.help = helpb.toString();
    }

    public Protocol getProtocol(boolean exportProtocol) {
        this.exportProtocol = exportProtocol;
        this.protocol = new Protocol();
        return this.protocol;
    }

    public String toGalaxyConfig() throws Exception {
        StringBuffer allBuffer = new StringBuffer();
        XMLParser.appendObjectWithTagsAndAttributes(allBuffer, this.description, "description", null, false);
        allBuffer.append("\n");
        XMLParser.appendObjectWithTagsAndAttributes(allBuffer, this.command + " --run $script_file $summary $summary.id $__new_file_path__ $summary.extra_files_path", "command", null, false);
        allBuffer.append("\n");
        StringBuffer descBuffer = new StringBuffer();
        StringBuffer confBuffer = new StringBuffer();
        this.parameters.toGalaxy(GalaxyAdaptor.getLegalName(this.toolname), "", 0, descBuffer, confBuffer);
        XMLParser.addTags(descBuffer, "inputs");
        confBuffer = GalaxyAdaptor.escape(confBuffer);
        XMLParser.addTagsAndAttributes(confBuffer, "configfile", "name=\"script_file\"");
        XMLParser.addTags(confBuffer, "configfiles");
        allBuffer.append(descBuffer);
        allBuffer.append(confBuffer);
        StringBuffer outBuf = new StringBuffer();
        XMLParser.addTagsAndAttributes(outBuf, "data", "format=\"html\" name=\"summary\"");
        XMLParser.addTags(outBuf, "outputs");
        allBuffer.append(outBuf);
        StringBuffer helpBuf = new StringBuffer();
        helpBuf.append(this.help);
        XMLParser.addTags(helpBuf, "help");
        allBuffer.append(helpBuf);
        XMLParser.addTagsAndAttributes(allBuffer, "tool", "id=\"" + GalaxyAdaptor.getLegalName(this.toolname) + "\" name=\"" + this.toolname + "\" version=\"" + this.version + "\" force_history_refresh=\"true\"");
        return allBuffer.toString();
    }

    public void fromGalaxyConfig(String filename) throws Exception {
        StringBuffer buf = new StringBuffer();
        BufferedReader read = new BufferedReader(new FileReader(filename));
        String tmp = null;
        while ((tmp = read.readLine()) != null) {
            buf.append(tmp);
        }
        this.parameters.fromGalaxy(GalaxyAdaptor.getLegalName(this.toolname), buf);
    }

    private String getLROutput(ListResult lr) throws IOException {
        StringBuffer all = new StringBuffer();
        if (lr.getAnnotation() != null) {
            ResultSet annotation = lr.getAnnotation();
            for (int i = 0; i < annotation.getNumberOfResults(); ++i) {
                Result r = annotation.getResultAt(i);
                DataType d = r.getDatatype();
                if (d == DataType.PNG || d == DataType.HTML || d == DataType.LIST || d == DataType.STORABLE) continue;
                StringBuffer sb = new StringBuffer();
                sb.append("<label>" + r.getName() + ":</label>");
                sb.append(r.getValue().toString());
                XMLParser.addTags(sb, "div");
                all.append(sb);
            }
        }
        StringBuffer list = new StringBuffer();
        ResultSet[] res = lr.getValue();
        for (int i = 0; i < res.length; ++i) {
            int j;
            boolean newNames = i == 0;
            int k = res[i].getNumberOfResults() - 1;
            if (!newNames) {
                if (k + 1 != res[i - 1].getNumberOfResults()) {
                    newNames = true;
                } else {
                    for (j = 0; j <= k; ++j) {
                        if (res[i].getResultAt(j).getName().equals(res[i - 1].getResultAt(j).getName())) continue;
                        newNames = true;
                        break;
                    }
                }
            }
            if (newNames) {
                if (i != 0) {
                    list.append("</table>");
                }
                list.append("<table border=\"1\">");
                list.append("<tr>");
                for (j = 0; j <= k; ++j) {
                    list.append("<th>" + res[i].getResultAt(j).getName() + "</th>");
                }
                list.append("</tr>");
            }
            list.append("<tr>");
            for (j = 0; j <= k; ++j) {
                if (res[i].getResultAt(j) instanceof SimpleResult) {
                    list.append("<td>" + res[i].getResultAt(j).getValue() + "</td>");
                    continue;
                }
                list.append("<td>" + this.getOutput(res[i].getResultAt(j)) + "</td>");
            }
            list.append("</tr>");
        }
        list.append("</table>");
        XMLParser.addTags(list, "div");
        all.append(list);
        return all.toString();
    }

    private String getOutput(Result res) throws IOException {
        StringBuffer temp;
        StringBuffer buf = new StringBuffer();
        StringBuffer temp2 = new StringBuffer();
        temp2.append(res.getName());
        XMLParser.addTagsAndAttributes(temp2, "div", "class=\"toolFormTitle\"");
        if (res instanceof SimpleResult) {
            temp = new StringBuffer();
            temp.append(res.getValue().toString().replaceAll("\\n", "<br />"));
            XMLParser.addTags(temp, "div");
            buf.append(temp);
        } else if (res instanceof ListResult) {
            buf.append(this.getLROutput((ListResult)res));
        } else if (res instanceof DataSetResult) {
            buf.append(this.getDataSetOutput((DataSetResult)res));
        } else if (res instanceof StorableResult) {
            buf.append(this.getStorableOutput((StorableResult)res));
        } else if (res instanceof AbstractScoreBasedClassifier.DoubleTableResult) {
            buf.append(this.getDTROutput((AbstractScoreBasedClassifier.DoubleTableResult)res));
        } else if (res instanceof ImageResult) {
            buf.append(this.getIROutput((ImageResult)res));
        } else if (res instanceof FileResult) {
            buf.append(this.getFileOutput((FileResult)res));
        }
        temp = new StringBuffer();
        temp.append(res.getComment());
        if (res instanceof LinkedImageResult) {
            temp.append("<br />Obtain &quot;" + ((LinkedImageResult)res).getLink().getName() + "&quot; (" + ((LinkedImageResult)res).getLink().getComment() + ") by clicking on the image");
        }
        XMLParser.addTagsAndAttributes(temp, "div", "class=\"toolParamHelp\"");
        buf.append(temp);
        XMLParser.addTagsAndAttributes(buf, "div", "class=\"form-row\"");
        XMLParser.addTagsAndAttributes(buf, "div", "class=\"toolFormBody\"");
        temp2.append(buf);
        XMLParser.addTagsAndAttributes(temp2, "div", "class=\"toolForm\"");
        return temp2.toString();
    }

    private String getDTROutput(AbstractScoreBasedClassifier.DoubleTableResult res) {
        double[][] r = res.getValue();
        StringBuffer sb = new StringBuffer();
        sb.append("<table>");
        for (int i = 0; i < r.length; ++i) {
            sb.append("<tr>");
            for (int j = 0; j < r[i].length; ++j) {
                sb.append("<td>" + r[i][j] + "</td>");
            }
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    private String getIROutput(ImageResult res) throws IOException {
        String name = GalaxyAdaptor.getLegalName(res.getName()) + GalaxyAdaptor.getHtmlId() + ".";
        String filename = this.htmlFilesPath + System.getProperty("file.separator") + name;
        File f = new File(filename + "png");
        f.getParentFile().mkdirs();
        BufferedImage img = res.getValue();
        ImageIO.write((RenderedImage)img, "png", f);
        String ext = "png";
        StringBuffer sb = new StringBuffer();
        sb.append("<img src=\"" + name + ext + "\" alt=\"" + res.getName() + "\" width=\"" + img.getWidth() + "\" height=\"" + img.getHeight() + "\"/>");
        if (res instanceof LinkedImageResult) {
            FileResult fr = ((LinkedImageResult)res).getLink();
            XMLParser.addTagsAndAttributes(sb, "a", "href=\"" + fr.getFilename() + "." + fr.getExtension() + "\"");
        }
        return sb.toString();
    }

    private String getFileOutput(FileResult res) {
        return "<a href=\"" + res.getFilename() + "." + res.getExtension() + "\">" + res.getName() + "</a>";
    }

    private String getStorableOutput(StorableResult res) throws IOException {
        String name = GalaxyAdaptor.getLegalName(res.getName()) + GalaxyAdaptor.getHtmlId() + ".";
        String ext = this.export(this.htmlFilesPath + System.getProperty("file.separator") + name, res);
        return "<a href=\"" + name + ext + "\">" + res.getName() + "</a>";
    }

    private String getDataSetOutput(DataSetResult res) throws IOException {
        DataSet data = res.getValue();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (res.getParser() == null) {
            data.save(baos, '>', new SplitSequenceAnnotationParser(":", ";"));
        } else {
            data.save(baos, '>', res.getParser());
        }
        return baos.toString().replaceAll("\\n", "<br />");
    }

    private String getOutput(ResultSet res) throws IOException {
        Result[] ress = null;
        ress = res instanceof MeanResultSet ? ((MeanResultSet)res).getStatistics().getResults() : res.getResults();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ress.length; ++i) {
            sb.append(this.getOutput(ress[i]));
        }
        return sb.toString();
    }

    public String export(String filename, Result res) throws IOException {
        if (res instanceof SimpleResult) {
            File f = new File(filename + "txt");
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(filename + "txt");
            pw.println(res.toString());
            pw.close();
            return "txt";
        }
        if (res instanceof ListResult) {
            File f = new File(filename + "tabular");
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(filename + "tabular");
            ((ListResult)res).print(pw);
            pw.close();
            return "tabular";
        }
        if (res instanceof DataSetResult) {
            File f = new File(filename + "fasta");
            f.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(filename + "fasta");
            if (((DataSetResult)res).getParser() == null) {
                ((DataSetResult)res).getValue().save(fos, '>', new SplitSequenceAnnotationParser(":", ";"));
            } else {
                ((DataSetResult)res).getValue().save(fos, '>', ((DataSetResult)res).getParser());
            }
            fos.close();
            return "fasta";
        }
        if (res instanceof StorableResult) {
            File f = new File(filename + "xml");
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(filename + "xml");
            pw.println(((StorableResult)res).getValue());
            pw.close();
            return "xml";
        }
        if (res instanceof AbstractScoreBasedClassifier.DoubleTableResult) {
            File f = new File(filename + "tabular");
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(filename + "tabular");
            double[][] tab = ((AbstractScoreBasedClassifier.DoubleTableResult)res).getValue();
            for (int i = 0; i < tab.length; ++i) {
                for (int j = 0; j < tab[i].length - 1; ++j) {
                    pw.print(tab[i][j] + "\t");
                }
                if (tab[i].length > 0) {
                    pw.println(tab[i][tab[i].length - 1]);
                    continue;
                }
                pw.println();
            }
            pw.close();
            return "tabular";
        }
        if (res instanceof LinkedImageResult) {
            return this.export(filename, ((LinkedImageResult)res).getLink());
        }
        if (res instanceof ImageResult) {
            File f = new File(filename + "png");
            f.getParentFile().mkdirs();
            BufferedImage img = ((ImageResult)res).getValue();
            ImageIO.write((RenderedImage)img, "png", new File(filename + "png"));
            return "png";
        }
        if (res instanceof FileResult) {
            String ext = ((FileResult)res).getExtension();
            File f = new File(filename + ext);
            f.getParentFile().mkdirs();
            FileManager.copy(((FileResult)res).getValue().getAbsolutePath(), f.getAbsolutePath());
            System.out.println("exported " + f.getAbsolutePath());
            return ext;
        }
        return null;
    }

    public void writeOutput() throws IOException {
        StringBuffer summary = new StringBuffer();
        int i = 0;
        boolean exported = false;
        for (OutputElement el : this.list) {
            boolean export = el.export;
            Object res = el.result;
            boolean include = el.includeInSummary;
            String str = null;
            if (include) {
                str = res instanceof Result ? this.getOutput((Result)res) : (res instanceof ResultSet ? this.getOutput((ResultSet)res) : res.toString().replaceAll("\\n", "<br />"));
                summary.append(str);
            }
            if (!export) continue;
            exported = true;
            if (res instanceof Result) {
                String name = ++i + "";
                String ext = this.export(this.newFilePath + System.getProperty("file.separator") + "primary_" + this.outfileId + "_" + name + "_visible_", (Result)res);
                continue;
            }
            ResultSet rs = (ResultSet)res;
            for (int j = 0; j < rs.getNumberOfResults(); ++j) {
                String name = ++i + "";
                String ext = this.export(this.newFilePath + System.getProperty("file.separator") + "primary_" + this.outfileId + "_" + name + "_visible_", rs.getResultAt(i));
            }
        }
        if (this.protocol != null) {
            CategoricalResult prot = new CategoricalResult("Protocol", "The protocol of this " + this.toolname + " run", this.protocol.toString());
            summary.append(this.getOutput(prot));
            if (this.exportProtocol) {
                this.export(this.newFilePath + System.getProperty("file.separator") + "primary_" + this.outfileId + "_" + ++i + "_visible_", prot);
            }
        }
        XMLParser.addTags(summary, "body");
        StringBuffer all = new StringBuffer();
        StringBuffer head = new StringBuffer();
        head.append("Summary of " + this.toolname + " results");
        XMLParser.addTags(head, "title");
        all.append(head);
        head = new StringBuffer();
        XMLParser.addTagsAndAttributes(head, "link", "href=\"" + stylesheetURL + "\" rel=\"stylesheet\" type=\"text/css\"");
        all.append(head);
        XMLParser.addTags(all, "head");
        all.append(summary);
        XMLParser.addTags(all, "html");
        PrintWriter wr = new PrintWriter(this.outfile);
        wr.println(all);
        wr.close();
    }

    public boolean parse(String[] args) throws Exception {
        if ("--create".equals(args[0])) {
            String str = this.toGalaxyConfig();
            PrintWriter wr = new PrintWriter(args[1]);
            wr.println(str);
            wr.close();
            return false;
        }
        if ("--run".equals(args[0])) {
            this.fromGalaxyConfig(args[1]);
            this.outfile = args[2];
            this.outfileId = args[3];
            this.newFilePath = args[4];
            this.htmlFilesPath = args[5];
            return true;
        }
        return false;
    }

    public void addResult(Result res, boolean export, boolean includeInSummary) {
        this.list.add(new OutputElement(res, export, includeInSummary));
    }

    public void addResultSet(ResultSet res, boolean exportAll, boolean includeInSummary) {
        this.list.add(new OutputElement(res, exportAll, includeInSummary));
    }

    public static String getLegalName(String name) {
        return name.replaceAll("[\\s,-:]+", "_");
    }

    private static StringBuffer escape(StringBuffer str) {
        return new StringBuffer(str.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
    }

    public String getHtmlFilesPath() {
        return this.htmlFilesPath;
    }

    private static class OutputElement {
        private Object result;
        private boolean export;
        private boolean includeInSummary;

        private OutputElement(Object result, boolean export, boolean includeInSummary) {
            this.result = result;
            this.export = export;
            this.includeInSummary = includeInSummary;
        }
    }

    public static class Protocol {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private PrintWriter wr = new PrintWriter(this.baos);

        private Protocol() {
        }

        public void append(String str) {
            this.wr.append(str);
        }

        public PrintWriter getWriter() {
            return this.wr;
        }

        public ByteArrayOutputStream getOutputStream() {
            return this.baos;
        }

        public void appendHeading(String str) {
            this.wr.append("<strong>" + str + "</strong>\n");
            this.wr.flush();
        }

        public void appendWarning(String str) {
            this.wr.append("<em>" + str + "</em>\n");
            this.wr.flush();
        }

        public String toString() {
            this.wr.flush();
            return this.baos.toString().replaceAll("\n", "<br />");
        }
    }

    public static class FileResult
    extends Result {
        private String path;
        private String filename;
        private String extension;

        public FileResult(String name, String comment, String fullPath) {
            super(name, comment, DataType.FILE);
            int idx = fullPath.lastIndexOf(System.getProperty("file.separator"));
            int extIdx = fullPath.lastIndexOf(".");
            this.path = fullPath.substring(0, idx);
            this.filename = fullPath.substring(idx + 1, extIdx);
            this.extension = fullPath.substring(extIdx + 1);
            this.getValue().getParentFile().mkdirs();
        }

        public FileResult(String name, String comment, String path, String filename, String extension) {
            super(name, comment, DataType.FILE);
            this.path = path;
            this.filename = filename;
            this.extension = extension;
            this.getValue().getParentFile().mkdirs();
        }

        public FileResult(StringBuffer rep) throws NonParsableException {
            super(rep);
        }

        @Override
        public String getXMLTag() {
            return this.getClass().getSimpleName();
        }

        @Override
        protected void appendFurtherInfos(StringBuffer sb) {
            XMLParser.appendObjectWithTags(sb, this.path, "path");
            XMLParser.appendObjectWithTags(sb, this.filename, "filename");
            XMLParser.appendObjectWithTags(sb, this.extension, "extension");
        }

        @Override
        protected void extractFurtherInfos(StringBuffer rep) throws NonParsableException {
            this.path = XMLParser.extractObjectForTags(rep, "path", String.class);
            this.filename = XMLParser.extractObjectForTags(rep, "filename", String.class);
            this.extension = XMLParser.extractObjectForTags(rep, "extension", String.class);
        }

        @Override
        public File getValue() {
            String sep = System.getProperty("file.separator");
            return new File(this.path + sep + this.filename + "." + this.extension);
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getExtension() {
            return this.extension;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }
    }

    public static class LinkedImageResult
    extends ImageResult {
        private FileResult link;

        public LinkedImageResult(String name, String comment, BufferedImage image, FileResult link) {
            super(name, comment, image);
            this.link = link;
        }

        public LinkedImageResult(StringBuffer xml) throws NonParsableException {
            super(xml);
        }

        @Override
        public String getXMLTag() {
            return this.getClass().getSimpleName();
        }

        @Override
        protected void appendFurtherInfos(StringBuffer sb) {
            XMLParser.appendObjectWithTags(sb, this.link, "link");
        }

        @Override
        protected void extractFurtherInfos(StringBuffer representation) throws NonParsableException {
            this.link = XMLParser.extractObjectForTags(representation, "link", FileResult.class);
        }

        public FileResult getLink() {
            return this.link;
        }
    }
}

