/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.gui.RasmolCommandListener;
import org.biojava.bio.structure.io.PDBFileReader;

public class BiojavaJmol {
    public static final String viewer = "org.jmol.api.JmolSimpleViewer";
    public static final String adapter = "org.jmol.api.JmolAdapter";
    public static final String smartAdapter = "org.jmol.adapter.smarter.SmarterJmolAdapter";
    Structure structure;
    JmolPanel jmolPanel;
    JFrame frame = new JFrame();

    public static void main(String[] args) {
        try {
            PDBFileReader pdbr = new PDBFileReader();
            pdbr.setPath("/Users/andreas/WORK/PDB/");
            String pdbCode = "5pti";
            Structure struc = pdbr.getStructureById(pdbCode);
            BiojavaJmol jmolPanel = new BiojavaJmol();
            jmolPanel.setStructure(struc);
            jmolPanel.evalString("select * ; color chain;");
            jmolPanel.evalString("select *; spacefill off; wireframe off; backbone 0.4;  ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BiojavaJmol() {
        this.frame.addWindowListener(new ApplicationCloser());
        Container contentPane = this.frame.getContentPane();
        Box vBox = Box.createVerticalBox();
        try {
            this.jmolPanel = new JmolPanel();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.err.println("could not find Jmol in classpath, please install first");
            return;
        }
        this.jmolPanel.setPreferredSize(new Dimension(200, 200));
        vBox.add(this.jmolPanel);
        JTextField field = new JTextField();
        field.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        field.setText("enter RASMOL like command...");
        RasmolCommandListener listener = new RasmolCommandListener(this.jmolPanel, field);
        field.addActionListener(listener);
        field.addMouseListener(listener);
        field.addKeyListener(listener);
        vBox.add(field);
        contentPane.add(vBox);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public static boolean jmolInClassPath() {
        try {
            Class.forName(viewer);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void evalString(String rasmolScript) {
        if (this.jmolPanel == null) {
            System.err.println("please install Jmol first");
            return;
        }
        this.jmolPanel.evalString(rasmolScript);
    }

    public void setStructure(Structure s) {
        if (this.jmolPanel == null) {
            System.err.println("please install Jmol first");
            return;
        }
        this.frame.setName(s.getPDBCode());
        String pdb = s.toPDB();
        System.out.println(s.isNmr());
        this.jmolPanel.openStringInline(pdb);
    }

    public void setTitle(String label) {
        this.frame.setTitle(label);
    }

    static class JmolPanel
    extends JPanel {
        private static final long serialVersionUID = -3661941083797644242L;
        Class viewerC;
        Class adapterC;
        Class smartAdapterC;
        Object viewerO;
        Object adapterO;
        Method evalString;
        Method renderScreenImage;
        Method openStringInline;
        final Dimension currentSize = new Dimension();
        final Rectangle rectClip = new Rectangle();

        JmolPanel() throws ClassNotFoundException {
            try {
                this.viewerC = Class.forName(BiojavaJmol.viewer);
                this.adapterC = Class.forName(BiojavaJmol.adapter);
                this.smartAdapterC = Class.forName(BiojavaJmol.smartAdapter);
                Method m = this.viewerC.getMethod("allocateSimpleViewer", Component.class, this.adapterC);
                Constructor constructor = this.smartAdapterC.getConstructor(new Class[0]);
                this.adapterO = constructor.newInstance(new Object[0]);
                this.viewerO = m.invoke((Object)this.viewerC, this, this.adapterO);
                this.evalString = this.viewerC.getMethod("evalString", String.class);
                this.renderScreenImage = this.viewerC.getMethod("renderScreenImage", Graphics.class, Dimension.class, Rectangle.class);
                this.openStringInline = this.viewerC.getMethod("openStringInline", String.class);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        public Class getViewer() {
            return this.viewerC;
        }

        public void evalString(String rasmolScript) {
            try {
                this.evalString.invoke(this.viewerO, rasmolScript);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void openStringInline(String pdbFile) {
            try {
                this.openStringInline.invoke(this.viewerO, pdbFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void executeCmd(String rasmolScript) {
            try {
                this.evalString.invoke(this.viewerO, rasmolScript);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void paint(Graphics g) {
            this.getSize(this.currentSize);
            g.getClipBounds(this.rectClip);
            try {
                this.renderScreenImage.invoke(this.viewerO, g, this.currentSize, this.rectClip);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class ApplicationCloser
    extends WindowAdapter {
        ApplicationCloser() {
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

