/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization.termination;

import de.jstacs.DataType;
import de.jstacs.algorithms.optimization.termination.AbstractTerminationCondition;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.utils.Time;

public class SmallGradientConditon
extends AbstractTerminationCondition {
    private double eps;

    public SmallGradientConditon(double epsilon) throws Exception {
        this(new SmallGradientConditonParameterSet(epsilon));
    }

    public SmallGradientConditon(SmallGradientConditonParameterSet parameter) throws CloneNotSupportedException {
        super(parameter);
    }

    @Override
    protected void set() {
        this.eps = (Double)this.parameter.getParameterAt(0).getValue();
    }

    @Override
    protected String getXmlTag() {
        return "SmallGradientConditon";
    }

    public SmallGradientConditon(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public boolean doNextIteration(int iteration, double fLast, double fCurrent, double[] gradient, double[] direction, double alpha, Time t) {
        double sum = 0.0;
        for (int i = 0; i < gradient.length; ++i) {
            sum += Math.abs(gradient[i]);
        }
        System.out.println("sum " + sum);
        return sum >= this.eps;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    public static class SmallGradientConditonParameterSet
    extends AbstractTerminationCondition.AbstractTerminationConditionParameterSet {
        public SmallGradientConditonParameterSet() throws SimpleParameter.DatatypeNotValidException {
            super((Class<? extends AbstractTerminationCondition>)SmallGradientConditon.class);
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "epsilon", "the epsilon for the gradient used for deciding whether to stop the algorithm or not", true, new NumberValidator<Double>(new Double(0.0), new Double(Double.MAX_VALUE)))});
        }

        public SmallGradientConditonParameterSet(StringBuffer xml) throws NonParsableException {
            super(xml);
        }

        public SmallGradientConditonParameterSet(double eps) throws IllegalArgumentException, SimpleParameter.IllegalValueException, SimpleParameter.DatatypeNotValidException {
            this();
            this.getParameterAt(0).setValue(eps);
        }

        @Override
        public String getInstanceComment() {
            return "a set of parameters for the SmallGradientConditon";
        }

        @Override
        public String getInstanceName() {
            return "SmallGradientConditonParameterSet";
        }
    }
}

