/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.results.ListResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.ToolBox;

public class ConfusionMatrix
extends AbstractPerformanceMeasure {
    public ConfusionMatrix() {
    }

    public ConfusionMatrix(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public ResultSet compute(double[] sortedScoresClass0, double[] sortedScoresClass1) {
        int j;
        int i;
        int m = sortedScoresClass0.length;
        for (i = 0; i < m && sortedScoresClass0[i] < 0.0; ++i) {
        }
        int d = sortedScoresClass1.length;
        for (j = d - 1; j >= 0 && sortedScoresClass1[j] >= 0.0; --j) {
        }
        return new ResultSet(new ListResult(this.getName(), this.getName() + " for two classes.", null, new NumericalResultSet(new NumericalResult[][]{{new NumericalResult("TP", "true positives", sortedScoresClass0.length - i), new NumericalResult("FN", "false negatives", i)}}), new NumericalResultSet(new NumericalResult[][]{{new NumericalResult("FP", "false positives", j + 1), new NumericalResult("TN", "true negatives", d - (j + 1))}})));
    }

    @Override
    public ResultSet compute(double[][][] classSpecificScores) {
        int[][] res = new int[classSpecificScores.length][classSpecificScores.length];
        for (int i = 0; i < classSpecificScores.length; ++i) {
            for (int j = 0; j < classSpecificScores[i].length; ++j) {
                int predicted = ToolBox.getMaxIndex(classSpecificScores[i][j]);
                int[] nArray = res[i];
                int n = predicted;
                nArray[n] = nArray[n] + 1;
            }
        }
        ResultSet[] sets = new NumericalResultSet[classSpecificScores.length];
        for (int i = 0; i < res.length; ++i) {
            NumericalResult[] temp = new NumericalResult[res[i].length];
            for (int j = 0; j < res[i].length; ++j) {
                temp[j] = new NumericalResult(i + "/" + j, "correct class: " + i + ", predicted class: " + j, res[i][j]);
            }
            sets[i] = new NumericalResultSet(new NumericalResult[][]{temp});
        }
        return new ResultSet(new ListResult(this.getName(), this.getName() + " for " + classSpecificScores.length + " classes", null, sets));
    }

    @Override
    public int getAllowedNumberOfClasses() {
        return 0;
    }

    @Override
    public String getName() {
        return "Confusion matrix";
    }
}

