/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.RecyclableSequenceEnumerator;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.Sequence;
import java.util.Arrays;

public class DiscreteSequenceEnumerator
implements RecyclableSequenceEnumerator {
    private AlphabetContainer con;
    private int[] symbol;
    private int[] stop;
    private int[] compl;
    private int length;
    boolean sparse;

    public DiscreteSequenceEnumerator(AlphabetContainer con, int length, boolean sparse) {
        if (!con.isDiscrete()) {
            throw new IllegalArgumentException("The AlphabetContainer has to be discrete.");
        }
        int l = con.getPossibleLength();
        if (l != 0 && l != length) {
            throw new IllegalArgumentException("Please check the length");
        }
        this.con = con;
        this.length = length;
        this.symbol = new int[length + 1];
        this.stop = new int[length + 1];
        for (l = 0; l < length; ++l) {
            this.stop[l] = (int)con.getAlphabetLengthAt(l) - 1;
        }
        this.stop[length] = 1;
        if (sparse) {
            if (!con.isSimple()) {
                throw new IllegalArgumentException("The enumerator can not be sparse, since it has a non-simple AlphabetContainer.");
            }
            ComplementableDiscreteAlphabet abc = (ComplementableDiscreteAlphabet)con.getAlphabetAt(0);
            this.compl = new int[this.stop[0] + 1];
            for (int i = 0; i <= this.stop[0]; ++i) {
                this.compl[i] = abc.getComplementaryCode(i);
            }
            System.out.println(Arrays.toString(this.compl));
        }
        this.sparse = sparse;
    }

    @Override
    public boolean hasMoreElements() {
        return this.symbol[this.length] == 0;
    }

    @Override
    public Sequence<int[]> nextElement() {
        int l;
        IntSequence seq;
        try {
            seq = new IntSequence(this.con, this.symbol, 0, this.length);
        }
        catch (Exception e) {
            RuntimeException r = new RuntimeException(e.getMessage());
            r.setStackTrace(e.getStackTrace());
            throw r;
        }
        do {
            for (l = 0; l < this.length && this.symbol[l] == this.stop[l]; ++l) {
                this.symbol[l] = 0;
            }
            int n = l;
            this.symbol[n] = this.symbol[n] + 1;
            if (!this.sparse) continue;
            l = 0;
            int k = this.length - 1;
            while (l < this.length && this.symbol[l] == this.compl[this.symbol[k]]) {
                ++l;
                --k;
            }
            if (l >= this.length || this.symbol[l] >= this.compl[this.symbol[k]]) continue;
            l = this.length;
        } while (this.symbol[this.length] == 0 && this.sparse && l != this.length);
        return seq;
    }

    @Override
    public void reset() {
        Arrays.fill(this.symbol, 0);
    }
}

