/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable;

import de.jstacs.NotTrainedException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.sequenceScores.differentiable.AbstractDifferentiableSequenceScore;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;

public abstract class AbstractDifferentiableStatisticalModel
extends AbstractDifferentiableSequenceScore
implements DifferentiableStatisticalModel {
    public AbstractDifferentiableStatisticalModel(AlphabetContainer alphabets, int length) throws IllegalArgumentException {
        super(alphabets, length);
    }

    public AbstractDifferentiableStatisticalModel(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public AbstractDifferentiableStatisticalModel clone() throws CloneNotSupportedException {
        return (AbstractDifferentiableStatisticalModel)super.clone();
    }

    @Override
    public boolean isNormalized() {
        return false;
    }

    public static boolean isNormalized(DifferentiableSequenceScore ... function) {
        int i;
        for (i = 0; i < function.length && (function[i] == null || function[i] instanceof DifferentiableStatisticalModel && ((DifferentiableStatisticalModel)function[i]).isNormalized()); ++i) {
        }
        return i == function.length;
    }

    @Override
    public double getInitialClassParam(double classProb) {
        return Math.log(classProb) - this.getLogNormalizationConstant();
    }

    @Override
    public double getLogProbFor(Sequence sequence) {
        return this.getLogScoreFor(sequence) - this.getLogNormalizationConstant();
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos) throws Exception {
        return this.getLogScoreFor(sequence, startpos) - this.getLogNormalizationConstant();
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) {
        return this.getLogScoreFor(sequence.getSubSequence(startpos, endpos - startpos + 1)) - this.getLogNormalizationConstant();
    }

    @Override
    public double[] getLogScoreFor(DataSet data) throws Exception {
        double[] probs = new double[data.getNumberOfElements()];
        this.getLogScoreFor(data, probs);
        return probs;
    }

    @Override
    public void getLogScoreFor(DataSet data, double[] res) throws Exception {
        if (res.length != data.getNumberOfElements()) {
            throw new IllegalArgumentException("The array has wrong dimension.");
        }
        DataSet.ElementEnumerator ei = new DataSet.ElementEnumerator(data);
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.getLogScoreFor(ei.nextElement());
        }
    }

    @Override
    public DataSet emitDataSet(int numberOfSequences, int ... seqLength) throws NotTrainedException, Exception {
        throw new Exception("Standard implementation of emitDataSet used for " + this.getInstanceName() + ". You have to overwrite this method to use it in a proper way.");
    }

    @Override
    public byte getMaximalMarkovOrder() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The maximal markov order for this model in undefined.");
    }
}

