/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractVariableLengthDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.SamplingDifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.util.Arrays;
import java.util.TreeMap;

public class CyclicMarkovModelDiffSM
extends AbstractVariableLengthDiffSM
implements SamplingDifferentiableStatisticalModel {
    private boolean freeParams;
    private boolean plugIn;
    private boolean optimize;
    private boolean optimizeFrame;
    private int order;
    private int period;
    private int starts;
    private int initFrame;
    private int[] powers;
    private double logGammaSum;
    private double[] frameHyper;
    private double[][][] params;
    private double[][][] probs;
    private double[][][] logNorm;
    private double[] frameLogScore;
    private double[] frameParams;
    private double[] frameProbs;
    private double[] partDer;
    private double[][][] hyper;
    private double logFrameNorm;
    private int[][][] counter;
    private int[][][] distCounter;
    private int[][] offset;

    public static double[][][] getHyperParams(int alphabetSize, int length, double ess, double[] frameProb, double[][][] prob) {
        if (alphabetSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (length <= 0) {
            throw new IllegalArgumentException();
        }
        if (ess <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (frameProb.length != prob.length) {
            throw new IllegalArgumentException();
        }
        int order = prob[0].length - 1;
        double[][][] hyper = new double[prob.length][prob[0].length][];
        double[] currentHyper = new double[(int)Math.pow(alphabetSize, order)];
        double[] nextHyper = new double[currentHyper.length];
        for (int startFrame = 0; startFrame < frameProb.length; ++startFrame) {
            currentHyper[0] = ess * frameProb[startFrame];
            int f = startFrame;
            for (int l = 0; l < length; ++l) {
                int ord = Math.min(order, l);
                int y = (int)Math.pow(alphabetSize, ord);
                if (hyper[f][ord] == null) {
                    hyper[f][ord] = new double[y * alphabetSize];
                }
                for (int x = 0; x < y; ++x) {
                    for (int a = 0; a < alphabetSize; ++a) {
                        int v = x * alphabetSize + a;
                        double[] dArray = hyper[f][ord];
                        int n = v;
                        dArray[n] = dArray[n] + currentHyper[x] * prob[f][ord][v];
                        int n2 = v % nextHyper.length;
                        nextHyper[n2] = nextHyper[n2] + currentHyper[x] * prob[f][ord][v];
                    }
                }
                f = (f + 1) % frameProb.length;
                System.arraycopy(nextHyper, 0, currentHyper, 0, currentHyper.length);
                Arrays.fill(nextHyper, 0.0);
            }
        }
        return hyper;
    }

    private static double[][][] getHyper(int period, int alphabetSize, double[] sumOfHyper) {
        double[][][] hyper = new double[period][sumOfHyper.length][];
        for (int o = 0; o < sumOfHyper.length; ++o) {
            int a = (int)Math.pow(alphabetSize, o + 1);
            double h = sumOfHyper[o] / (double)period / (double)a;
            for (int p = 0; p < period; ++p) {
                hyper[p][o] = new double[a];
                Arrays.fill(hyper[p][o], h);
            }
        }
        return hyper;
    }

    private static double[] getHyper(int period, double ess) {
        double[] hyper = new double[period];
        Arrays.fill(hyper, ess / (double)period);
        return hyper;
    }

    public CyclicMarkovModelDiffSM(AlphabetContainer alphabets, int order, int period, double classEss, double[] sumOfHyperParams, boolean plugIn, boolean optimize, int starts, int initFrame) {
        this(alphabets, CyclicMarkovModelDiffSM.getHyper(period, classEss), CyclicMarkovModelDiffSM.getHyper(period, (int)alphabets.getAlphabetLengthAt(0), sumOfHyperParams), plugIn, optimize, starts, initFrame);
    }

    public CyclicMarkovModelDiffSM(AlphabetContainer alphabets, double[] frameHyper, double[][][] hyper, boolean plugIn, boolean optimize, int starts, int initFrame) {
        super(alphabets);
        this.order = hyper[0].length - 1;
        this.period = frameHyper.length;
        this.createArrays();
        this.frameHyper = new double[this.period];
        this.hyper = new double[this.period][this.order + 1][];
        for (int p = 0; p < this.period; ++p) {
            if (frameHyper[p] < 0.0) {
                throw new IllegalArgumentException("The ess for the class has to be non-negative.");
            }
            this.frameHyper[p] = frameHyper[p];
            for (int o = 0; o <= this.order; ++o) {
                if ((double)hyper[p][o].length != Math.pow(this.powers[1], o + 1)) {
                    throw new IllegalArgumentException();
                }
                this.hyper[p][o] = new double[hyper[p][o].length];
                for (int i = 0; i < this.hyper[p][o].length; ++i) {
                    if (hyper[p][o][i] < 0.0) {
                        throw new IllegalArgumentException("The ess for the class has to be non-negative.");
                    }
                    this.hyper[p][o][i] = hyper[p][o][i];
                }
            }
        }
        this.frameParams = new double[this.period];
        Arrays.fill(this.frameParams, -Math.log(this.period));
        Arrays.fill(this.frameProbs, 1.0 / (double)this.period);
        this.params = new double[this.period][this.order + 1][];
        double uniform = 1.0 / (double)this.powers[1];
        double logUniform = Math.log(uniform);
        for (int p = 0; p < this.period; ++p) {
            for (int i = 0; i <= this.order; ++i) {
                this.params[p][i] = new double[this.powers[i + 1]];
                this.probs[p][i] = new double[this.powers[i + 1]];
                this.logNorm[p][i] = new double[this.powers[i]];
                Arrays.fill(this.params[p][i], logUniform);
                Arrays.fill(this.probs[p][i], uniform);
            }
        }
        this.plugIn = plugIn;
        this.optimize = optimize;
        this.optimizeFrame = true;
        if (starts <= 0) {
            throw new IllegalArgumentException("The number of starts has to be positive.");
        }
        this.starts = starts;
        this.setFreeParams(false);
        this.computeConstantsOfLogPrior();
        if (initFrame >= this.period) {
            throw new IllegalArgumentException("Check initFrame.");
        }
        this.initFrame = initFrame;
    }

    public CyclicMarkovModelDiffSM(StringBuffer source) throws NonParsableException {
        super(source);
    }

    private void createArrays() {
        this.powers = new int[this.order + 2];
        this.powers[0] = 1;
        this.powers[1] = (int)this.alphabets.getAlphabetLengthAt(0);
        for (int i = 2; i < this.powers.length; ++i) {
            this.powers[i] = this.powers[i - 1] * this.powers[1];
        }
        this.probs = new double[this.period][this.order + 1][];
        this.logNorm = new double[this.period][this.order + 1][];
        this.frameProbs = new double[this.period];
        this.counter = new int[this.period][this.period][this.powers[this.order + 1]];
        this.distCounter = new int[this.period][this.period][this.powers[this.order]];
        this.offset = new int[this.period][this.order + 2];
        this.frameLogScore = new double[this.period];
        this.partDer = new double[this.powers[1]];
    }

    @Override
    public CyclicMarkovModelDiffSM clone() throws CloneNotSupportedException {
        CyclicMarkovModelDiffSM clone = (CyclicMarkovModelDiffSM)super.clone();
        clone.frameHyper = (double[])this.frameHyper.clone();
        clone.hyper = (double[][][])ArrayHandler.clone((Cloneable[])this.hyper);
        clone.params = new double[this.period][this.order + 1][];
        clone.probs = new double[this.period][this.order + 1][];
        clone.logNorm = new double[this.period][this.order + 1][];
        clone.offset = new int[this.period][];
        clone.counter = new int[this.period][this.period][];
        clone.distCounter = new int[this.period][this.period][];
        for (int p = 0; p < this.period; ++p) {
            int o;
            for (o = 0; o <= this.order; ++o) {
                clone.params[p][o] = (double[])this.params[p][o].clone();
                clone.probs[p][o] = (double[])this.probs[p][o].clone();
                clone.logNorm[p][o] = (double[])this.logNorm[p][o].clone();
            }
            clone.offset[p] = (int[])this.offset[p].clone();
            for (o = 0; o < this.period; ++o) {
                clone.counter[p][o] = (int[])this.counter[p][o].clone();
                clone.distCounter[p][o] = (int[])this.distCounter[p][o].clone();
            }
        }
        clone.frameParams = (double[])this.frameParams.clone();
        clone.frameProbs = (double[])this.frameProbs.clone();
        clone.frameLogScore = (double[])this.frameLogScore.clone();
        clone.partDer = (double[])this.partDer.clone();
        return clone;
    }

    @Override
    public String getInstanceName() {
        return "cMM(" + this.order + ", " + this.period + ")";
    }

    private void fillFrameLogScores(Sequence seq, int start, int length) {
        int indexOld;
        int p;
        int l = 0;
        int indexNew = 0;
        int o = Math.min(this.order, length);
        for (p = 0; p < this.period; ++p) {
            this.frameLogScore[p] = this.frameParams[p];
        }
        while (l < o) {
            indexOld = indexNew;
            indexNew = indexOld * this.powers[1] + seq.discreteVal(start++);
            for (p = 0; p < this.period; ++p) {
                int n = p;
                this.frameLogScore[n] = this.frameLogScore[n] + (this.params[(p + l) % this.period][l][indexNew] - this.logNorm[(p + l) % this.period][l][indexOld]);
            }
            ++l;
        }
        while (l < length) {
            indexOld = indexNew % this.powers[this.order];
            indexNew = indexOld * this.powers[1] + seq.discreteVal(start++);
            for (p = 0; p < this.period; ++p) {
                int n = p;
                this.frameLogScore[n] = this.frameLogScore[n] + (this.params[(p + l) % this.period][this.order][indexNew] - this.logNorm[(p + l) % this.period][this.order][indexOld]);
            }
            ++l;
        }
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start, int end) {
        this.fillFrameLogScores(seq, start, end - start + 1);
        return Normalisation.getLogSum(this.frameLogScore) - this.logFrameNorm;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, int end, IntList indices, DoubleList dList) {
        int length = end - start + 1;
        if (this.optimize) {
            int index;
            int h;
            int indexOld;
            int z;
            int p;
            int l = 0;
            int indexNew = 0;
            int o = Math.min(this.order, length);
            for (p = 0; p < this.period; ++p) {
                for (z = 0; z < this.period; ++z) {
                    Arrays.fill(this.counter[p][z], 0);
                    Arrays.fill(this.distCounter[p][z], 0);
                }
                this.frameLogScore[p] = this.frameParams[p];
            }
            int stop = this.powers[1] - (this.freeParams ? 1 : 0);
            while (l < o) {
                indexOld = indexNew;
                z = indexOld * this.powers[1];
                indexNew = z + seq.discreteVal(start++);
                h = z - (this.freeParams ? indexOld : 0);
                for (p = 0; p < this.period; ++p) {
                    int n = p;
                    this.frameLogScore[n] = this.frameLogScore[n] + (this.params[(p + l) % this.period][l][indexNew] - this.logNorm[(p + l) % this.period][l][indexOld]);
                    for (index = 0; index < stop; ++index) {
                        indices.add(this.offset[p][l] + h + index);
                        if (z + index == indexNew) {
                            dList.add(1.0 - this.probs[p][l][z + index]);
                            continue;
                        }
                        dList.add(-this.probs[p][l][z + index]);
                    }
                }
                ++l;
            }
            while (l < length) {
                indexOld = indexNew % this.powers[this.order];
                indexNew = indexOld * this.powers[1] + seq.discreteVal(start++);
                for (p = 0; p < this.period; ++p) {
                    int n = p;
                    this.frameLogScore[n] = this.frameLogScore[n] + (this.params[(p + l) % this.period][this.order][indexNew] - this.logNorm[(p + l) % this.period][this.order][indexOld]);
                    int[] nArray = this.distCounter[p][(p + l) % this.period];
                    int n2 = indexOld;
                    nArray[n2] = nArray[n2] + 1;
                    int[] nArray2 = this.counter[p][(p + l) % this.period];
                    int n3 = indexNew;
                    nArray2[n3] = nArray2[n3] + 1;
                }
                ++l;
            }
            double erg = Normalisation.logSumNormalisation(this.frameLogScore, 0, this.period, this.frameLogScore, 0) - this.logFrameNorm;
            indexOld = 0;
            for (l = 0; l < o; ++l) {
                for (p = 0; p < this.period; ++p) {
                    indexNew = indexOld + stop;
                    dList.multiply(indexOld, indexNew, this.frameLogScore[p]);
                    indexOld = indexNew;
                }
            }
            for (l = 0; l < this.distCounter[0][0].length; ++l) {
                h = l * (this.powers[1] - (this.freeParams ? 1 : 0));
                o = l * this.powers[1];
                for (z = 0; z < this.period; ++z) {
                    Arrays.fill(this.partDer, 0.0);
                    boolean used = false;
                    for (p = 0; p < this.period; ++p) {
                        if (this.distCounter[p][z][l] <= 0) continue;
                        used = true;
                        for (index = 0; index < stop; ++index) {
                            int n = index;
                            this.partDer[n] = this.partDer[n] + this.frameLogScore[p] * ((double)this.counter[p][z][o + index] - (double)this.distCounter[p][z][l] * this.probs[z][this.order][o + index]);
                        }
                    }
                    if (!used) continue;
                    for (index = 0; index < stop; ++index) {
                        indices.add(this.offset[z][this.order] + h + index);
                        dList.add(this.partDer[index]);
                    }
                }
            }
            if (this.optimizeFrame) {
                for (p = 0; p < this.period - (this.freeParams ? 1 : 0); ++p) {
                    indices.add(p);
                    dList.add(this.frameLogScore[p] - this.frameProbs[p]);
                }
            }
            return erg;
        }
        return this.getLogScoreFor(seq, start, end);
    }

    @Override
    public int getNumberOfParameters() {
        return this.offset[this.period - 1][this.order + 1];
    }

    @Override
    public void setParameters(double[] params, int start) {
        if (this.optimize) {
            int p;
            int stop;
            if (this.optimizeFrame) {
                stop = this.period - (this.freeParams ? 1 : 0);
                this.logFrameNorm = 0.0;
                for (p = 0; p < stop; ++p) {
                    this.frameParams[p] = params[start++];
                    this.frameProbs[p] = Math.exp(this.frameParams[p]);
                    this.logFrameNorm += this.frameProbs[p];
                }
                if (stop < this.period) {
                    this.frameProbs[p] = Math.exp(this.frameParams[p]);
                    this.logFrameNorm += this.frameProbs[p];
                }
                p = 0;
                while (p < this.period) {
                    int n = p++;
                    this.frameProbs[n] = this.frameProbs[n] / this.logFrameNorm;
                }
                this.logFrameNorm = Math.log(this.logFrameNorm);
            }
            stop = this.powers[1] - (this.freeParams ? 1 : 0);
            for (p = 0; p < this.period; ++p) {
                for (int o = 0; o <= this.order; ++o) {
                    int index = 0;
                    for (int n = 0; n < this.logNorm[p][o].length; ++n) {
                        this.logNorm[p][o][n] = 0.0;
                        int j = 0;
                        while (j < stop) {
                            this.params[p][o][index + j] = params[start];
                            this.probs[p][o][index + j] = Math.exp(this.params[p][o][index + j]);
                            double[] dArray = this.logNorm[p][o];
                            int n2 = n;
                            dArray[n2] = dArray[n2] + this.probs[p][o][index + j];
                            ++j;
                            ++start;
                        }
                        if (j < this.powers[1]) {
                            this.probs[p][o][index + j] = Math.exp(this.params[p][o][index + j]);
                            double[] dArray = this.logNorm[p][o];
                            int n3 = n;
                            dArray[n3] = dArray[n3] + this.probs[p][o][index + j];
                        }
                        for (j = 0; j < this.powers[1]; ++j) {
                            double[] dArray = this.probs[p][o];
                            int n4 = index++;
                            dArray[n4] = dArray[n4] / this.logNorm[p][o][n];
                        }
                        this.logNorm[p][o][n] = Math.log(this.logNorm[p][o][n]);
                    }
                }
            }
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer b = new StringBuffer(10000);
        XMLParser.appendObjectWithTags(b, this.length, "length");
        XMLParser.appendObjectWithTags(b, this.alphabets, "alphabets");
        XMLParser.appendObjectWithTags(b, this.order, "order");
        XMLParser.appendObjectWithTags(b, this.period, "period");
        XMLParser.appendObjectWithTags(b, this.frameHyper, "frameEss");
        XMLParser.appendObjectWithTags(b, this.hyper, "hyper");
        XMLParser.appendObjectWithTags(b, this.frameParams, "frameParams");
        for (int p = 0; p < this.period; ++p) {
            XMLParser.appendObjectWithTagsAndAttributes(b, this.params[p], "params", "frame=\"" + p + "\"");
        }
        XMLParser.appendObjectWithTags(b, this.plugIn, "plugIn");
        XMLParser.appendObjectWithTags(b, this.optimize, "optimize");
        XMLParser.appendObjectWithTags(b, this.optimizeFrame, "optimizeFrame");
        XMLParser.appendObjectWithTags(b, this.starts, "starts");
        XMLParser.appendObjectWithTags(b, this.freeParams, "freeParams");
        XMLParser.appendObjectWithTags(b, this.initFrame, "initFrame");
        XMLParser.addTags(b, this.getClass().getSimpleName());
        return b;
    }

    @Override
    public double[] getCurrentParameterValues() {
        int l = this.optimize ? this.offset[this.period - 1][this.order + 1] : 0;
        double[] erg = new double[l];
        if (this.optimize) {
            int p;
            int stop;
            int i = 0;
            if (this.optimizeFrame) {
                stop = this.period - (this.freeParams ? 1 : 0);
                p = 0;
                while (p < stop) {
                    erg[i] = this.frameParams[p];
                    ++p;
                    ++i;
                }
            }
            stop = this.powers[1] - (this.freeParams ? 1 : 0);
            for (p = 0; p < this.period; ++p) {
                for (int o = 0; o <= this.order; ++o) {
                    for (int index = 0; index < this.params[p][o].length; index += this.powers[1]) {
                        int j = 0;
                        while (j < stop) {
                            erg[i] = this.params[p][o][index + j];
                            ++j;
                            ++i;
                        }
                    }
                }
            }
        }
        return erg;
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) {
        if (this.optimize && this.plugIn && data != null && data[index] != null) {
            int anz = data[index].getNumberOfElements();
            double w = 1.0;
            boolean externalWeights = weights != null && weights[index] != null;
            int rMax = this.initFrame >= 0 ? 1 : 3;
            double[][] frameP = new double[anz][this.period];
            if (this.initFrame < 0) {
                this.initializeFunctionRandomly(freeParams);
            }
            for (int r = 0; r < rMax; ++r) {
                int indexOld;
                int indexNew;
                int len;
                int o;
                int p;
                for (int i = 0; i < anz; ++i) {
                    if (this.initFrame < 0) {
                        this.fillFrameLogScores(data[index].getElementAt(i), 0, this.length);
                        Normalisation.logSumNormalisation(this.frameLogScore, 0, this.period, frameP[i], 0);
                        continue;
                    }
                    Arrays.fill(frameP[i], 0.0);
                    frameP[i][this.initFrame] = 1.0;
                }
                for (p = 0; p < this.period; ++p) {
                    for (o = 0; o <= this.order; ++o) {
                        System.arraycopy(this.hyper[p][o], 0, this.params[p][o], 0, this.hyper[p][o].length);
                        int n = 0;
                        for (int idx = 0; idx < this.params[p][o].length; idx += this.powers[1]) {
                            this.logNorm[p][o][n] = 0.0;
                            for (int j = 0; j < this.powers[1]; ++j) {
                                double[] dArray = this.logNorm[p][o];
                                int n2 = n;
                                dArray[n2] = dArray[n2] + this.hyper[p][o][idx + j];
                            }
                            ++n;
                        }
                    }
                }
                if (this.optimizeFrame) {
                    System.arraycopy(this.frameHyper, 0, this.frameProbs, 0, this.period);
                    this.logFrameNorm = this.getESS();
                }
                for (int i = 0; i < anz; ++i) {
                    int l;
                    Sequence seq = data[index].getElementAt(i);
                    len = seq.getLength();
                    o = Math.min(len, this.order);
                    indexNew = 0;
                    if (externalWeights) {
                        w = weights[index][i];
                    }
                    if (this.optimizeFrame) {
                        for (p = 0; p < this.period; ++p) {
                            double[] dArray = frameP[i];
                            int n = p;
                            dArray[n] = dArray[n] * w;
                            int n3 = p;
                            this.frameProbs[n3] = this.frameProbs[n3] + frameP[i][p];
                        }
                        this.logFrameNorm += w;
                    }
                    for (l = 0; l < o; ++l) {
                        indexOld = indexNew;
                        indexNew = indexOld * this.powers[1] + seq.discreteVal(l);
                        for (p = 0; p < this.period; ++p) {
                            double[] dArray = this.probs[(p + l) % this.period][l];
                            int n = indexNew;
                            dArray[n] = dArray[n] + frameP[i][p];
                            double[] dArray2 = this.logNorm[(p + l) % this.period][l];
                            int n4 = indexOld;
                            dArray2[n4] = dArray2[n4] + frameP[i][p];
                        }
                    }
                    while (l < len) {
                        indexOld = indexNew % this.powers[this.order];
                        indexNew = indexOld * this.powers[1] + seq.discreteVal(l);
                        for (p = 0; p < this.period; ++p) {
                            double[] dArray = this.probs[(p + l) % this.period][this.order];
                            int n = indexNew;
                            dArray[n] = dArray[n] + frameP[i][p];
                            double[] dArray3 = this.logNorm[(p + l) % this.period][this.order];
                            int n5 = indexOld;
                            dArray3[n5] = dArray3[n5] + frameP[i][p];
                        }
                        ++l;
                    }
                }
                if (this.optimizeFrame) {
                    for (p = 0; p < this.period; ++p) {
                        int n = p;
                        this.frameProbs[n] = this.frameProbs[n] / this.logFrameNorm;
                        this.frameParams[p] = Math.log(this.frameProbs[p]);
                    }
                    this.logFrameNorm = 0.0;
                }
                for (p = 0; p < this.period; ++p) {
                    for (o = 0; o <= this.order; ++o) {
                        indexNew = 0;
                        for (indexOld = 0; indexOld < this.logNorm[p][o].length; ++indexOld) {
                            len = 0;
                            while (len < this.powers[1]) {
                                double[] dArray = this.probs[p][o];
                                int n = indexNew;
                                dArray[n] = dArray[n] / this.logNorm[p][o][indexOld];
                                this.params[p][o][indexNew] = Math.log(this.probs[p][o][indexNew]);
                                ++len;
                                ++indexNew;
                            }
                            this.logNorm[p][o][indexOld] = 0.0;
                        }
                    }
                }
            }
        } else {
            this.initializeFunctionRandomly(freeParams);
        }
        this.setFreeParams(freeParams);
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) {
        if (this.optimize) {
            int p;
            double[] freq;
            DirichletMRGParams hyper;
            double[] currentHyper = new double[this.powers[1]];
            if (this.optimizeFrame) {
                hyper = new DirichletMRGParams(this.frameHyper);
                freq = DirichletMRG.DEFAULT_INSTANCE.generate(this.period, hyper);
                for (p = 0; p < this.period; ++p) {
                    this.frameProbs[p] = freq[p];
                    this.frameParams[p] = Math.log(freq[p]);
                }
                this.logFrameNorm = 0.0;
            }
            freq = new double[this.powers[1]];
            for (p = 0; p < this.period; ++p) {
                for (int o = 0; o <= this.order; ++o) {
                    int paramCounter = 0;
                    for (int normCounter = 0; normCounter < this.logNorm[p][o].length; ++normCounter) {
                        int len;
                        this.logNorm[p][o][normCounter] = 0.0;
                        for (len = 0; len < this.powers[1]; ++len) {
                            currentHyper[len] = this.hyper[p][o][paramCounter + len];
                        }
                        hyper = new DirichletMRGParams(currentHyper);
                        DirichletMRG.DEFAULT_INSTANCE.generate(freq, 0, this.powers[1], hyper);
                        len = 0;
                        while (len < this.powers[1]) {
                            this.probs[p][o][paramCounter] = freq[len];
                            this.params[p][o][paramCounter] = Math.log(freq[len]);
                            ++len;
                            ++paramCounter;
                        }
                    }
                }
            }
            this.setFreeParams(freeParams);
        }
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        int p;
        StringBuffer b = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.length = XMLParser.extractObjectForTags(b, "length", Integer.TYPE);
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(b, "alphabets");
        this.order = XMLParser.extractObjectForTags(b, "order", Integer.TYPE);
        this.period = XMLParser.extractObjectForTags(b, "period", Integer.TYPE);
        this.createArrays();
        StringBuffer help = XMLParser.extractForTag(b, "frameEss");
        if (help == null) {
            this.frameHyper = CyclicMarkovModelDiffSM.getHyper(this.period, XMLParser.extractObjectForTags(b, "classEss", Double.TYPE) / (double)this.period);
            this.hyper = CyclicMarkovModelDiffSM.getHyper(this.period, this.powers[1], XMLParser.extractObjectForTags(b, "sumOfHyperParams", double[].class));
        } else {
            XMLParser.addTags(help, "frameEss");
            this.frameHyper = (double[])XMLParser.extractObjectForTags(help, "frameEss");
            this.hyper = (double[][][])XMLParser.extractObjectForTags(b, "hyper");
        }
        this.frameParams = XMLParser.extractObjectForTags(b, "frameParams", double[].class);
        this.logFrameNorm = 0.0;
        this.params = new double[this.period][][];
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (p = 0; p < this.period; ++p) {
            this.frameProbs[p] = Math.exp(this.frameParams[p]);
            this.logFrameNorm += this.frameProbs[p];
            map.clear();
            map.put("frame", "" + p);
            this.params[p] = XMLParser.extractObjectAndAttributesForTags(b, "params", null, map, double[][].class);
            for (int o = 0; o <= this.order; ++o) {
                this.probs[p][o] = new double[this.params[p][o].length];
                this.logNorm[p][o] = new double[this.powers[o]];
                int index = 0;
                for (int n = 0; n < this.logNorm[p][o].length; ++n) {
                    int j;
                    this.logNorm[p][o][n] = 0.0;
                    for (j = 0; j < this.powers[1]; ++j) {
                        this.probs[p][o][index + j] = Math.exp(this.params[p][o][index + j]);
                        double[] dArray = this.logNorm[p][o];
                        int n2 = n;
                        dArray[n2] = dArray[n2] + this.probs[p][o][index + j];
                    }
                    for (j = 0; j < this.powers[1]; ++j) {
                        double[] dArray = this.probs[p][o];
                        int n3 = index++;
                        dArray[n3] = dArray[n3] / this.logNorm[p][o][n];
                    }
                    this.logNorm[p][o][n] = Math.log(this.logNorm[p][o][n]);
                }
            }
        }
        p = 0;
        while (p < this.period) {
            int n = p++;
            this.frameProbs[n] = this.frameProbs[n] / this.logFrameNorm;
        }
        this.logFrameNorm = Math.log(this.logFrameNorm);
        this.plugIn = XMLParser.extractObjectForTags(b, "plugIn", Boolean.TYPE);
        this.optimize = XMLParser.extractObjectForTags(b, "optimize", Boolean.TYPE);
        this.optimizeFrame = XMLParser.extractObjectForTags(b, "optimizeFrame", Boolean.TYPE);
        this.starts = XMLParser.extractObjectForTags(b, "starts", Integer.TYPE);
        this.setFreeParams(XMLParser.extractObjectForTags(b, "freeParams", Boolean.TYPE));
        this.initFrame = XMLParser.extractObjectForTags(b, "initFrame", Integer.TYPE);
        this.computeConstantsOfLogPrior();
    }

    private void setFreeParams(boolean freeParams) {
        this.freeParams = freeParams;
        if (this.optimize) {
            for (int p = 0; p < this.period; ++p) {
                if (p == 0) {
                    this.offset[0][0] = this.optimizeFrame ? this.period - (freeParams ? 1 : 0) : 0;
                } else {
                    this.offset[p][0] = this.offset[p - 1][this.order + 1];
                }
                for (int o = 0; o <= this.order; ++o) {
                    this.offset[p][o + 1] = this.offset[p][o] + this.params[p][o].length - (freeParams ? this.powers[o] : 0);
                }
            }
        } else {
            this.offset[this.period - 1][this.order + 1] = 0;
        }
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        if (index < this.offset[0][0]) {
            return this.period;
        }
        int p = 0;
        while (index >= this.offset[p][this.order + 1]) {
            ++p;
        }
        int o = 1;
        while (index >= this.offset[p][o]) {
            ++o;
        }
        return this.powers[o - 1];
    }

    @Override
    public double getLogNormalizationConstant(int length) {
        return 0.0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex, int length) throws Exception {
        if (parameterIndex < this.offset[this.period - 1][this.order + 1]) {
            return Double.NEGATIVE_INFINITY;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double getESS() {
        double ess = 0.0;
        for (int f = 0; f < this.frameHyper.length; ++f) {
            ess += this.frameHyper[f];
        }
        return ess;
    }

    public String toString() {
        int i;
        DiscreteAlphabet abc = (DiscreteAlphabet)this.alphabets.getAlphabetAt(0);
        int l = (int)abc.length();
        StringBuffer info = new StringBuffer((int)Math.pow(l, this.order) * l * this.period * 15);
        String[] sym = new String[l];
        --l;
        for (i = 0; i <= l; ++i) {
            sym[i] = abc.getSymbolAt(i);
        }
        int[] context = new int[this.order + 1];
        for (int p = 0; p < this.period; ++p) {
            info.append("frame " + p + ": p(" + p + ") = " + this.frameProbs[p] + "\n");
            for (i = 0; i <= l; ++i) {
                info.append("\t" + sym[i]);
            }
            info.append("\n");
            for (int o = 0; o <= this.order; ++o) {
                info.append("P(X_" + o);
                for (i = 0; i < o; ++i) {
                    if (i == 0) {
                        info.append("|");
                    } else {
                        info.append(" ");
                    }
                    info.append("X_" + i);
                }
                info.append(")\n");
                Arrays.fill(context, 0);
                int index = 0;
                while (index < this.probs[p][o].length) {
                    for (i = 0; i < o; ++i) {
                        info.append(sym[context[i]]);
                    }
                    i = 0;
                    while (i <= l) {
                        info.append("\t" + this.probs[p][o][index] + "\t(" + this.hyper[p][o][index] + ")");
                        ++i;
                        ++index;
                    }
                    info.append("\n");
                    for (i = o - 1; i >= 0 && context[i] == l; --i) {
                        context[i] = 0;
                    }
                    if (i < 0) continue;
                    int n = i;
                    context[n] = context[n] + 1;
                }
                info.append("\n");
            }
        }
        return info.toString();
    }

    @Override
    public double getLogPriorTerm() {
        if (this.optimize) {
            double classESS = this.getESS();
            double val = -classESS * this.logFrameNorm;
            int A = (int)this.alphabets.getAlphabetLengthAt(0);
            for (int f = 0; f < this.params.length; ++f) {
                val += this.frameParams[f] * this.frameHyper[f];
                for (int o = 0; o < this.params[f].length; ++o) {
                    double sum = 0.0;
                    int a = 0;
                    for (int i = 0; i < this.params[f].length; ++i) {
                        val += this.params[f][o][i] * this.hyper[f][o][i];
                        sum += this.hyper[f][o][i];
                        if (++a != A) continue;
                        val -= this.logNorm[f][o][i / A] * sum;
                        sum = 0.0;
                        a = 0;
                    }
                }
            }
            return val + this.logGammaSum;
        }
        return 0.0;
    }

    private double getLogPriorTerm(int offset) {
        if (this.optimize) {
            double classESS = this.getESS();
            double val = -classESS * this.logFrameNorm;
            int A = (int)this.alphabets.getAlphabetLengthAt(0);
            for (int f = 0; f < this.params.length; ++f) {
                val += this.frameParams[f] * this.frameHyper[(f + offset) % this.period];
                for (int o = 0; o < this.params[f].length; ++o) {
                    double sum = 0.0;
                    int a = 0;
                    for (int i = 0; i < this.params[f].length; ++i) {
                        val += this.params[f][o][i] * this.hyper[(f + offset) % this.period][o][i];
                        sum += this.hyper[(f + offset) % this.period][o][i];
                        if (++a != A) continue;
                        val -= this.logNorm[f][o][i / A] * sum;
                        sum = 0.0;
                        a = 0;
                    }
                }
            }
            return val + this.logGammaSum;
        }
        return 0.0;
    }

    private void computeConstantsOfLogPrior() {
        double classESS = this.getESS();
        double sum = 0.0;
        int A = (int)this.alphabets.getAlphabetLengthAt(0);
        this.logGammaSum = Gamma.logOfGamma((double)classESS);
        for (int f = 0; f < this.params.length; ++f) {
            this.logGammaSum -= Gamma.logOfGamma((double)this.frameHyper[f]);
            for (int o = 0; o < this.params[f].length; ++o) {
                int a = 0;
                for (int i = 0; i < this.params[f][o].length; ++i) {
                    this.logGammaSum -= Gamma.logOfGamma((double)this.hyper[f][o][i]);
                    sum += this.hyper[f][o][i];
                    if (++a != A) continue;
                    this.logGammaSum = Gamma.logOfGamma((double)sum);
                    sum = 0.0;
                    a = 0;
                }
            }
        }
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) {
        if (this.optimize) {
            int p;
            int j;
            if (this.optimizeFrame) {
                double classESS = this.getESS();
                j = this.period - (this.freeParams ? 1 : 0);
                for (p = 0; p < j; ++p) {
                    int n = start++;
                    grad[n] = grad[n] + (this.frameHyper[p] - classESS * this.frameProbs[p]);
                }
            }
            double sum = 0.0;
            int stop = this.powers[1] - (this.freeParams ? 1 : 0);
            for (p = 0; p < this.params.length; ++p) {
                for (int o = 0; o < this.params[p].length; ++o) {
                    for (int index = 0; index < this.params[p][o].length; index += this.powers[1]) {
                        sum = 0.0;
                        for (j = 0; j < this.powers[1]; ++j) {
                            sum += this.hyper[p][o][index + j];
                        }
                        for (j = 0; j < stop; ++j) {
                            int n = start++;
                            grad[n] = grad[n] + (this.hyper[p][o][index + j] - sum * this.probs[p][o][index + j]);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean isNormalized() {
        return true;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        return this.starts;
    }

    public void setParameterOptimization(boolean optimize) {
        this.optimize = optimize;
        this.setFreeParams(this.freeParams);
    }

    public void setFrameParameterOptimization(boolean optimize) {
        this.optimizeFrame = optimize;
        this.setFreeParams(this.freeParams);
    }

    @Override
    public void setStatisticForHyperparameters(int[] length, double[] weight) throws Exception {
        throw new RuntimeException();
    }

    @Override
    public int[][] getSamplingGroups(int parameterOffset) {
        if (this.optimize) {
            int j;
            int[][] res = new int[this.optimizeFrame ? 1 : 0 + this.offset[this.period - 1][this.order + 1] % this.powers[1]][];
            int i = 0;
            if (this.optimizeFrame) {
                res[i] = new int[this.period];
                for (j = 0; j < res[i].length; ++j) {
                    res[i][j] = parameterOffset++;
                }
                ++i;
            }
            while (i < res.length) {
                res[i] = new int[this.powers[1]];
                for (j = 0; j < res[i].length; ++j) {
                    res[i][j] = parameterOffset++;
                }
                ++i;
            }
            return res;
        }
        return new int[0][];
    }
}

