/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;

public class UniformHomogeneousDiffSM
extends HomogeneousDiffSM {
    private double ess;
    private double p;
    private double logP;

    public UniformHomogeneousDiffSM(AlphabetContainer alphabets, double ess) {
        super(alphabets);
        if (ess < 0.0) {
            throw new IllegalArgumentException("The given ess has to be non-negative.");
        }
        this.ess = ess;
        this.computeLogP();
    }

    private void computeLogP() {
        this.p = 1.0 / this.alphabets.getAlphabetLengthAt(0);
        this.logP = Math.log(this.p);
    }

    public UniformHomogeneousDiffSM(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getInstanceName() {
        return "uniform";
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start, int end) {
        return (double)(end - start + 1) * this.logP;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, int end, IntList indices, DoubleList dList) {
        return this.getLogScoreFor(seq, start, end);
    }

    @Override
    public int getNumberOfParameters() {
        return 0;
    }

    @Override
    public void setParameters(double[] params, int start) {
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer b = new StringBuffer(1000);
        XMLParser.appendObjectWithTags(b, this.length, "length");
        XMLParser.appendObjectWithTags(b, this.alphabets, "alphabets");
        XMLParser.appendObjectWithTags(b, this.ess, "ess");
        XMLParser.addTags(b, this.getClass().getSimpleName());
        return b;
    }

    @Override
    public double getLogNormalizationConstant(int length) {
        return 0.0;
    }

    @Override
    public void initializeFunction(int index, boolean meila, DataSet[] data, double[][] weights) {
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        StringBuffer b = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.length = XMLParser.extractObjectForTags(b, "length", Integer.TYPE);
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(b, "alphabets");
        this.ess = XMLParser.extractObjectForTags(b, "ess", Double.TYPE);
        this.computeLogP();
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex, int length) throws Exception {
        throw new IndexOutOfBoundsException("Since a uniform scoring function has no parameters, this method can not be used");
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    public String toString() {
        return this.p + " for each element of " + this.alphabets.getAlphabetAt(0).toString();
    }

    @Override
    public double getLogPriorTerm() {
        return 0.0;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) {
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        return new double[0];
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public boolean isNormalized() {
        return true;
    }

    @Override
    public byte getMaximalMarkovOrder() {
        return 0;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
    }

    @Override
    public void setStatisticForHyperparameters(int[] length, double[] weights) throws Exception {
    }

    @Override
    public void initializeUniformly(boolean freeParams) {
    }

    @Override
    public int[][] getSamplingGroups(int parameterOffset) {
        return new int[0][];
    }
}

