/*
 * Decompiled with CFR 0.152.
 */
package latexlet;

import com.sun.javadoc.Doc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.standard.Standard;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.LinkedList;

public abstract class LaTeXlet
implements Taglet {
    private static int count;
    private static String docclass;
    private static String begindoc;
    private static String enddoc;
    private static String preambleTag;
    private static String preambleStart;
    private static String preambleEnd;
    private static String resolutionStart;
    private static String resolutionEnd;
    private static String noams;
    private static int preLength;
    static final String imagePath;
    private byte[] buffer;
    private static Hashtable<String, Hashtable<String, LinkedList<String>>> imageMapper;

    protected abstract String getImgInfix();

    private String getClassName(Tag tag) {
        String temp = tag.position().file().getName();
        return temp.substring(0, temp.length() - 5);
    }

    protected abstract boolean isOneLine();

    public boolean inConstructor() {
        return true;
    }

    public boolean inField() {
        return true;
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inOverview() {
        return true;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    private String getBaseForTag(Tag tag) {
        return this.getBaseForTag(tag.position().file().getAbsolutePath());
    }

    String getBaseForTag(String suff) {
        String base = Standard.htmlDoclet.configuration().destDirName;
        base = new File(base).getAbsolutePath();
        String sp = Standard.htmlDoclet.configuration().sourcepath;
        String[] sps = sp.split(File.pathSeparator);
        int preL = 0;
        for (String s : sps) {
            if (!suff.startsWith(s = new File(s).getAbsolutePath()) || s.length() <= preL) continue;
            preL = s.length();
        }
        suff = suff.substring(preL);
        suff = suff.substring(0, suff.lastIndexOf(File.separator) + 1);
        base = base + suff;
        return base;
    }

    private int waitForProcess(Process p, Tag t) throws IOException, InterruptedException {
        StringBuffer buf = new StringBuffer();
        StringBuffer buf2 = new StringBuffer();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader r2 = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        String tmp = null;
        String tmp2 = null;
        while ((tmp = r.readLine()) != null || (tmp2 = r2.readLine()) != null) {
            if (tmp != null) {
                buf.append(tmp + "\n");
            }
            if (tmp2 == null) continue;
            buf2.append(tmp2 + "\n");
        }
        int ret = p.waitFor();
        if (ret != 0) {
            System.err.println("##########################");
            System.err.println("Problem in comment on " + t.holder().toString() + " in file " + t.position().file() + ", line " + t.position().line() + " for code:");
            System.err.println(t.text());
            System.err.println("--------------------------");
            if (buf.length() > 0) {
                System.err.println("OUTPUT:");
                System.err.print(buf.toString());
            }
            if (buf2.length() > 0) {
                System.err.println("ERROR:");
                System.err.print(buf2.toString());
            }
            System.err.println("##########################");
        }
        return ret;
    }

    private String[] generateImagesForTags(Tag ... allTags) throws Exception {
        LinkedList<String> images = new LinkedList<String>();
        for (Tag tag : allTags) {
            String key1 = tag.position().file().getAbsolutePath();
            Hashtable<String, LinkedList<String>> map = imageMapper.get(key1);
            boolean add = map == null;
            String key2 = tag.text();
            LinkedList<String> list = !add ? map.get(key2) : null;
            if (list == null) {
                ++count;
                File workDir = new File(this.getBaseForTag(tag) + imagePath);
                if (!workDir.exists()) {
                    workDir.mkdirs();
                }
                File[] before = workDir.listFiles();
                String filepath = workDir.getAbsolutePath() + File.separator + "doc.tex";
                File tex = new File(filepath);
                try {
                    PrintWriter wr = new PrintWriter(tex);
                    wr.println(docclass);
                    String[] preTex = this.extractLaTeXAndPreambleAndResolutionFrom(tag);
                    wr.println(preTex[0]);
                    wr.println(begindoc);
                    wr.println(preTex[1]);
                    wr.println(enddoc);
                    wr.close();
                    Process p = Runtime.getRuntime().exec(new String[]{"latex", "-interaction=nonstopmode", "doc.tex"}, null, workDir);
                    this.waitForProcess(p, tag);
                    p = Runtime.getRuntime().exec(new String[]{"dvipng", "-T", "tight", "-D", preTex[2] == null ? "130" : preTex[2], "-o", this.getClassName(tag) + "_" + this.getImgInfix() + count + "_%d.png", "doc.dvi"}, null, workDir);
                    this.waitForProcess(p, tag);
                    File[] files = workDir.listFiles();
                    if (map == null) {
                        map = new Hashtable();
                        add = true;
                    }
                    list = new LinkedList();
                    for (int i = 0; i < files.length; ++i) {
                        String n = files[i].getName();
                        String nl = n.toLowerCase();
                        if (!LaTeXlet.containedIn(files[i], before) && !nl.endsWith(".png")) {
                            files[i].delete();
                            continue;
                        }
                        if (!nl.endsWith(".png") || !n.startsWith(this.getClassName(tag) + "_" + this.getImgInfix() + count + "_")) continue;
                        images.add(n);
                        list.add(n);
                    }
                    map.put(key2, list);
                    if (add) {
                        imageMapper.put(key1, map);
                    }
                    this.copyForIndex(tag, list, workDir);
                    continue;
                }
                catch (IOException e) {
                    Exception ex = new Exception("Could not write to " + tex.getAbsolutePath() + " for tag \"" + tag.text() + "\": " + e.getMessage());
                    ex.setStackTrace(e.getStackTrace());
                    throw ex;
                }
            }
            images.addAll(list);
        }
        return images.toArray(new String[0]);
    }

    private void copyForIndex(Tag tag, LinkedList<String> images, File workDir) {
        Tag[] tags = tag.holder().firstSentenceTags();
        for (int i = 0; i < tags.length; ++i) {
            File dir;
            if (!tags[i].kind().equals(tag.kind()) || !tags[i].text().equals(tag.text()) || !(Standard.htmlDoclet.configuration() instanceof ConfigurationImpl)) continue;
            ConfigurationImpl ci = (ConfigurationImpl)Standard.htmlDoclet.configuration();
            if (!ci.createindex) continue;
            String sp = ci.destDirName;
            if (ci.splitindex) {
                sp = sp + File.separator + "index-files";
            }
            if (!(dir = new File(sp)).exists()) {
                dir.mkdir();
            }
            LaTeXlet.copy(workDir.getAbsolutePath(), sp + File.separator + imagePath, images.toArray(new String[0]));
        }
    }

    public static void copy(String from, String to, String[] images) {
        File dir = new File(to);
        File workDir = new File(from);
        if (dir.equals(workDir)) {
            return;
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        byte[] buffer = new byte[10000];
        for (String img : images) {
            try {
                int amountRead;
                FileInputStream in = new FileInputStream(workDir.getAbsolutePath() + File.separator + img);
                FileOutputStream out = new FileOutputStream(dir.getAbsolutePath() + File.separator + img);
                while ((amountRead = in.read(buffer)) > -1) {
                    out.write(buffer, 0, amountRead);
                }
                in.close();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String[] extractLaTeXAndPreambleAndResolutionFrom(Tag tag) {
        String pre = null;
        StringBuffer texBuf = new StringBuffer();
        String res = null;
        String text = tag.text();
        int start = text.indexOf(resolutionStart);
        if (start > -1) {
            int end = text.indexOf(resolutionEnd, start + 1);
            res = text.substring(start + resolutionStart.length(), end);
            text = text.substring(0, start) + text.substring(end + 1);
        }
        start = text.indexOf(noams);
        boolean ams = true;
        if (start > -1) {
            text = text.substring(0, start) + text.substring(start + noams.length() + 1);
            ams = false;
        }
        if (text.indexOf(preambleTag) > -1) {
            String aft;
            start = text.indexOf(preambleTag + preambleStart);
            int end = this.findEnd(text, start + preLength);
            pre = text.substring(start + preLength, end);
            String bef = text.substring(0, start);
            if (!bef.matches("\\s*")) {
                texBuf.append(this.unescapeString(bef, tag.position()));
            }
            if (!(aft = text.substring(end + 1)).matches("\\s*")) {
                texBuf.append(this.unescapeString(aft, tag.position()));
            }
        } else {
            texBuf.append(this.unescapeString(text, tag.position()));
        }
        StringBuffer buf = new StringBuffer();
        if (ams) {
            buf.append("\\usepackage{amssymb}");
        }
        if (pre != null) {
            buf.append(this.unescapeString(pre, tag.position()));
        }
        return new String[]{buf.toString(), texBuf.toString(), res};
    }

    private String unescapeString(String pr, SourcePosition pos) {
        StringWriter wr = new StringWriter();
        char[] chars = pr.toCharArray();
        boolean esc = false;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\\') {
                if (esc) {
                    wr.write("\\");
                    esc = false;
                    continue;
                }
                esc = true;
                continue;
            }
            if (esc) {
                if (chars[i] == 'n') {
                    wr.write("\n");
                    continue;
                }
                if (chars[i] == 'r') {
                    wr.write("\r");
                    continue;
                }
                if (chars[i] == 't') {
                    wr.write("\t");
                    continue;
                }
                if (chars[i] == '\"') {
                    wr.write("\"");
                    continue;
                }
                if (chars[i] == '\'') {
                    wr.write("'");
                    continue;
                }
                if (chars[i] == ' ') continue;
                System.err.println("WARNING: Possible unescaped \\ for comment on line " + pos.line() + " of " + pos.file().getName());
                continue;
            }
            wr.write(chars[i]);
        }
        return wr.toString();
    }

    private int findEnd(String text, int start) {
        int open = 1;
        while (open > 0) {
            int s = text.indexOf(preambleStart, ++start);
            int e = text.indexOf(preambleEnd, start);
            if (s > -1 && s < e) {
                ++open;
                start = s;
            } else if (e > -1) {
                --open;
                start = e;
            }
            if (e != -1 || s != -1 || open <= 0) continue;
            throw new RuntimeException("Could not find end of preamble in " + text.substring(start));
        }
        return start;
    }

    private static boolean containedIn(File file, File ... before) {
        for (File bef : before) {
            if (!bef.getAbsolutePath().equals(file.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    public String toString(Tag tag) {
        StringBuffer buf = new StringBuffer();
        if (!this.isInlineTag()) {
            buf.append("<br /><DT><b>LaTeX:</b></DT><br />\n");
        }
        if (!this.isOneLine()) {
            buf.append("<DL><DD>");
        }
        try {
            String[] ar;
            for (String img : ar = this.generateImagesForTags(tag)) {
                String text;
                int idx = (text = this.unescapeString(tag.text(), tag.position())).indexOf("\n");
                text = text.substring(0, idx > -1 ? idx : text.length());
                buf.append("<img style=\"vertical-align:middle\" alt=\"" + text + "\" src=\"" + imagePath + img + "\" />");
                if (ar.length <= 1) continue;
                buf.append("<br />");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            buf.append(this.extractLaTeXAndPreambleAndResolutionFrom(tag)[1]);
        }
        if (!this.isOneLine()) {
            buf.append("</DD></DL>");
        }
        return buf.toString();
    }

    public String toString(Tag[] tags) {
        StringBuffer buf = new StringBuffer();
        if (!this.isInlineTag()) {
            buf.append("<br /><DT><b>LaTeX:</b></DT><br />\n");
        }
        if (!this.isOneLine()) {
            buf.append("<DL><DD>");
        }
        try {
            String[] ar;
            if (tags.length < 1) {
                return "";
            }
            for (String img : ar = this.generateImagesForTags(tags)) {
                int idx;
                String text;
                if (ar.length > 1) {
                    buf.append("<p>");
                }
                text = text.substring(0, (idx = (text = this.unescapeString(tags[0].text(), tags[0].position())).indexOf("\n")) > -1 ? idx : text.length());
                buf.append("<img style=\"vertical-align:middle\" alt=\"" + text + "\" src=\"" + imagePath + img + "\" />");
                if (ar.length <= 1) continue;
                buf.append("</p>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            for (Tag t : tags) {
                buf.append(this.extractLaTeXAndPreambleAndResolutionFrom(t)[1]);
            }
        }
        if (!this.isOneLine()) {
            buf.append("<br /><br /></DD></DL>");
        }
        return buf.toString();
    }

    static {
        if (System.getProperty("LaTeXlet.init") == null) {
            System.out.println("*********************************************************************************\n* LaTeXlet is free software: you can redistribute it and/or modify it under the *\n* terms of the GNU General Public License as published by the Free Software     *\n* Foundation, either version 3 of the License, or (at your option) any later    *\n* version.                                                                      *\n*                                                                               *\n* LaTeXlet is distributed in the hope that it will be useful, but WITHOUT ANY   *\n* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR *\n* A PARTICULAR PURPOSE. See the GNU General Public License for more details.    *\n*********************************************************************************");
            System.setProperty("LaTeXlet.init", "true");
        }
        count = 0;
        docclass = "\\documentclass{article}\n";
        begindoc = "\\begin{document}\n\\pagestyle{empty}";
        enddoc = "\n\\end{document}";
        preambleTag = "%preamble";
        preambleStart = "{";
        preambleEnd = "}";
        resolutionStart = "%resolution{";
        resolutionEnd = "}";
        noams = "%noams";
        preLength = preambleTag.length() + preambleStart.length();
        imagePath = "images" + File.separator;
        imageMapper = new Hashtable();
    }

    private static class MyTagImpl
    implements Tag {
        private Tag original;
        private SourcePosition pos;
        private Doc holder;

        public MyTagImpl(Tag original, SourcePosition pos, Doc holder) {
            this.original = original;
            this.pos = pos;
            this.holder = holder;
        }

        public Tag[] firstSentenceTags() {
            return this.original.firstSentenceTags();
        }

        public Doc holder() {
            return this.holder;
        }

        public Tag[] inlineTags() {
            return this.original.inlineTags();
        }

        public String kind() {
            return this.original.kind();
        }

        public String name() {
            return this.original.name();
        }

        public SourcePosition position() {
            return this.pos;
        }

        public String text() {
            return this.original.text();
        }
    }
}

