/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.mixture.motif;

import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.sampling.BurnInTest;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.AbstractMixtureTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.motif.positionprior.PositionPrior;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.naming.OperationNotSupportedException;

public abstract class HiddenMotifMixture
extends AbstractMixtureTrainSM
implements MotifDiscoverer {
    protected PositionPrior posPrior;

    protected HiddenMotifMixture(TrainableStatisticalModel[] models, boolean[] optimzeArray, int components, int starts, boolean estimateComponentProbs, double[] componentHyperParams, double[] weights, PositionPrior posPrior, AbstractMixtureTrainSM.Algorithm algorithm, double alpha, TerminationCondition tc, AbstractMixtureTrainSM.Parameterization parametrization, int initialIteration, int stationaryIteration, BurnInTest burnInTest) throws CloneNotSupportedException, IllegalArgumentException, WrongAlphabetException {
        super(posPrior.getLength(), models, optimzeArray, components, starts, estimateComponentProbs, componentHyperParams, weights, algorithm, alpha, tc, parametrization, initialIteration, stationaryIteration, burnInTest);
        if (!this.alphabets.isSimple()) {
            throw new WrongAlphabetException("The AlphabetContainer has to be simple.");
        }
        this.posPrior = posPrior.clone();
        this.posPrior.setMotifLength(this.getMotifLength(0));
    }

    protected HiddenMotifMixture(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public HiddenMotifMixture clone() throws CloneNotSupportedException {
        HiddenMotifMixture clone = (HiddenMotifMixture)super.clone();
        clone.posPrior = this.posPrior.clone();
        return clone;
    }

    @Override
    protected StringBuffer getFurtherInformation() {
        StringBuffer erg = new StringBuffer(1000);
        XMLParser.appendObjectWithTags(erg, this.posPrior, "posPrior");
        return erg;
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.posPrior = XMLParser.extractObjectForTags(xml, "posPrior", PositionPrior.class);
        this.posPrior.setMotifLength(this.getMotifLength(0));
    }

    @Override
    public void train(DataSet data, double[] weights) throws Exception {
        if (data.getMinimalElementLength() < this.getMinimalSequenceLength()) {
            throw new IllegalArgumentException("The data set contains sequence that are not allowed in this MotifDiscoverer. The minimal length is " + this.getMinimalSequenceLength() + ".");
        }
        super.train(data, weights);
    }

    @Override
    protected void getNewParameters(int iteration, double[][] seqWeights, double[] w) throws Exception {
        for (int i = 0; i < seqWeights.length; ++i) {
            this.getNewParametersForModel(i, iteration, i, seqWeights[i]);
        }
        this.getNewComponentProbs(w);
    }

    public abstract void trainBgModel(DataSet var1, double[] var2) throws Exception;

    @Override
    protected void checkLength(int index, int l) {
        if (index == 0) {
            if (this.length != 0 && this.length < l) {
                throw new IllegalArgumentException("The motif length is bigger than the length of the sequences the should be modeled.");
            }
        } else if (l != 0) {
            throw new IllegalArgumentException("All models accept the motif model have to be homogeneous. Violated at position " + index + ".");
        }
    }

    public abstract int getMinimalSequenceLength();

    @Override
    public String getInstanceName() {
        StringBuffer erg = new StringBuffer(this.getClass().getSimpleName() + "(");
        erg.append(this.model[0].getInstanceName());
        for (int i = 1; i < this.model.length; ++i) {
            erg.append(", ");
            erg.append(this.model[i].getInstanceName());
        }
        erg.append("; " + this.posPrior.getInstanceName());
        if (!this.estimateComponentProbs) {
            erg.append("; " + Arrays.toString(this.weights));
        }
        erg.append(")");
        return erg.toString();
    }

    @Override
    public String toString(NumberFormat nf) {
        StringBuffer sb = new StringBuffer(100000);
        sb.append(nf.format(this.weights[0]) + "\tmotif\n");
        sb.append(nf.format(this.weights[1]) + "\tno motif\n\n");
        sb.append("position prior: " + this.posPrior.getInstanceName() + "\n\n");
        for (int i = 0; i < this.dimension; ++i) {
            sb.append(this.model[i].getInstanceName() + "\n" + this.model[i].toString(nf) + "\n");
        }
        return sb.toString();
    }

    @Override
    protected Sequence[] emitDataSetUsingCurrentParameterSet(int n, int ... lengths) throws Exception {
        throw new OperationNotSupportedException();
    }
}

